export interface Limit {
	/**
	 * @param fn - Promise-returning/async function.
	 * @param arguments - Any arguments to pass through to `fn`. Support for passing arguments on to the `fn` is provided in order to be able to avoid creating unnecessary closures. You probably don't need this optimization unless you're pushing a lot of functions.
	 * @returns The promise returned by calling `fn(...arguments)`.
	 */
	<Arguments extends unknown[], ReturnType>(
		fn: (...arguments: Arguments) => PromiseLike<ReturnType> | ReturnType,
		...arguments: Arguments
	): Promise<ReturnType>;

	/**
	 * The number of promises that are currently running.
	 */
	readonly activeCount: number;

	/**
	 * The number of promises that are waiting to run (i.e. their internal `fn` was not called yet).
	 */
	readonly pendingCount: number;
}

/**
 * Run multiple promise-returning & async functions with limited concurrency.
 *
 * @param concurrency - Concurrency limit. Minimum: `1`.
 * @returns A `limit` function.
 */
export default function pLimit(concurrency: number): Limit;
