# Copyright 2014 the V8 project authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

# The sources are kept automatically in sync with BUILD.gn.

{
  'variables': {
    'v8_code': 1,
    'unittests_sources': [
      '../test/unittests/allocation-unittest.cc',
      '../test/unittests/api/access-check-unittest.cc',
      '../test/unittests/api/exception-unittest.cc',
      '../test/unittests/api/interceptor-unittest.cc',
      '../test/unittests/api/isolate-unittest.cc',
      '../test/unittests/api/remote-object-unittest.cc',
      '../test/unittests/api/v8-object-unittest.cc',
      '../test/unittests/asmjs/asm-scanner-unittest.cc',
      '../test/unittests/asmjs/asm-types-unittest.cc',
      '../test/unittests/asmjs/switch-logic-unittest.cc',
      '../test/unittests/base/atomic-utils-unittest.cc',
      '../test/unittests/base/bits-unittest.cc',
      '../test/unittests/base/cpu-unittest.cc',
      '../test/unittests/base/division-by-constant-unittest.cc',
      '../test/unittests/base/flags-unittest.cc',
      '../test/unittests/base/functional-unittest.cc',
      '../test/unittests/base/ieee754-unittest.cc',
      '../test/unittests/base/logging-unittest.cc',
      '../test/unittests/base/macros-unittest.cc',
      '../test/unittests/base/iterator-unittest.cc',
      '../test/unittests/base/ostreams-unittest.cc',
      '../test/unittests/base/platform/condition-variable-unittest.cc',
      '../test/unittests/base/platform/mutex-unittest.cc',
      '../test/unittests/base/platform/platform-unittest.cc',
      '../test/unittests/base/platform/semaphore-unittest.cc',
      '../test/unittests/base/platform/time-unittest.cc',
      '../test/unittests/base/sys-info-unittest.cc',
      '../test/unittests/base/template-utils-unittest.cc',
      '../test/unittests/base/utils/random-number-generator-unittest.cc',
      '../test/unittests/bigint-unittest.cc',
      '../test/unittests/cancelable-tasks-unittest.cc',
      '../test/unittests/char-predicates-unittest.cc',
      "../test/unittests/code-stub-assembler-unittest.cc",
      "../test/unittests/code-stub-assembler-unittest.h",
      '../test/unittests/compiler/branch-elimination-unittest.cc',
      '../test/unittests/compiler/bytecode-analysis-unittest.cc',
      '../test/unittests/compiler/checkpoint-elimination-unittest.cc',
      "../test/unittests/compiler/code-assembler-unittest.cc",
      "../test/unittests/compiler/code-assembler-unittest.h",
      '../test/unittests/compiler/common-operator-reducer-unittest.cc',
      '../test/unittests/compiler/common-operator-unittest.cc',
      '../test/unittests/compiler/compiler-test-utils.h',
      '../test/unittests/compiler/control-equivalence-unittest.cc',
      '../test/unittests/compiler/control-flow-optimizer-unittest.cc',
      '../test/unittests/compiler/dead-code-elimination-unittest.cc',
      '../test/unittests/compiler/diamond-unittest.cc',
      '../test/unittests/compiler/effect-control-linearizer-unittest.cc',
      '../test/unittests/compiler/graph-reducer-unittest.cc',
      '../test/unittests/compiler/graph-reducer-unittest.h',
      '../test/unittests/compiler/graph-trimmer-unittest.cc',
      '../test/unittests/compiler/graph-unittest.cc',
      '../test/unittests/compiler/graph-unittest.h',
      '../test/unittests/compiler/instruction-unittest.cc',
      '../test/unittests/compiler/instruction-selector-unittest.cc',
      '../test/unittests/compiler/instruction-selector-unittest.h',
      '../test/unittests/compiler/instruction-sequence-unittest.cc',
      '../test/unittests/compiler/instruction-sequence-unittest.h',
      '../test/unittests/compiler/int64-lowering-unittest.cc',
      '../test/unittests/compiler/js-builtin-reducer-unittest.cc',
      '../test/unittests/compiler/js-create-lowering-unittest.cc',
      '../test/unittests/compiler/js-intrinsic-lowering-unittest.cc',
      '../test/unittests/compiler/js-operator-unittest.cc',
      '../test/unittests/compiler/js-typed-lowering-unittest.cc',
      '../test/unittests/compiler/linkage-tail-call-unittest.cc',
      '../test/unittests/compiler/live-range-builder.h',
      '../test/unittests/compiler/regalloc/live-range-unittest.cc',
      '../test/unittests/compiler/load-elimination-unittest.cc',
      '../test/unittests/compiler/loop-peeling-unittest.cc',
      '../test/unittests/compiler/machine-operator-reducer-unittest.cc',
      '../test/unittests/compiler/machine-operator-unittest.cc',
      '../test/unittests/compiler/regalloc/move-optimizer-unittest.cc',
      '../test/unittests/compiler/node-cache-unittest.cc',
      '../test/unittests/compiler/node-matchers-unittest.cc',
      '../test/unittests/compiler/node-properties-unittest.cc',
      '../test/unittests/compiler/node-test-utils.cc',
      '../test/unittests/compiler/node-test-utils.h',
      '../test/unittests/compiler/node-unittest.cc',
      '../test/unittests/compiler/opcodes-unittest.cc',
      '../test/unittests/compiler/persistent-unittest.cc',
      '../test/unittests/compiler/regalloc/register-allocator-unittest.cc',
      '../test/unittests/compiler/schedule-unittest.cc',
      '../test/unittests/compiler/scheduler-unittest.cc',
      '../test/unittests/compiler/scheduler-rpo-unittest.cc',
      '../test/unittests/compiler/simplified-lowering-unittest.cc',
      '../test/unittests/compiler/simplified-operator-reducer-unittest.cc',
      '../test/unittests/compiler/simplified-operator-unittest.cc',
      '../test/unittests/compiler/state-values-utils-unittest.cc',
      '../test/unittests/compiler/typed-optimization-unittest.cc',
      '../test/unittests/compiler/typer-unittest.cc',
      '../test/unittests/compiler/value-numbering-reducer-unittest.cc',
      '../test/unittests/compiler/zone-stats-unittest.cc',
      '../test/unittests/compiler-dispatcher/compiler-dispatcher-tracer-unittest.cc',
      '../test/unittests/compiler-dispatcher/compiler-dispatcher-unittest.cc',
      '../test/unittests/compiler-dispatcher/optimizing-compile-dispatcher-unittest.cc',
      '../test/unittests/compiler-dispatcher/unoptimized-compile-job-unittest.cc',
      '../test/unittests/counters-unittest.cc',
      '../test/unittests/detachable-vector-unittest.cc',
      '../test/unittests/eh-frame-iterator-unittest.cc',
      '../test/unittests/eh-frame-writer-unittest.cc',
      '../test/unittests/heap/barrier-unittest.cc',
      '../test/unittests/heap/bitmap-unittest.cc',
      '../test/unittests/heap/embedder-tracing-unittest.cc',
      '../test/unittests/heap/gc-idle-time-handler-unittest.cc',
      '../test/unittests/heap/gc-tracer-unittest.cc',
      '../test/unittests/heap/item-parallel-job-unittest.cc',
      '../test/unittests/heap/marking-unittest.cc',
      '../test/unittests/heap/memory-reducer-unittest.cc',
      '../test/unittests/heap/object-stats-unittest.cc',
      '../test/unittests/heap/heap-unittest.cc',
      '../test/unittests/heap/scavenge-job-unittest.cc',
      '../test/unittests/heap/slot-set-unittest.cc',
      '../test/unittests/heap/spaces-unittest.cc',
      '../test/unittests/heap/unmapper-unittest.cc',
      '../test/unittests/heap/worklist-unittest.cc',
      '../test/unittests/interpreter/bytecodes-unittest.cc',
      '../test/unittests/interpreter/bytecode-array-builder-unittest.cc',
      '../test/unittests/interpreter/bytecode-array-iterator-unittest.cc',
      '../test/unittests/interpreter/bytecode-array-random-iterator-unittest.cc',
      '../test/unittests/interpreter/bytecode-array-writer-unittest.cc',
      '../test/unittests/interpreter/bytecode-decoder-unittest.cc',
      '../test/unittests/interpreter/bytecode-node-unittest.cc',
      '../test/unittests/interpreter/bytecode-operands-unittest.cc',
      '../test/unittests/interpreter/bytecode-register-allocator-unittest.cc',
      '../test/unittests/interpreter/bytecode-register-optimizer-unittest.cc',
      '../test/unittests/interpreter/bytecode-source-info-unittest.cc',
      '../test/unittests/interpreter/bytecode-utils.h',
      '../test/unittests/interpreter/constant-array-builder-unittest.cc',
      '../test/unittests/interpreter/interpreter-assembler-unittest.cc',
      '../test/unittests/interpreter/interpreter-assembler-unittest.h',
      '../test/unittests/libplatform/default-platform-unittest.cc',
      '../test/unittests/libplatform/task-queue-unittest.cc',
      '../test/unittests/libplatform/worker-thread-unittest.cc',
      '../test/unittests/locked-queue-unittest.cc',
      '../test/unittests/object-unittest.cc',
      '../test/unittests/parser/ast-value-unittest.cc',
      '../test/unittests/parser/preparser-unittest.cc',
      '../test/unittests/register-configuration-unittest.cc',
      '../test/unittests/run-all-unittests.cc',
      '../test/unittests/source-position-table-unittest.cc',
      '../test/unittests/test-helpers.cc',
      '../test/unittests/test-helpers.h',
      '../test/unittests/test-utils.h',
      '../test/unittests/test-utils.cc',
      '../test/unittests/unicode-unittest.cc',
      '../test/unittests/utils-unittest.cc',
      '../test/unittests/value-serializer-unittest.cc',
      '../test/unittests/zone/segmentpool-unittest.cc',
      '../test/unittests/zone/zone-allocator-unittest.cc',
      '../test/unittests/zone/zone-chunk-list-unittest.cc',
      '../test/unittests/zone/zone-unittest.cc',
      '../test/unittests/wasm/control-transfer-unittest.cc',
      '../test/unittests/wasm/decoder-unittest.cc',
      '../test/unittests/wasm/function-body-decoder-unittest.cc',
      '../test/unittests/wasm/wasm-code-manager-unittest.cc',
      '../test/unittests/wasm/leb-helper-unittest.cc',
      '../test/unittests/wasm/loop-assignment-analysis-unittest.cc',
      '../test/unittests/wasm/module-decoder-unittest.cc',
      '../test/unittests/wasm/streaming-decoder-unittest.cc',
      '../test/unittests/wasm/trap-handler-unittest.cc',
      '../test/unittests/wasm/wasm-macro-gen-unittest.cc',
      '../test/unittests/wasm/wasm-module-builder-unittest.cc',
      '../test/unittests/wasm/wasm-opcodes-unittest.cc',
    ],
    'unittests_sources_arm': [
      '../test/unittests/compiler/arm/instruction-selector-arm-unittest.cc',
    ],
    'unittests_sources_arm64': [
      '../test/unittests/compiler/arm64/instruction-selector-arm64-unittest.cc',
    ],
    'unittests_sources_ia32': [
      '../test/unittests/compiler/ia32/instruction-selector-ia32-unittest.cc',
    ],
    'unittests_sources_mips': [
      '../test/unittests/compiler/mips/instruction-selector-mips-unittest.cc',
    ],
    'unittests_sources_mips64': [
      '../test/unittests/compiler/mips64/instruction-selector-mips64-unittest.cc',
    ],
    'unittests_sources_x64': [
      '../test/unittests/compiler/x64/instruction-selector-x64-unittest.cc',
    ],
    'unittests_sources_ppc': [
      '../test/unittests/compiler/ppc/instruction-selector-ppc-unittest.cc',
    ],
    'unittests_sources_s390': [
      '../test/unittests/compiler/s390/instruction-selector-s390-unittest.cc',
    ],
  },
  'includes': ['toolchain.gypi', 'features.gypi'],
  'targets': [
    {
      'target_name': 'unittests',
      'type': 'executable',
      'variables': {
        'optimize': 'max',
      },
      'dependencies': [
        'gmock.gyp:gmock',
        'gtest.gyp:gtest',
        'v8.gyp:v8',
        'v8.gyp:v8_libbase',
        'v8.gyp:v8_libplatform',
        'v8.gyp:v8_maybe_snapshot',
      ],
      'include_dirs': [
        '..',
      ],
      'sources': [
        '<@(unittests_sources)',
      ],
      'conditions': [
        ['v8_target_arch=="arm"', {
          'sources': [
            '<@(unittests_sources_arm)',
          ],
        }],
        ['v8_target_arch=="arm64"', {
          'sources': [
            '<@(unittests_sources_arm64)',
          ],
        }],
        ['v8_target_arch=="ia32"', {
          'sources': [
            '<@(unittests_sources_ia32)',
          ],
        }],
        ['v8_target_arch=="mips"', {
          'sources': [
            '<@(unittests_sources_mips)',
          ],
        }],
        ['v8_target_arch=="mipsel"', {
          'sources': [
            '<@(unittests_sources_mips)',
          ],
        }],
        ['v8_target_arch=="mips64"', {
          'sources': [
            '<@(unittests_sources_mips64)',
          ],
        }],
        ['v8_target_arch=="mips64el"', {
          'sources': [
            '<@(unittests_sources_mips64)',
          ],
        }],
        ['v8_target_arch=="x64"', {
          'sources': [
            '<@(unittests_sources_x64)',
          ],
        }],
        ['v8_target_arch=="ppc" or v8_target_arch=="ppc64"', {
          'sources': [
            '<@(unittests_sources_ppc)',
          ],
        }],
        ['v8_target_arch=="s390" or v8_target_arch=="s390x"', {
          'sources': [
            '<@(unittests_sources_s390)',
          ],
        }],
        ['OS=="aix"', {
          'ldflags': [ '-Wl,-bbigtoc' ],
        }],
        ['v8_enable_i18n_support==1', {
          'dependencies': [
            '<(icu_gyp_path):icui18n',
            '<(icu_gyp_path):icuuc',
          ],
        }],
        ['v8_use_snapshot=="true"', {
          'dependencies': ['v8.gyp:v8_initializers'],
        }],
      ],
    },
  ],
}
