// Copyright 2014 MongoDB Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <mongocxx/options/count.hpp>

#include <mongocxx/private/read_preference.hh>

#include <mongocxx/config/private/prelude.hh>

namespace mongocxx {
MONGOCXX_INLINE_NAMESPACE_BEGIN
namespace options {

count& count::collation(bsoncxx::document::view_or_value collation) {
    _collation = std::move(collation);
    return *this;
}

count& count::hint(class hint index_hint) {
    _hint = std::move(index_hint);
    return *this;
}

count& count::limit(std::int64_t limit) {
    _limit = limit;
    return *this;
}

count& count::max_time(std::chrono::milliseconds max_time) {
    _max_time = std::move(max_time);
    return *this;
}

count& count::skip(std::int64_t skip) {
    _skip = skip;
    return *this;
}

count& count::read_preference(class read_preference rp) {
    _read_preference = std::move(rp);
    return *this;
}

const stdx::optional<bsoncxx::document::view_or_value>& count::collation() const {
    return _collation;
}

const stdx::optional<class hint>& count::hint() const {
    return _hint;
}

const stdx::optional<std::int64_t>& count::limit() const {
    return _limit;
}

const stdx::optional<std::chrono::milliseconds>& count::max_time() const {
    return _max_time;
}

const stdx::optional<std::int64_t>& count::skip() const {
    return _skip;
}

const stdx::optional<read_preference>& count::read_preference() const {
    return _read_preference;
}

bool MONGOCXX_CALL operator==(const count& lhs, const count& rhs) {
    if (lhs.hint() && rhs.hint()) {
        if (lhs.hint()->to_value() != rhs.hint()->to_value()) {
            return false;
        }
    } else if (lhs.hint() || rhs.hint()) {
        return false;
    }
    return ((lhs.collation() == rhs.collation()) && (lhs.limit() == rhs.limit()) &&
            (lhs.max_time() == rhs.max_time()) && (lhs.skip() == rhs.skip()) &&
            (lhs.read_preference() == rhs.read_preference()));
}
bool MONGOCXX_CALL operator!=(const count& lhs, const count& rhs) {
    return !(lhs == rhs);
}
}  // namespace options
MONGOCXX_INLINE_NAMESPACE_END
}  // namespace mongocxx
