/*    Copyright 2013 10gen Inc.
 *
 *    This program is free software: you can redistribute it and/or  modify
 *    it under the terms of the GNU Affero General Public License, version 3,
 *    as published by the Free Software Foundation.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    As a special exception, the copyright holders give permission to link the
 *    code of portions of this program with the OpenSSL library under certain
 *    conditions as described in each individual source file and distribute
 *    linked combinations including the program with the OpenSSL library. You
 *    must comply with the GNU Affero General Public License in all respects
 *    for all of the code used other than as permitted herein. If you modify
 *    file(s) with this exception, you may extend this exception to your
 *    version of the file(s), but you are not obligated to do so. If you do not
 *    wish to do so, delete this exception statement from your version. If you
 *    delete this exception statement from all source files in the program,
 *    then also delete it in the license file.
 */

#include "mongo/client/auth_helpers.h"

#include "mongo/db/auth/authorization_manager.h"

namespace mongo {
namespace auth {

const std::string schemaVersionServerParameter = "authSchemaVersion";

Status getRemoteStoredAuthorizationVersion(DBClientBase* conn, int* outVersion) {
    try {
        BSONObj cmdResult;
        conn->runCommand(
            "admin", BSON("getParameter" << 1 << schemaVersionServerParameter << 1), cmdResult);
        if (!cmdResult["ok"].trueValue()) {
            std::string errmsg = cmdResult["errmsg"].str();
            if (errmsg == "no option found to get" ||
                StringData(errmsg).startsWith("no such cmd")) {
                *outVersion = 1;
                return Status::OK();
            }
            int code = cmdResult["code"].numberInt();
            if (code == 0) {
                code = ErrorCodes::UnknownError;
            }
            return Status(ErrorCodes::Error(code), errmsg);
        }
        BSONElement versionElement = cmdResult[schemaVersionServerParameter];
        if (versionElement.eoo())
            return Status(ErrorCodes::UnknownError, "getParameter misbehaved.");
        *outVersion = versionElement.numberInt();
        return Status::OK();
    } catch (const DBException& e) {
        return e.toStatus();
    }
}
}  // namespace auth
}  // namespace mongo
