/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class FileStatus
implements Writable,
Comparable {
    private Path path;
    private long length;
    private boolean isdir;
    private short block_replication;
    private long blocksize;
    private long modification_time;
    private long access_time;
    private FsPermission permission;
    private String owner;
    private String group;

    public FileStatus() {
        this(0L, false, 0, 0L, 0L, 0L, null, null, null, null);
    }

    public FileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, Path path) {
        this(length, isdir, block_replication, blocksize, modification_time, 0L, null, null, null, path);
    }

    public FileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, Path path) {
        this.length = length;
        this.isdir = isdir;
        this.block_replication = (short)block_replication;
        this.blocksize = blocksize;
        this.modification_time = modification_time;
        this.access_time = access_time;
        this.permission = permission == null ? FsPermission.getDefault() : permission;
        this.owner = owner == null ? "" : owner;
        this.group = group == null ? "" : group;
        this.path = path;
    }

    public long getLen() {
        return this.length;
    }

    public boolean isDir() {
        return this.isdir;
    }

    public long getBlockSize() {
        return this.blocksize;
    }

    public short getReplication() {
        return this.block_replication;
    }

    public long getModificationTime() {
        return this.modification_time;
    }

    public long getAccessTime() {
        return this.access_time;
    }

    public FsPermission getPermission() {
        return this.permission;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getGroup() {
        return this.group;
    }

    public Path getPath() {
        return this.path;
    }

    protected void setPermission(FsPermission permission) {
        this.permission = permission == null ? FsPermission.getDefault() : permission;
    }

    protected void setOwner(String owner) {
        this.owner = owner == null ? "" : owner;
    }

    protected void setGroup(String group) {
        this.group = group == null ? "" : group;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        Text.writeString(out, this.getPath().toString());
        out.writeLong(this.length);
        out.writeBoolean(this.isdir);
        out.writeShort(this.block_replication);
        out.writeLong(this.blocksize);
        out.writeLong(this.modification_time);
        out.writeLong(this.access_time);
        this.permission.write(out);
        Text.writeString(out, this.owner);
        Text.writeString(out, this.group);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        String strPath = Text.readString(in);
        this.path = new Path(strPath);
        this.length = in.readLong();
        this.isdir = in.readBoolean();
        this.block_replication = in.readShort();
        this.blocksize = in.readLong();
        this.modification_time = in.readLong();
        this.access_time = in.readLong();
        this.permission.readFields(in);
        this.owner = Text.readString(in);
        this.group = Text.readString(in);
    }

    public int compareTo(Object o) {
        FileStatus other = (FileStatus)o;
        return this.getPath().compareTo(other.getPath());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileStatus)) {
            return false;
        }
        FileStatus other = (FileStatus)o;
        return this.getPath().equals(other.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }
}

