/**
 *    Copyright (C) 2013 MongoDB Inc.
 *
 *    This program is free software: you can redistribute it and/or  modify
 *    it under the terms of the GNU Affero General Public License, version 3,
 *    as published by the Free Software Foundation.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *    As a special exception, the copyright holders give permission to link the
 *    code of portions of this program with the OpenSSL library under certain
 *    conditions as described in each individual source file and distribute
 *    linked combinations including the program with the OpenSSL library. You
 *    must comply with the GNU Affero General Public License in all respects for
 *    all of the code used other than as permitted herein. If you modify file(s)
 *    with this exception, you may extend this exception to your version of the
 *    file(s), but you are not obligated to do so. If you do not wish to do so,
 *    delete this exception statement from your version. If you delete this
 *    exception statement from all source files in the program, then also delete
 *    it in the license file.
 */

#pragma once

#include <vector>

#include "mongo/db/lasterror.h"
#include "mongo/s/write_ops/batched_command_request.h"
#include "mongo/s/write_ops/batched_command_response.h"
#include "mongo/util/net/message.h"

namespace mongo {

    //
    // Utility functions for up-converting incoming write messages into batch write requests.
    // NOTE: These functions throw on invalid message format.
    //

    void msgToBatchRequests( const Message& msg, std::vector<BatchedCommandRequest*>* requests );

    // Batch inserts may get mapped to multiple batch requests, to avoid spilling MaxBSONObjSize
    void msgToBatchInserts( const Message& insertMsg,
                            std::vector<BatchedCommandRequest*>* insertRequests );

    BatchedCommandRequest* msgToBatchUpdate( const Message& updateMsg );

    BatchedCommandRequest* msgToBatchDelete( const Message& deleteMsg );

    /**
     * Utility function for recording completed batch writes into the LastError object.
     * (Interpreting the response requires the request object as well.)
     *
     * Returns true if an error occurred in the batch.
     */
    bool batchErrorToLastError( const BatchedCommandRequest& request,
                                const BatchedCommandResponse& response,
                                LastError* error );

}
