/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web.resources;

import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.web.JsonUtil;
import org.apache.hadoop.hdfs.web.ParamFilter;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.LengthParam;
import org.apache.hadoop.hdfs.web.resources.OffsetParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.UriFsPathParam;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.UserGroupInformation;

@Path(value="")
@ResourceFilters(value={ParamFilter.class})
public class DatanodeWebHdfsMethods {
    public static final Log LOG = LogFactory.getLog(DatanodeWebHdfsMethods.class);
    @Context
    private ServletContext context;

    @PUT
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Response put(final InputStream in, @Context UserGroupInformation ugi, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") PutOpParam op, final @QueryParam(value="permission") @DefaultValue(value="null") PermissionParam permission, final @QueryParam(value="overwrite") @DefaultValue(value="false") OverwriteParam overwrite, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize, final @QueryParam(value="replication") @DefaultValue(value="null") ReplicationParam replication, final @QueryParam(value="blocksize") @DefaultValue(value="null") BlockSizeParam blockSize) throws IOException, URISyntaxException, InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(op + ": " + path + ", ugi=" + ugi + Param.toSortedString(", ", permission, overwrite, bufferSize, replication, blockSize)));
        }
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response run() throws IOException, URISyntaxException {
                String fullpath = path.getAbsolutePath();
                DataNode datanode = (DataNode)DatanodeWebHdfsMethods.this.context.getAttribute("datanode");
                switch ((PutOpParam.Op)op.getValue()) {
                    case CREATE: {
                        Configuration conf = new Configuration(datanode.getConf());
                        DFSClient dfsclient = new DFSClient(conf);
                        int b = bufferSize.getValue(conf);
                        FSDataOutputStream out = new FSDataOutputStream(dfsclient.create(fullpath, permission.getFsPermission(), (Boolean)overwrite.getValue(), (Short)replication.getValue(), blockSize.getValue(conf), null, b), null);
                        try {
                            IOUtils.copyBytes(in, (OutputStream)out, b);
                        }
                        finally {
                            out.close();
                        }
                        String nnAddr = NameNode.getInfoServer(conf);
                        URI uri = new URI("webhdfs://" + nnAddr + fullpath);
                        return Response.created((URI)uri).type("application/json").build();
                    }
                }
                throw new UnsupportedOperationException(op + " is not supported");
            }
        });
    }

    @POST
    @Path(value="{path:.*}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    public Response post(final InputStream in, @Context UserGroupInformation ugi, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") PostOpParam op, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, URISyntaxException, InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(op + ": " + path + ", ugi=" + ugi + Param.toSortedString(", ", bufferSize)));
        }
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Response run() throws IOException {
                String fullpath = path.getAbsolutePath();
                DataNode datanode = (DataNode)DatanodeWebHdfsMethods.this.context.getAttribute("datanode");
                switch ((PostOpParam.Op)op.getValue()) {
                    case APPEND: {
                        Configuration conf = new Configuration(datanode.getConf());
                        DFSClient dfsclient = new DFSClient(conf);
                        int b = bufferSize.getValue(conf);
                        FSDataOutputStream out = dfsclient.append(fullpath, b, null, null);
                        try {
                            IOUtils.copyBytes(in, (OutputStream)out, b);
                        }
                        finally {
                            out.close();
                        }
                        return Response.ok().type("application/json").build();
                    }
                }
                throw new UnsupportedOperationException(op + " is not supported");
            }
        });
    }

    @GET
    @Path(value="{path:.*}")
    @Produces(value={"application/octet-stream", "application/json"})
    public Response get(@Context UserGroupInformation ugi, final @PathParam(value="path") UriFsPathParam path, final @QueryParam(value="op") @DefaultValue(value="null") GetOpParam op, final @QueryParam(value="offset") @DefaultValue(value="0") OffsetParam offset, final @QueryParam(value="length") @DefaultValue(value="null") LengthParam length, final @QueryParam(value="buffersize") @DefaultValue(value="null") BufferSizeParam bufferSize) throws IOException, URISyntaxException, InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(op + ": " + path + ", ugi=" + ugi + Param.toSortedString(", ", offset, length, bufferSize)));
        }
        return ugi.doAs(new PrivilegedExceptionAction<Response>(){

            @Override
            public Response run() throws IOException {
                String fullpath = path.getAbsolutePath();
                DataNode datanode = (DataNode)DatanodeWebHdfsMethods.this.context.getAttribute("datanode");
                Configuration conf = new Configuration(datanode.getConf());
                InetSocketAddress nnRpcAddr = NameNode.getAddress(conf);
                DFSClient dfsclient = new DFSClient(nnRpcAddr, conf);
                switch ((GetOpParam.Op)op.getValue()) {
                    case OPEN: {
                        final int b = bufferSize.getValue(conf);
                        final DFSClient.DFSDataInputStream in = new DFSClient.DFSDataInputStream(dfsclient.open(fullpath, b, true, null));
                        in.seek((Long)offset.getValue());
                        StreamingOutput streaming = new StreamingOutput(){

                            public void write(OutputStream out) throws IOException {
                                Long n = (Long)length.getValue();
                                if (n == null) {
                                    IOUtils.copyBytes((InputStream)in, out, b);
                                } else {
                                    IOUtils.copyBytes(in, out, n, b, false);
                                }
                            }
                        };
                        return Response.ok((Object)streaming).type("application/octet-stream").build();
                    }
                    case GETFILECHECKSUM: {
                        MD5MD5CRC32FileChecksum checksum = dfsclient.getFileChecksum(fullpath);
                        String js = JsonUtil.toJsonString(checksum);
                        return Response.ok((Object)js).type("application/json").build();
                    }
                }
                throw new UnsupportedOperationException(op + " is not supported");
            }
        });
    }
}

