## MongoDB Java Driver ##
 * release notes: https://github.com/mongodb/mongo-java-driver/releases
 * driver home: http://github.com/mongodb/mongo-java-driver
 * mongodb home: http://www.mongodb.org/
 * javadoc: http://api.mongodb.org/java/
 * releases: http://central.maven.org/maven2/org/mongodb/mongo-java-driver/
 * snapshots: https://oss.sonatype.org/content/repositories/snapshots/org/mongodb/mongo-java-driver/

Support / Feedback
==================

For issues with, questions about, or feedback for the MongoDB Java driver, please look into
our [support channels](http://www.mongodb.org/about/support). Please
do not email any of the Java driver developers directly with issues or
questions - you're more likely to get an answer on the [mongodb-user]
(http://groups.google.com/group/mongodb-user) list on Google Groups.

At a minimum, please include in your description the exact version of the driver that you are using.  If you are having 
connectivity issues, it's often also useful to paste in the line of code where you construct the MongoClient instance,
along with the values of all parameters that you pass to the constructor. You should also check your application logs for
any connectivity-related exceptions and post those as well.

Bugs / Feature Requests
=======================

Think you’ve found a bug? Want to see a new feature in the Java driver? Please open a
case in our issue management tool, JIRA:

- [Create an account and login](https://jira.mongodb.org).
- Navigate to [the JAVA project](https://jira.mongodb.org/browse/JAVA).
- Click **Create Issue** - Please provide as much information as possible about the issue type and how to reproduce it.

Bug reports in JIRA for the driver and the Core Server (i.e. SERVER) project are **public**.

Security Vulnerabilities
------------------------

If you’ve identified a security vulnerability in a driver or any other
MongoDB project, please report it according to the [instructions here]
(http://docs.mongodb.org/manual/tutorial/create-a-vulnerability-report).

### Build status:
[![Build Status](https://jenkins.10gen.com/job/mongo-java-driver/badge/icon)](https://jenkins.10gen.com/job/mongo-java-driver/)

### Maintainers
* Jeff Yemin           jeff.yemin@mongodb.com
* Ross Lawley          ross@mongodb.com

### Contributors:
* Trisha Gee           trisha.gee@gmail.com
* Scott Hernandez      scott@mongodb.com
* Ryan Nitz            ryan@mongodb.com
* Antoine Girbal       antoine@mongodb.com
* Eliot Horowitz       eliot@mongodb.com
* Geir Magnusson       geir@pobox.com
* Keith Branton        mongoDBjira@branton.co.uk
* Dave Brosius         dbrosius@mebigfatguy.com
* Hans Meiser          hmeiser@example.com
* Benedikt Waldvogel   mail@bwaldvogel.de
* William Shulman      william.shulman@gmail.com
* Daniel Spilker       mail@daniel-spilker.com
* Kyle Banker          kylebanker@gmail.com
* Ville Lautanala      ville.lautanala@nodeta.fi
* Dan Simpson          dan.simpson@gmail.com
* Tim Nelson           tnelly27@gmail.com
* Jon Hoffman          jonhoffman@gmail.com
* Daniel Kunnath       dan@gameattain.com
* Harry Heymann        harryh@gmail.com
* Zsombor Gegesy       gzsombor@gmail.com
* Richard Kreuter      richard@mongodb.com
* Matthew Foemmel      git@foemmel.com
* Jim Dickinson        jdickinson@shopwiki.com
* Jorge Ortiz          jorge.ortiz@gmail.com
* Brendan McAdams
* Kristina Chodorow
* Mike Dirolf

We proudly develop this project with [![Intellij IDEA](http://www.jetbrains.com/img/logos/logo_intellij_idea.png)](http://www.jetbrains.com/idea/).

YourKit is kindly supporting this open source project with its [YourKit Java Profiler](http://www.yourkit.com/java/profiler/index.jsp).
