/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.checks;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import net.sf.clirr.core.Message;
import net.sf.clirr.core.Severity;
import net.sf.clirr.core.internal.AbstractDiffReporter;
import net.sf.clirr.core.internal.ApiDiffDispatcher;
import net.sf.clirr.core.internal.ClassChangeCheck;
import net.sf.clirr.core.internal.CoIterator;
import net.sf.clirr.core.internal.NameComparator;
import net.sf.clirr.core.spi.JavaType;

public final class InterfaceSetCheck
extends AbstractDiffReporter
implements ClassChangeCheck {
    private static final Message MSG_IFACE_ADDED = new Message(4000);
    private static final Message MSG_IFACE_REMOVED = new Message(4001);

    public InterfaceSetCheck(ApiDiffDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean check(JavaType compatBaseline, JavaType currentVersion) {
        JavaType[] compatInterfaces = compatBaseline.getAllInterfaces();
        JavaType[] currentInterfaces = currentVersion.getAllInterfaces();
        Set compat = this.createClassSet(compatInterfaces);
        Set current = this.createClassSet(currentInterfaces);
        String className = compatBaseline.getName();
        CoIterator iter = new CoIterator((Comparator)new NameComparator(), compat, current);
        while (iter.hasNext()) {
            iter.next();
            JavaType compatInterface = (JavaType)iter.getLeft();
            JavaType currentInterface = (JavaType)iter.getRight();
            if (compatInterface != null && className.equals(compatInterface.getName()) || currentInterface != null && className.equals(currentInterface.getName())) continue;
            if (compatInterface == null) {
                this.log(MSG_IFACE_ADDED, Severity.INFO, className, null, null, new String[]{currentInterface.getName()});
                continue;
            }
            if (currentInterface != null) continue;
            this.log(MSG_IFACE_REMOVED, this.getSeverity(compatBaseline, Severity.ERROR), className, null, null, new String[]{compatInterface.getName()});
        }
        return true;
    }

    private Set createClassSet(JavaType[] classes) {
        TreeSet<JavaType> current = new TreeSet<JavaType>(new NameComparator());
        for (int i = 0; i < classes.length; ++i) {
            current.add(classes[i]);
        }
        return current;
    }
}

