/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.instrument.JumpHolder;
import net.sourceforge.cobertura.instrument.SecondPassMethodInstrumenter;
import net.sourceforge.cobertura.instrument.SwitchHolder;
import net.sourceforge.cobertura.util.RegexUtil;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.MethodNode;

public class FirstPassMethodInstrumenter
extends MethodAdapter
implements Opcodes {
    private final String ownerClass;
    private String myName;
    private String myDescriptor;
    private int myAccess;
    private Collection ignoreRegexs;
    private Collection ignoreBranchesRegexs;
    private ClassData classData;
    private int currentLine;
    private int currentJump;
    private int currentSwitch;
    private Map jumpTargetLabels;
    private Map switchTargetLabels;
    private Map lineLabels;
    private MethodVisitor writerMethodVisitor;
    private MethodNode methodNode;

    public FirstPassMethodInstrumenter(ClassData classData, MethodVisitor mv, String owner, int access, String name, String desc, String signature, String[] exceptions, Collection ignoreRegexs, Collection ignoreBranchesRegexs) {
        super((MethodVisitor)new MethodNode(access, name, desc, signature, exceptions));
        this.writerMethodVisitor = mv;
        this.ownerClass = owner;
        this.methodNode = (MethodNode)this.mv;
        this.classData = classData;
        this.myAccess = access;
        this.myName = name;
        this.myDescriptor = desc;
        this.ignoreRegexs = ignoreRegexs;
        this.ignoreBranchesRegexs = ignoreBranchesRegexs;
        this.jumpTargetLabels = new HashMap();
        this.switchTargetLabels = new HashMap();
        this.lineLabels = new HashMap();
        this.currentLine = 0;
    }

    public void visitEnd() {
        super.visitEnd();
        this.methodNode.accept((MethodVisitor)(this.lineLabels.isEmpty() ? this.writerMethodVisitor : new SecondPassMethodInstrumenter(this)));
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (opcode != 167 && opcode != 168 && this.currentLine != 0 && !this.myName.equals("<clinit>")) {
            this.classData.addLineJump(this.currentLine, this.currentJump);
            this.jumpTargetLabels.put(label, new JumpHolder(this.currentLine, this.currentJump++));
        }
        super.visitJumpInsn(opcode, label);
    }

    public void visitLineNumber(int line, Label start) {
        this.currentLine = line;
        this.classData.addLine(this.currentLine, this.myName, this.myDescriptor);
        this.currentJump = 0;
        this.currentSwitch = 0;
        this.lineLabels.put(start, new Integer(line));
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        super.visitMethodInsn(opcode, owner, name, desc);
        if (RegexUtil.matches(this.ignoreRegexs, owner)) {
            this.classData.removeLine(this.currentLine);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        if (this.currentLine != 0) {
            this.switchTargetLabels.put(dflt, new SwitchHolder(this.currentLine, this.currentSwitch, -1));
            for (int i = labels.length - 1; i >= 0; --i) {
                this.switchTargetLabels.put(labels[i], new SwitchHolder(this.currentLine, this.currentSwitch, i));
            }
            this.classData.addLineSwitch(this.currentLine, this.currentSwitch++, keys);
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        if (this.currentLine != 0) {
            this.switchTargetLabels.put(dflt, new SwitchHolder(this.currentLine, this.currentSwitch, -1));
            for (int i = labels.length - 1; i >= 0; --i) {
                this.switchTargetLabels.put(labels[i], new SwitchHolder(this.currentLine, this.currentSwitch, i));
            }
            this.classData.addLineSwitch(this.currentLine, this.currentSwitch++, min, max);
        }
    }

    protected void removeLine(int lineNumber) {
        this.classData.removeLine(lineNumber);
    }

    protected MethodVisitor getWriterMethodVisitor() {
        return this.writerMethodVisitor;
    }

    protected Collection getIgnoreRegexs() {
        return this.ignoreRegexs;
    }

    protected Map getJumpTargetLabels() {
        return this.jumpTargetLabels;
    }

    protected Map getSwitchTargetLabels() {
        return this.switchTargetLabels;
    }

    protected int getMyAccess() {
        return this.myAccess;
    }

    protected String getMyDescriptor() {
        return this.myDescriptor;
    }

    protected String getMyName() {
        return this.myName;
    }

    protected String getOwnerClass() {
        return this.ownerClass;
    }

    protected Map getLineLabels() {
        return this.lineLabels;
    }
}

