/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core;

import java.io.IOException;
import java.io.PrintStream;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.FileDiffListener;
import net.sf.clirr.core.MessageTranslator;

public final class XmlDiffListener
extends FileDiffListener {
    private static final String DIFFREPORT = "diffreport";
    private static final String DIFFERENCE = "difference";
    private MessageTranslator translator = new MessageTranslator();

    public XmlDiffListener(String outFile) throws IOException {
        super(outFile);
    }

    public void reportDiff(ApiDifference difference) {
        PrintStream out = this.getOutputStream();
        out.print("  <difference");
        out.print(" binseverity=\"" + difference.getBinaryCompatibilitySeverity() + "\"");
        out.print(" srcseverity=\"" + difference.getSourceCompatibilitySeverity() + "\"");
        out.print(" class=\"" + difference.getAffectedClass() + "\"");
        if (difference.getAffectedMethod() != null) {
            out.print(" method=\"" + difference.getAffectedMethod() + "\"");
        }
        if (difference.getAffectedField() != null) {
            out.print(" field=\"" + difference.getAffectedField() + "\"");
        }
        out.print(">");
        out.print(difference.getReport(this.translator));
        out.println("</difference>");
    }

    public void start() {
        PrintStream out = this.getOutputStream();
        out.println("<?xml version=\"1.0\"?>");
        out.println("<diffreport>");
    }

    protected void writeFooter() {
        PrintStream out = this.getOutputStream();
        out.println("</diffreport>");
    }
}

