/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.checks;

import java.util.Comparator;
import net.sf.clirr.core.Message;
import net.sf.clirr.core.Severity;
import net.sf.clirr.core.internal.AbstractDiffReporter;
import net.sf.clirr.core.internal.ApiDiffDispatcher;
import net.sf.clirr.core.internal.ClassChangeCheck;
import net.sf.clirr.core.internal.CoIterator;
import net.sf.clirr.core.internal.NameComparator;
import net.sf.clirr.core.spi.JavaType;

public final class ClassHierarchyCheck
extends AbstractDiffReporter
implements ClassChangeCheck {
    private static final Message MSG_ADDED_CLASS_TO_SUPERCLASSES = new Message(5000);
    private static final Message MSG_REMOVED_CLASS_FROM_SUPERCLASSES = new Message(5001);

    public ClassHierarchyCheck(ApiDiffDispatcher dispatcher) {
        super(dispatcher);
    }

    public boolean check(JavaType compatBaseline, JavaType currentVersion) {
        Object[] compatSupers = compatBaseline.getSuperClasses();
        Object[] currentSupers = currentVersion.getSuperClasses();
        boolean isThrowable = false;
        for (int i = 0; i < compatSupers.length; ++i) {
            JavaType javaClass = compatSupers[i];
            if (!"java.lang.Throwable".equals(javaClass.getName())) continue;
            isThrowable = true;
        }
        String className = compatBaseline.getName();
        CoIterator iter = new CoIterator((Comparator)new NameComparator(), compatSupers, currentSupers);
        while (iter.hasNext()) {
            iter.next();
            JavaType baselineSuper = (JavaType)iter.getLeft();
            JavaType currentSuper = (JavaType)iter.getRight();
            if (baselineSuper == null) {
                Severity severity = isThrowable ? Severity.WARNING : Severity.INFO;
                this.log(MSG_ADDED_CLASS_TO_SUPERCLASSES, this.getSeverity(compatBaseline, severity), className, null, null, new String[]{currentSuper.getName()});
                continue;
            }
            if (currentSuper != null) continue;
            this.log(MSG_REMOVED_CLASS_FROM_SUPERCLASSES, this.getSeverity(compatBaseline, Severity.ERROR), className, null, null, new String[]{baselineSuper.getName()});
        }
        return true;
    }
}

