/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal;

import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.Message;
import net.sf.clirr.core.Severity;
import net.sf.clirr.core.internal.ApiDiffDispatcher;
import net.sf.clirr.core.spi.Field;
import net.sf.clirr.core.spi.JavaType;
import net.sf.clirr.core.spi.Method;
import net.sf.clirr.core.spi.Scope;

public abstract class AbstractDiffReporter {
    private static final Message MSG_UNABLE_TO_DETERMINE_CLASS_SCOPE = new Message(9000);
    private ApiDiffDispatcher dispatcher;

    public AbstractDiffReporter(ApiDiffDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    protected final ApiDiffDispatcher getApiDiffDispatcher() {
        return this.dispatcher;
    }

    protected final void log(Message msg, Severity severity, String clazz, Method method, Field field, String[] args) {
        ApiDifference diff = new ApiDifference(msg, severity, clazz, null, null, args);
        this.getApiDiffDispatcher().fireDiff(diff);
    }

    protected final Severity getSeverity(JavaType clazz, Severity sev) {
        Scope scope = clazz.getEffectiveScope();
        if (scope.isLessVisibleThan(Scope.PROTECTED)) {
            return Severity.INFO;
        }
        return sev;
    }

    protected final Severity getSeverity(JavaType clazz, Method method, Severity sev) {
        if (!method.getDeclaredScope().isLessVisibleThan(Scope.PROTECTED)) {
            return this.getSeverity(clazz, sev);
        }
        return Severity.INFO;
    }

    protected final Severity getSeverity(JavaType clazz, Field field, Severity sev) {
        if (!field.getDeclaredScope().isLessVisibleThan(Scope.PROTECTED)) {
            return this.getSeverity(clazz, sev);
        }
        return Severity.INFO;
    }
}

