/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.bcel;

import net.sf.clirr.core.internal.bcel.BcelField;
import net.sf.clirr.core.internal.bcel.BcelMethod;
import net.sf.clirr.core.internal.bcel.BcelScopeHelper;
import net.sf.clirr.core.spi.Field;
import net.sf.clirr.core.spi.JavaType;
import net.sf.clirr.core.spi.Scope;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.Repository;

public final class BcelJavaType
implements JavaType {
    private Type type;
    private JavaClass clazz;
    private Repository repository;

    public BcelJavaType(Type bcelType, Repository repository) {
        this.type = bcelType;
        this.repository = repository;
        this.clazz = this.findJavaClass(this.type);
    }

    public BcelJavaType(JavaClass clazz) {
        this.type = null;
        this.repository = clazz.getRepository();
        this.clazz = clazz;
    }

    public String getName() {
        if (this.clazz != null) {
            return this.clazz.getClassName();
        }
        return this.type.toString();
    }

    public JavaType getContainingClass() {
        return null;
    }

    private JavaClass findJavaClass(Type type) {
        if (!(type instanceof ObjectType)) {
            return null;
        }
        ObjectType ot = (ObjectType)type;
        return this.repository.findClass(ot.getClassName());
    }

    public JavaType[] getSuperClasses() {
        if (this.clazz == null) {
            return new JavaType[0];
        }
        JavaClass[] superClasses = this.clazz.getSuperClasses();
        return this.convertToJavaTypeArray(superClasses);
    }

    public JavaType[] getAllInterfaces() {
        if (this.clazz == null) {
            return new JavaType[0];
        }
        JavaClass[] interfaces = this.clazz.getAllInterfaces();
        return this.convertToJavaTypeArray(interfaces);
    }

    public JavaType[] getInnerClasses() {
        return new JavaType[0];
    }

    public net.sf.clirr.core.spi.Method[] getMethods() {
        if (this.clazz == null) {
            return new net.sf.clirr.core.spi.Method[0];
        }
        Method[] methods = this.clazz.getMethods();
        net.sf.clirr.core.spi.Method[] ret = new net.sf.clirr.core.spi.Method[methods.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new BcelMethod(this.clazz, methods[i]);
        }
        return ret;
    }

    public Field[] getFields() {
        if (this.clazz == null) {
            return new Field[0];
        }
        org.apache.bcel.classfile.Field[] fields = this.clazz.getFields();
        Field[] ret = new Field[fields.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new BcelField(this.clazz, fields[i]);
        }
        return ret;
    }

    public boolean isPrimitive() {
        return this.clazz == null;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isFinal() {
        if (this.clazz == null) {
            return false;
        }
        return this.clazz.isFinal();
    }

    public boolean isAbstract() {
        if (this.clazz == null) {
            return false;
        }
        return this.clazz.isAbstract();
    }

    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    public Scope getDeclaredScope() {
        return BcelScopeHelper.getClassScope(this.clazz);
    }

    public Scope getEffectiveScope() {
        return this.getDeclaredScope();
    }

    public String toString() {
        return this.getName();
    }

    private JavaType[] convertToJavaTypeArray(JavaClass[] bcelClasses) {
        JavaType[] ret = new JavaType[bcelClasses.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new BcelJavaType(bcelClasses[i]);
        }
        return ret;
    }
}

