/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.sf.clirr.core.Message;

public final class MessageManager {
    private static MessageManager instance;
    private ArrayList messages = new ArrayList();

    private MessageManager() {
    }

    public static MessageManager getInstance() {
        if (instance == null) {
            instance = new MessageManager();
        }
        return instance;
    }

    public void addMessage(Message msg) {
        this.messages.add(msg);
    }

    public void checkUnique() {
        Collections.sort(this.messages, new MessageComparator());
        int lastId = -1;
        Iterator i = this.messages.iterator();
        while (i.hasNext()) {
            Message m = (Message)i.next();
            int currId = m.getId();
            if (currId > lastId) continue;
            throw new IllegalArgumentException("Message id [" + currId + "] is not unique.");
        }
    }

    public Collection getMessages() {
        return this.messages;
    }

    private static class MessageComparator
    implements Comparator {
        private MessageComparator() {
        }

        public int compare(Object o1, Object o2) {
            Message m1 = (Message)o1;
            Message m2 = (Message)o2;
            return m1.getId() - m2.getId();
        }
    }
}

