/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.CheckerException;
import net.sf.clirr.core.DiffListener;
import net.sf.clirr.core.Message;
import net.sf.clirr.core.ScopeSelector;
import net.sf.clirr.core.Severity;
import net.sf.clirr.core.internal.ApiDiffDispatcher;
import net.sf.clirr.core.internal.ClassChangeCheck;
import net.sf.clirr.core.internal.CoIterator;
import net.sf.clirr.core.internal.NameComparator;
import net.sf.clirr.core.internal.checks.ClassHierarchyCheck;
import net.sf.clirr.core.internal.checks.ClassModifierCheck;
import net.sf.clirr.core.internal.checks.ClassScopeCheck;
import net.sf.clirr.core.internal.checks.FieldSetCheck;
import net.sf.clirr.core.internal.checks.GenderChangeCheck;
import net.sf.clirr.core.internal.checks.InterfaceSetCheck;
import net.sf.clirr.core.internal.checks.MethodSetCheck;
import net.sf.clirr.core.spi.JavaType;
import net.sf.clirr.core.spi.Scope;

public final class Checker
implements ApiDiffDispatcher {
    private static final Message MSG_CLASS_ADDED = new Message(8000);
    private static final Message MSG_CLASS_REMOVED = new Message(8001);
    private List listeners = new ArrayList();
    private List classChecks = new ArrayList();
    private ScopeSelector scopeSelector = new ScopeSelector();

    Checker(ClassChangeCheck ccc) {
        if (ccc != null) {
            this.classChecks.add(ccc);
        }
    }

    public Checker() {
        this.classChecks.add(new ClassScopeCheck(this, this.scopeSelector));
        this.classChecks.add(new GenderChangeCheck(this));
        this.classChecks.add(new ClassModifierCheck(this));
        this.classChecks.add(new InterfaceSetCheck(this));
        this.classChecks.add(new ClassHierarchyCheck(this));
        this.classChecks.add(new FieldSetCheck(this, this.scopeSelector));
        this.classChecks.add(new MethodSetCheck(this, this.scopeSelector));
    }

    public ScopeSelector getScopeSelector() {
        return this.scopeSelector;
    }

    public void addDiffListener(DiffListener listener) {
        this.listeners.add(listener);
    }

    private void fireStart() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            DiffListener diffListener = (DiffListener)it.next();
            diffListener.start();
        }
    }

    private void fireStop() {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            DiffListener diffListener = (DiffListener)it.next();
            diffListener.stop();
        }
    }

    public void fireDiff(ApiDifference diff) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            DiffListener diffListener = (DiffListener)it.next();
            diffListener.reportDiff(diff);
        }
    }

    public void reportDiffs(JavaType[] compatibilityBaseline, JavaType[] currentVersion) throws CheckerException {
        this.fireStart();
        this.runClassChecks(compatibilityBaseline, currentVersion);
        this.fireStop();
    }

    private void runClassChecks(JavaType[] compat, JavaType[] current) throws CheckerException {
        CoIterator iter = new CoIterator((Comparator)new NameComparator(), compat, current);
        while (iter.hasNext()) {
            iter.next();
            JavaType compatBaselineClass = (JavaType)iter.getLeft();
            JavaType currentClass = (JavaType)iter.getRight();
            if (compatBaselineClass == null) {
                if (!this.scopeSelector.isSelected(currentClass.getEffectiveScope())) continue;
                String className = currentClass.getName();
                ApiDifference diff = new ApiDifference(MSG_CLASS_ADDED, Severity.INFO, className, null, null, null);
                this.fireDiff(diff);
                continue;
            }
            if (currentClass == null) {
                Scope classScope = compatBaselineClass.getEffectiveScope();
                if (!this.scopeSelector.isSelected(classScope)) continue;
                String className = compatBaselineClass.getName();
                Severity severity = classScope.isLessVisibleThan(Scope.PROTECTED) ? Severity.INFO : Severity.ERROR;
                ApiDifference diff = new ApiDifference(MSG_CLASS_REMOVED, severity, className, null, null, null);
                this.fireDiff(diff);
                continue;
            }
            boolean continueTesting = true;
            Iterator it = this.classChecks.iterator();
            while (it.hasNext() && continueTesting) {
                ClassChangeCheck classChangeCheck = (ClassChangeCheck)it.next();
                continueTesting = classChangeCheck.check(compatBaselineClass, currentClass);
            }
        }
    }
}

