/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.checks;

import java.util.Comparator;
import net.sf.clirr.core.ApiDifference;
import net.sf.clirr.core.Message;
import net.sf.clirr.core.ScopeSelector;
import net.sf.clirr.core.Severity;
import net.sf.clirr.core.internal.AbstractDiffReporter;
import net.sf.clirr.core.internal.ApiDiffDispatcher;
import net.sf.clirr.core.internal.ClassChangeCheck;
import net.sf.clirr.core.internal.CoIterator;
import net.sf.clirr.core.internal.NameComparator;
import net.sf.clirr.core.spi.Field;
import net.sf.clirr.core.spi.JavaType;
import net.sf.clirr.core.spi.Scope;

public class FieldSetCheck
extends AbstractDiffReporter
implements ClassChangeCheck {
    private static final Message MSG_FIELD_ADDED = new Message(6000);
    private static final Message MSG_FIELD_REMOVED = new Message(6001);
    private static final Message MSG_FIELD_NOT_CONSTANT = new Message(6002);
    private static final Message MSG_FIELD_CONSTANT_CHANGED = new Message(6003);
    private static final Message MSG_FIELD_TYPE_CHANGED = new Message(6004);
    private static final Message MSG_FIELD_NOW_NON_FINAL = new Message(6005);
    private static final Message MSG_FIELD_NOW_FINAL = new Message(6006);
    private static final Message MSG_FIELD_NOW_NON_STATIC = new Message(6007);
    private static final Message MSG_FIELD_NOW_STATIC = new Message(6008);
    private static final Message MSG_FIELD_MORE_ACCESSIBLE = new Message(6009);
    private static final Message MSG_FIELD_LESS_ACCESSIBLE = new Message(6010);
    private static final Message MSG_CONSTANT_FIELD_REMOVED = new Message(6011);
    private static final Comparator COMPARATOR = new NameComparator();
    private ScopeSelector scopeSelector;

    public FieldSetCheck(ApiDiffDispatcher dispatcher, ScopeSelector scopeSelector) {
        super(dispatcher);
        this.scopeSelector = scopeSelector;
    }

    public final boolean check(JavaType baselineClass, JavaType currentClass) {
        Object[] baselineFields = baselineClass.getFields();
        Object[] currentFields = currentClass.getFields();
        CoIterator iter = new CoIterator(COMPARATOR, baselineFields, currentFields);
        while (iter.hasNext()) {
            iter.next();
            Field bField = (Field)iter.getLeft();
            Field cField = (Field)iter.getRight();
            if (bField == null) {
                if (!this.scopeSelector.isSelected(cField)) continue;
                String scope = cField.getDeclaredScope().getDesc();
                this.fireDiff(MSG_FIELD_ADDED, Severity.INFO, currentClass, cField, new String[]{scope});
                continue;
            }
            if (cField == null) {
                if (!this.scopeSelector.isSelected(bField)) continue;
                if (bField.getConstantValue() != null && bField.isFinal()) {
                    this.fireDiff(MSG_CONSTANT_FIELD_REMOVED, this.getSeverity(baselineClass, bField, Severity.WARNING), this.getSeverity(baselineClass, bField, Severity.ERROR), baselineClass, bField, null);
                    continue;
                }
                this.fireDiff(MSG_FIELD_REMOVED, this.getSeverity(baselineClass, bField, Severity.ERROR), baselineClass, bField, null);
                continue;
            }
            if (!this.scopeSelector.isSelected(bField) && !this.scopeSelector.isSelected(cField)) continue;
            this.checkForModifierChange(bField, cField, currentClass);
            this.checkForVisibilityChange(bField, cField, currentClass);
            this.checkForTypeChange(bField, cField, currentClass);
            this.checkForConstantValueChange(bField, cField, currentClass);
        }
        return true;
    }

    private void checkForConstantValueChange(Field bField, Field cField, JavaType currentClass) {
        if (!(bField.isStatic() && bField.isFinal() && cField.isStatic() && cField.isFinal())) {
            return;
        }
        Object bVal = bField.getConstantValue();
        if (bVal != null) {
            String bValRep = bVal.toString();
            Object cVal = cField.getConstantValue();
            if (cVal == null) {
                this.fireDiff(MSG_FIELD_NOT_CONSTANT, this.getSeverity(currentClass, bField, Severity.WARNING), currentClass, cField, null);
                return;
            }
            String cValRep = String.valueOf(cVal);
            if (!bValRep.equals(cValRep)) {
                this.fireDiff(MSG_FIELD_CONSTANT_CHANGED, this.getSeverity(currentClass, bField, Severity.WARNING), currentClass, cField, null);
            }
        }
    }

    private void checkForTypeChange(Field bField, Field cField, JavaType currentClass) {
        String cSig;
        String bSig = bField.getType().toString();
        if (!bSig.equals(cSig = cField.getType().toString())) {
            this.fireDiff(MSG_FIELD_TYPE_CHANGED, this.getSeverity(currentClass, bField, Severity.ERROR), currentClass, bField, new String[]{bSig, cSig});
        }
    }

    private void checkForModifierChange(Field bField, Field cField, JavaType clazz) {
        if (bField.isFinal() && !cField.isFinal()) {
            this.fireDiff(MSG_FIELD_NOW_NON_FINAL, Severity.INFO, clazz, cField, null);
        }
        if (!bField.isFinal() && cField.isFinal()) {
            this.fireDiff(MSG_FIELD_NOW_FINAL, Severity.ERROR, clazz, cField, null);
        }
        if (bField.isStatic() && !cField.isStatic()) {
            this.fireDiff(MSG_FIELD_NOW_NON_STATIC, this.getSeverity(clazz, bField, Severity.ERROR), clazz, cField, null);
        }
        if (!bField.isStatic() && cField.isStatic()) {
            this.fireDiff(MSG_FIELD_NOW_STATIC, this.getSeverity(clazz, bField, Severity.ERROR), clazz, cField, null);
        }
    }

    private void checkForVisibilityChange(Field bField, Field cField, JavaType clazz) {
        Scope bScope = bField.getEffectiveScope();
        Scope cScope = cField.getEffectiveScope();
        if (cScope.isMoreVisibleThan(bScope)) {
            this.fireDiff(MSG_FIELD_MORE_ACCESSIBLE, Severity.INFO, clazz, cField, new String[]{bScope.getDesc(), cScope.getDesc()});
        } else if (cScope.isLessVisibleThan(bScope)) {
            this.fireDiff(MSG_FIELD_LESS_ACCESSIBLE, this.getSeverity(clazz, bField, Severity.ERROR), clazz, cField, new String[]{bScope.getDesc(), cScope.getDesc()});
        }
    }

    private void fireDiff(Message msg, Severity severity, JavaType clazz, Field field, String[] args) {
        this.fireDiff(msg, severity, severity, clazz, field, args);
    }

    private void fireDiff(Message msg, Severity binarySeverity, Severity sourceSeverity, JavaType clazz, Field field, String[] args) {
        String className = clazz.getName();
        ApiDifference diff = new ApiDifference(msg, binarySeverity, sourceSeverity, className, null, field.getName(), args);
        this.getApiDiffDispatcher().fireDiff(diff);
    }
}

