/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.introspection;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.introspection.ClassMap;

public class ReflectionValueExtractor {
    private static Class[] args = new Class[0];
    private static Object[] params = new Object[0];
    private static ClassMap classMap;
    private static Map classMaps;

    private ReflectionValueExtractor() {
    }

    public static Object evaluate(String expression, Object root) throws Exception {
        return ReflectionValueExtractor.evaluate(expression, root, true);
    }

    public static Object evaluate(String expression, Object root, boolean trimRootToken) throws Exception {
        if (trimRootToken) {
            expression = expression.substring(expression.indexOf(46) + 1);
        }
        Object value = root;
        StringTokenizer parser = new StringTokenizer(expression, ".");
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            if (value == null) {
                return null;
            }
            classMap = ReflectionValueExtractor.getClassMap(value.getClass());
            String methodBase = StringUtils.capitalizeFirstLetter(token);
            String methodName = "get" + methodBase;
            Method method = classMap.findMethod(methodName, args);
            if (method == null) {
                methodName = "is" + methodBase;
                method = classMap.findMethod(methodName, args);
            }
            if (method == null) {
                return null;
            }
            value = method.invoke(value, params);
        }
        return value;
    }

    private static ClassMap getClassMap(Class clazz) {
        classMap = (ClassMap)classMaps.get(clazz);
        if (classMap == null) {
            classMap = new ClassMap(clazz);
            classMaps.put(clazz, classMap);
        }
        return classMap;
    }

    static {
        classMaps = new HashMap();
    }
}

