/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import java.io.File;
import java.io.IOException;
import net.sf.antcontrib.cpptasks.CUtil;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;

public final class DistributerMap
extends DataType {
    private String ifCond;
    private String unlessCond;
    private File localName;
    private String canonicalPath;
    private String remoteName;
    private char remoteSeparator = File.separatorChar;
    private String hosts;

    public void execute() {
        throw new BuildException("Not an actual task, but looks like one for documentation purposes");
    }

    public boolean isActive() {
        return CUtil.isActive(this.getProject(), this.ifCond, this.unlessCond);
    }

    public void setIf(String propName) {
        this.ifCond = propName;
    }

    public void setUnless(String propName) {
        this.unlessCond = propName;
    }

    public File getLocal() {
        return this.localName;
    }

    public String getRemote() {
        return this.remoteName;
    }

    public String toRemote(String host, File localFile) {
        if (this.remoteName != null && (this.hosts == null || this.hosts.indexOf(host) >= 0)) {
            try {
                String canonical = localFile.getCanonicalPath();
                if (canonical.startsWith(this.canonicalPath) && this.isActive()) {
                    return String.valueOf(this.remoteName) + canonical.substring(this.canonicalPath.length()).replace(File.separatorChar, this.remoteSeparator);
                }
            }
            catch (IOException ex) {
                return null;
            }
        }
        return null;
    }

    public void setLocal(File value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value.exists() && !value.isDirectory()) {
            throw new BuildException("local should be a directory");
        }
        this.localName = value;
        try {
            this.canonicalPath = this.localName.getCanonicalPath();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    public void setRemote(String value) {
        this.remoteName = value;
    }

    public void setRemoteSeparator(String value) {
        if (value != null && value.length() != 1) {
            throw new BuildException("remote separator must be a single character");
        }
        this.remoteSeparator = value.charAt(0);
    }

    public void setHosts(String value) {
        this.hosts = value;
    }
}

