/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xslt;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TooManyListenersException;
import java.util.Vector;
import org.apache.xalan.xpath.ExtensionFunctionHandler;
import org.apache.xalan.xpath.dtm.DTMLiaison;
import org.apache.xalan.xpath.xml.FormatterToDOM;
import org.apache.xalan.xpath.xml.FormatterToHTML;
import org.apache.xalan.xpath.xml.FormatterToText;
import org.apache.xalan.xpath.xml.FormatterToXML;
import org.apache.xalan.xpath.xml.MutableAttrListImpl;
import org.apache.xalan.xpath.xml.QName;
import org.apache.xalan.xpath.xml.XSLMessages;
import org.apache.xalan.xslt.ElemApplyTemplates;
import org.apache.xalan.xslt.ElemTemplate;
import org.apache.xalan.xslt.ElemValueOf;
import org.apache.xalan.xslt.Stylesheet;
import org.apache.xalan.xslt.XSLProcessorException;
import org.apache.xalan.xslt.XSLTEngineImpl;
import org.apache.xalan.xslt.XSLTInputSource;
import org.apache.xalan.xslt.XSLTProcessor;
import org.apache.xalan.xslt.XSLTProcessorFactory;
import org.apache.xalan.xslt.XSLTResultTarget;
import org.apache.xalan.xslt.trace.SelectionEvent;
import org.apache.xalan.xslt.trace.TraceListener;
import org.apache.xalan.xslt.trace.TracerEvent;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;

public class StylesheetRoot
extends Stylesheet
implements Serializable {
    String m_resultNameSpaceURL;
    transient Vector m_traceListeners;
    static final String DEFAULT_ENCODING = "UTF-8";
    String m_liaisonClassUsedToCreate;
    public boolean m_useXercesSerializers = false;
    String m_outputmethod;
    String m_version;
    boolean m_indentResult = false;
    String m_encoding;
    String m_mediatype;
    String m_doctypeSystem;
    String m_doctypePublic;
    boolean m_omitxmlDecl = false;
    boolean m_standalone = false;
    QName[] m_cdataSectionElems;
    transient Stack m_importStack;
    public ElemTemplate m_defaultTextRule;
    public ElemTemplate m_defaultRule;
    public ElemTemplate m_defaultRootRule;

    private void readObject(ObjectInputStream objectInputStream) throws IOException, SAXException {
        try {
            objectInputStream.defaultReadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XSLProcessorException(classNotFoundException);
        }
        this.m_traceListeners = null;
    }

    public void addTraceListener(TraceListener traceListener) throws TooManyListenersException {
        if (this.m_traceListeners == null) {
            this.m_traceListeners = new Vector();
        }
        this.m_traceListeners.addElement(traceListener);
    }

    public void removeTraceListener(TraceListener traceListener) {
        if (this.m_traceListeners != null) {
            this.m_traceListeners.removeElement(traceListener);
        }
    }

    void fireTraceEvent(TracerEvent tracerEvent) {
        if (this.m_traceListeners != null) {
            int n = this.m_traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.m_traceListeners.elementAt(n2);
                traceListener.trace(tracerEvent);
                ++n2;
            }
        }
    }

    void fireSelectedEvent(SelectionEvent selectionEvent) throws SAXException {
        if (this.m_traceListeners != null) {
            int n = this.m_traceListeners.size();
            int n2 = 0;
            while (n2 < n) {
                TraceListener traceListener = (TraceListener)this.m_traceListeners.elementAt(n2);
                traceListener.selected(selectionEvent);
                ++n2;
            }
        }
    }

    public StylesheetRoot(XSLTEngineImpl xSLTEngineImpl, String string) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        super(null, xSLTEngineImpl, string);
    }

    protected void init(XSLTEngineImpl xSLTEngineImpl) throws XSLProcessorException, MalformedURLException, FileNotFoundException, IOException, SAXException {
        this.m_liaisonClassUsedToCreate = xSLTEngineImpl.getXMLProcessorLiaison().getClass().getName();
        this.m_importStack = new Stack();
        if (this.m_baseIdent == null) {
            this.m_baseIdent = "";
        }
        URL uRL = xSLTEngineImpl.getURLFromString(this.m_baseIdent, null);
        this.m_baseIdent = uRL.toExternalForm();
        this.m_importStack.push(xSLTEngineImpl.getURLFromString(this.m_baseIdent, null));
        this.m_stylesheetRoot = this;
        super.init(xSLTEngineImpl);
    }

    public OutputFormat getOutputFormat() {
        OutputFormat outputFormat = new OutputFormat(this.getOutputMethod(), this.getOutputEncoding(), this.getOutputIndent());
        outputFormat.setDoctype(this.getOutputDoctypePublic(), this.getOutputDoctypeSystem());
        outputFormat.setOmitXMLDeclaration(this.getOmitOutputXMLDecl());
        outputFormat.setStandalone(this.getOutputStandalone());
        outputFormat.setMediaType(this.getOutputMediaType());
        outputFormat.setVersion(this.getOutputVersion());
        if (this.getOutputIndent()) {
            outputFormat.setIndent(outputFormat.getIndent() + 1);
        }
        return outputFormat;
    }

    public void process(XSLTInputSource xSLTInputSource, XSLTResultTarget xSLTResultTarget) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        XSLTProcessor xSLTProcessor;
        if (this.m_liaisonClassUsedToCreate != null) {
            new XSLTProcessorFactory();
            xSLTProcessor = XSLTProcessorFactory.getProcessorUsingLiaisonName(this.m_liaisonClassUsedToCreate);
        } else {
            new XSLTProcessorFactory();
            xSLTProcessor = XSLTProcessorFactory.getProcessor();
        }
        XSLTProcessor xSLTProcessor2 = xSLTProcessor;
        this.process(xSLTProcessor2, xSLTProcessor2.getSourceTreeFromInput(xSLTInputSource), xSLTResultTarget);
    }

    public void process(XSLTProcessor xSLTProcessor, XSLTInputSource xSLTInputSource, XSLTResultTarget xSLTResultTarget) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        this.process(xSLTProcessor, xSLTProcessor.getSourceTreeFromInput(xSLTInputSource), xSLTResultTarget);
    }

    public void process(XSLTProcessor xSLTProcessor, Node node, XSLTResultTarget xSLTResultTarget) throws SAXException, MalformedURLException, FileNotFoundException, IOException {
        XSLTEngineImpl xSLTEngineImpl;
        XSLTEngineImpl xSLTEngineImpl2 = xSLTEngineImpl = (XSLTEngineImpl)xSLTProcessor;
        synchronized (xSLTEngineImpl2) {
            OutputStream outputStream;
            block32: {
                xSLTEngineImpl.switchLiaisonsIfNeeded(node, xSLTResultTarget.getNode());
                xSLTEngineImpl.m_stylesheetRoot = this;
                outputStream = null;
                try {
                    Object object;
                    xSLTEngineImpl.getXMLProcessorLiaison().checkNode(node);
                    Enumeration enumeration = this.m_extensionNamespaces.keys();
                    while (enumeration.hasMoreElements()) {
                        object = enumeration.nextElement();
                        xSLTEngineImpl.getExecContext().addExtensionNamespace((String)object, (ExtensionFunctionHandler)this.m_extensionNamespaces.get(object));
                    }
                    object = this.findTemplate(xSLTEngineImpl, node, node);
                    if (object == null) {
                        object = this.m_defaultRootRule;
                    }
                    DocumentHandler documentHandler = xSLTResultTarget.getDocumentHandler();
                    OutputFormat outputFormat = this.getOutputFormat();
                    if (xSLTResultTarget.getEncoding() != null) {
                        outputFormat.setEncoding(xSLTResultTarget.getEncoding());
                    }
                    if (documentHandler != null) {
                        xSLTEngineImpl.m_flistener = documentHandler;
                    } else if (xSLTResultTarget.getByteStream() != null) {
                        if (xSLTEngineImpl.m_parserLiaison.getIndent() >= 0) {
                            outputFormat.setIndent(xSLTEngineImpl.m_parserLiaison.getIndent() + 1);
                        }
                        xSLTEngineImpl.m_flistener = this.makeSAXSerializer(xSLTResultTarget.getByteStream(), outputFormat);
                    } else if (xSLTResultTarget.getCharacterStream() != null) {
                        if (xSLTEngineImpl.m_parserLiaison.getIndent() >= 0) {
                            outputFormat.setIndent(xSLTEngineImpl.m_parserLiaison.getIndent() + 1);
                        }
                        xSLTEngineImpl.m_flistener = this.makeSAXSerializer(xSLTResultTarget.getCharacterStream(), outputFormat);
                    } else if (xSLTResultTarget.getFileName() != null) {
                        if (xSLTEngineImpl.m_parserLiaison.getIndent() >= 0) {
                            outputFormat.setIndent(xSLTEngineImpl.m_parserLiaison.getIndent() + 1);
                        }
                        outputStream = new FileOutputStream(xSLTResultTarget.getFileName());
                        xSLTEngineImpl.m_flistener = this.makeSAXSerializer(outputStream, outputFormat);
                    } else if (xSLTResultTarget.getNode() != null) {
                        if (xSLTEngineImpl.getXMLProcessorLiaison() instanceof DTMLiaison) {
                            xSLTEngineImpl.error(96);
                        }
                        switch (xSLTResultTarget.getNode().getNodeType()) {
                            case 9: {
                                xSLTEngineImpl.m_flistener = new FormatterToDOM((Document)xSLTResultTarget.getNode());
                                break;
                            }
                            case 11: {
                                xSLTEngineImpl.m_flistener = new FormatterToDOM(xSLTEngineImpl.m_parserLiaison.createDocument(), (DocumentFragment)xSLTResultTarget.getNode());
                                break;
                            }
                            case 1: {
                                xSLTEngineImpl.m_flistener = new FormatterToDOM(xSLTEngineImpl.m_parserLiaison.createDocument(), (Element)xSLTResultTarget.getNode());
                                break;
                            }
                            default: {
                                this.error(43);
                                break;
                            }
                        }
                    } else {
                        xSLTResultTarget.setNode(xSLTEngineImpl.m_parserLiaison.createDocument());
                        xSLTEngineImpl.m_flistener = new FormatterToDOM((Document)xSLTResultTarget.getNode());
                    }
                    xSLTEngineImpl.resetCurrentState(node);
                    xSLTEngineImpl.m_rootDoc = node;
                    if (xSLTEngineImpl.m_diagnosticsPrintWriter != null) {
                        xSLTEngineImpl.diag("=============================");
                        xSLTEngineImpl.diag("Transforming...");
                        xSLTEngineImpl.pushTime(node);
                    }
                    xSLTEngineImpl.getVarStack().pushContextMarker();
                    try {
                        xSLTEngineImpl.resolveTopLevelParams();
                    }
                    catch (Exception exception) {
                        throw new SAXException(XSLMessages.createMessage(44, null), exception);
                    }
                    xSLTEngineImpl.m_resultTreeHandler.startDocument();
                    ((ElemTemplate)object).execute(xSLTEngineImpl, node, node, null);
                    xSLTEngineImpl.m_resultTreeHandler.endDocument();
                    xSLTEngineImpl.m_topLevelParams = new Vector();
                    if (xSLTEngineImpl.m_diagnosticsPrintWriter == null) break block32;
                    xSLTEngineImpl.displayDuration("transform", node);
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw throwable;
                }
            }
            Object var9_12 = null;
            if (outputStream != null) {
                outputStream.close();
            }
            return;
        }
    }

    public DocumentHandler makeSAXSerializer(Writer writer, OutputFormat outputFormat) {
        Object object;
        if (this.m_useXercesSerializers) {
            object = new XMLSerializer(writer, outputFormat);
        } else if (outputFormat == null) {
            outputFormat = new OutputFormat("xml", DEFAULT_ENCODING, false);
            FormatterToXML formatterToXML = new FormatterToXML();
            formatterToXML.init(writer, outputFormat);
            object = formatterToXML;
        } else if (outputFormat.getMethod().equalsIgnoreCase("html")) {
            FormatterToHTML formatterToHTML = new FormatterToHTML();
            formatterToHTML.init(writer, outputFormat);
            object = formatterToHTML;
        } else if (outputFormat.getMethod().equalsIgnoreCase("xml")) {
            FormatterToXML formatterToXML = new FormatterToXML();
            formatterToXML.init(writer, outputFormat);
            object = formatterToXML;
        } else {
            object = outputFormat.getMethod().equalsIgnoreCase("text") ? new FormatterToText(writer) : (outputFormat.getMethod().equalsIgnoreCase("xhtml") ? new XMLSerializer(writer, outputFormat) : new XMLSerializer(writer, outputFormat));
        }
        return object;
    }

    public DocumentHandler getSAXSerializer(OutputStream outputStream) throws UnsupportedEncodingException {
        return this.makeSAXSerializer(outputStream, this.getOutputFormat());
    }

    public DocumentHandler makeSAXSerializer(OutputStream outputStream, OutputFormat outputFormat) throws UnsupportedEncodingException {
        Object object;
        if (this.m_useXercesSerializers) {
            object = new XMLSerializer(outputStream, outputFormat);
        } else if (outputFormat == null) {
            outputFormat = new OutputFormat("xml", DEFAULT_ENCODING, false);
            FormatterToXML formatterToXML = new FormatterToXML();
            formatterToXML.init(outputStream, outputFormat);
            object = formatterToXML;
        } else if (outputFormat.getMethod().equalsIgnoreCase("html")) {
            FormatterToHTML formatterToHTML = new FormatterToHTML();
            formatterToHTML.init(outputStream, outputFormat);
            object = formatterToHTML;
        } else if (outputFormat.getMethod().equalsIgnoreCase("xml")) {
            FormatterToXML formatterToXML = new FormatterToXML();
            formatterToXML.init(outputStream, outputFormat);
            object = formatterToXML;
        } else if (outputFormat.getMethod().equalsIgnoreCase("text")) {
            String string = outputFormat.getEncoding();
            if (string == null) {
                try {
                    string = System.getProperty("file.encoding");
                    String string2 = string = string != null ? FormatterToXML.convertJava2MimeEncoding(string) : "ASCII";
                    if (string == null) {
                        string = "ASCII";
                    }
                }
                catch (SecurityException securityException) {
                    string = "ASCII";
                }
            }
            this.m_encoding = string;
            String string3 = FormatterToXML.convertMime2JavaEncoding(string);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string3);
            object = new FormatterToText(outputStreamWriter);
        } else {
            object = outputFormat.getMethod().equalsIgnoreCase("xhtml") ? new XMLSerializer(outputStream, outputFormat) : new XMLSerializer(outputStream, outputFormat);
        }
        return object;
    }

    public String getOutputMethod() {
        if (this.m_outputmethod == null) {
            return "xml";
        }
        return this.m_outputmethod;
    }

    public boolean isOutputMethodSet() {
        return this.m_outputmethod != null;
    }

    public void setOutputMethod(String string) {
        this.m_outputmethod = string;
    }

    public String getOutputVersion() {
        return this.m_version;
    }

    public boolean getOutputIndent() {
        return this.m_indentResult;
    }

    public String getOutputEncoding() {
        return this.m_encoding;
    }

    public String getOutputMediaType() {
        return this.m_mediatype;
    }

    public String getOutputDoctypeSystem() {
        return this.m_doctypeSystem;
    }

    public String getOutputDoctypePublic() {
        return this.m_doctypePublic;
    }

    public boolean getOmitOutputXMLDecl() {
        return this.m_omitxmlDecl;
    }

    public boolean getOutputStandalone() {
        return this.m_standalone;
    }

    public QName[] getCDataSectionElems() {
        return this.m_cdataSectionElems;
    }

    void processOutputSpec(String string, AttributeList attributeList) throws SAXException {
        int n = attributeList.getLength();
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            String string2 = attributeList.getName(n2);
            if (string2.equals("method")) {
                this.m_outputmethod = attributeList.getValue(n2);
            } else if (string2.equals("version")) {
                this.m_version = attributeList.getValue(n2);
            } else if (string2.equals("indent")) {
                this.m_indentResult = this.getYesOrNo(string2, attributeList.getValue(n2));
                bl = true;
            } else if (string2.equals("encoding")) {
                this.m_encoding = attributeList.getValue(n2);
            } else if (string2.equals("media-type")) {
                this.m_mediatype = attributeList.getValue(n2);
            } else if (string2.equals("doctype-system")) {
                this.m_doctypeSystem = attributeList.getValue(n2);
            } else if (string2.equals("doctype-public")) {
                this.m_doctypePublic = attributeList.getValue(n2);
            } else if (string2.equals("omit-xml-declaration")) {
                this.m_omitxmlDecl = this.getYesOrNo(string2, attributeList.getValue(n2));
            } else if (string2.equals("standalone")) {
                this.m_standalone = this.getYesOrNo(string2, attributeList.getValue(n2));
            } else if (string2.equals("cdata-section-elements")) {
                Object object;
                int n3;
                StringTokenizer stringTokenizer = new StringTokenizer(attributeList.getValue(n2));
                int n4 = stringTokenizer.countTokens();
                if (this.m_cdataSectionElems == null) {
                    this.m_cdataSectionElems = new QName[n4];
                    n3 = 0;
                } else {
                    object = this.m_cdataSectionElems;
                    int n5 = ((QName[])object).length;
                    this.m_cdataSectionElems = new QName[n4 + n5];
                    int n6 = 0;
                    while (n6 < n5) {
                        this.m_cdataSectionElems[n6] = object[n6];
                        ++n6;
                    }
                    n3 = n5;
                }
                while (stringTokenizer.hasMoreTokens()) {
                    QName qName;
                    object = stringTokenizer.nextToken();
                    this.m_cdataSectionElems[n3] = qName = new QName((String)object, this.m_namespaces);
                    ++n3;
                }
            } else if (!this.isAttrOK(string2, attributeList, n2)) {
                throw new SAXException(XSLMessages.createMessage(2, new Object[]{string, string2}));
            }
            ++n2;
        }
        if (this.m_outputmethod != null && this.m_outputmethod.equals("html") && !bl) {
            this.m_indentResult = true;
        }
    }

    boolean isRoot() {
        return true;
    }

    void initDefaultRule() throws XSLProcessorException, SAXException {
        int n = 0;
        int n2 = 0;
        MutableAttrListImpl mutableAttrListImpl = new MutableAttrListImpl();
        mutableAttrListImpl.addAttribute("match", "CDATA", "*");
        this.m_defaultRule = new ElemTemplate(null, this, "xsl:template", mutableAttrListImpl, n, n2);
        mutableAttrListImpl.clear();
        ElemApplyTemplates elemApplyTemplates = new ElemApplyTemplates(null, this, "xsl:apply-templates", mutableAttrListImpl, n, n2);
        elemApplyTemplates.m_isDefaultTemplate = true;
        this.m_defaultRule.appendChild(elemApplyTemplates);
        mutableAttrListImpl.clear();
        mutableAttrListImpl.addAttribute("match", "CDATA", "text() | @*");
        this.m_defaultTextRule = new ElemTemplate(null, this, "xsl:template", mutableAttrListImpl, n, n2);
        mutableAttrListImpl.clear();
        mutableAttrListImpl.addAttribute("select", "CDATA", ".");
        ElemValueOf elemValueOf = new ElemValueOf(null, this, "xsl:value-of", mutableAttrListImpl, n, n2);
        this.m_defaultTextRule.appendChild(elemValueOf);
        mutableAttrListImpl.clear();
        mutableAttrListImpl.addAttribute("match", "CDATA", "/");
        this.m_defaultRootRule = new ElemTemplate(null, this, "xsl:template", mutableAttrListImpl, n, n2);
        mutableAttrListImpl.clear();
        elemApplyTemplates = new ElemApplyTemplates(null, this, "xsl:apply-templates", mutableAttrListImpl, n, n2);
        elemApplyTemplates.m_isDefaultTemplate = true;
        this.m_defaultRootRule.appendChild(elemApplyTemplates);
    }
}

