/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.utils;

import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.utils.ImplementationMessages;
import org.apache.xerces.utils.StringHasher;
import org.apache.xerces.utils.StringPool;

public final class CharDataChunk
implements StringPool.StringProducer {
    public static final int CHUNK_SHIFT = 14;
    public static final int CHUNK_SIZE = 16384;
    public static final int CHUNK_MASK = 16383;
    private StringPool fStringPool;
    private int fRefCount;
    private int fChunk;
    private char[] fData;
    private CharDataChunk fNextChunk;
    private CharDataChunk fPreviousChunk;
    private static CharDataChunk fgFreeChunks = null;
    static /* synthetic */ Class class$org$apache$xerces$utils$CharDataChunk;

    public static CharDataChunk createChunk(StringPool stringPool, CharDataChunk charDataChunk) {
        CharDataChunk charDataChunk2 = null;
        Class clazz = class$org$apache$xerces$utils$CharDataChunk != null ? class$org$apache$xerces$utils$CharDataChunk : (class$org$apache$xerces$utils$CharDataChunk = CharDataChunk.class$("org.apache.xerces.utils.CharDataChunk"));
        synchronized (clazz) {
            charDataChunk2 = fgFreeChunks;
            if (charDataChunk2 != null) {
                fgFreeChunks = charDataChunk2.fNextChunk;
            } else {
                charDataChunk2 = new CharDataChunk();
            }
        }
        charDataChunk2.fStringPool = stringPool;
        charDataChunk2.fRefCount = 1;
        charDataChunk2.fChunk = charDataChunk == null ? 0 : charDataChunk.fChunk + 1;
        charDataChunk2.fNextChunk = null;
        charDataChunk2.fPreviousChunk = charDataChunk;
        if (charDataChunk != null) {
            charDataChunk.setNextChunk(charDataChunk2);
        }
        return charDataChunk2;
    }

    public CharDataChunk chunkFor(int n) {
        int n2 = n >> 14;
        if (n2 == this.fChunk) {
            return this;
        }
        CharDataChunk charDataChunk = this.fPreviousChunk;
        while (n2 != charDataChunk.fChunk) {
            charDataChunk = charDataChunk.fPreviousChunk;
        }
        return charDataChunk;
    }

    public char[] toCharArray() {
        return this.fData;
    }

    public void setCharArray(char[] cArray) {
        this.fData = cArray;
    }

    public CharDataChunk nextChunk() {
        return this.fNextChunk;
    }

    public boolean clearPreviousChunk() {
        if (this.fPreviousChunk != null) {
            this.fPreviousChunk.clearNextChunk();
            this.fPreviousChunk.removeRef();
            this.fPreviousChunk = null;
            return true;
        }
        return false;
    }

    public void releaseChunk() {
        this.removeRef();
    }

    public int addString(int n, int n2) {
        int n3 = n >> 14;
        if (n3 != this.fChunk) {
            if (this.fPreviousChunk == null) {
                throw new RuntimeException(new ImplementationMessages().createMessage(null, 15, 0, null));
            }
            return this.fPreviousChunk.addString(n, n2);
        }
        int n4 = n + n2 - 1 >> 14;
        if (n3 == n4) {
            this.addRef();
            return this.fStringPool.addString(this, n & 0x3FFF, n2);
        }
        String string = this.toString(n & 0x3FFF, n2);
        return this.fStringPool.addString(string);
    }

    public int addSymbol(int n, int n2, int n3) {
        int n4 = n >> 14;
        if (n4 != this.fChunk) {
            if (this.fPreviousChunk == null) {
                throw new RuntimeException(new ImplementationMessages().createMessage(null, 15, 0, null));
            }
            return this.fPreviousChunk.addSymbol(n, n2, n3);
        }
        int n5 = n + n2 - 1 >> 14;
        int n6 = n & 0x3FFF;
        if (n4 == n5) {
            int n7;
            if (n3 == 0) {
                n3 = StringHasher.hashChars(this.fData, n6, n2);
            }
            if ((n7 = this.fStringPool.lookupSymbol(this, n & 0x3FFF, n2, n3)) == -1) {
                String string = this.toString(n & 0x3FFF, n2);
                n7 = this.fStringPool.addNewSymbol(string, n3);
            }
            return n7;
        }
        String string = this.toString(n & 0x3FFF, n2);
        return this.fStringPool.addSymbol(string);
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
        CharDataChunk charDataChunk = this.chunkFor(n);
        int n3 = n & 0x3FFF;
        int n4 = n3 + n2 <= 16384 ? n2 : 16384 - n3;
        while (true) {
            charBuffer.append(charDataChunk.fData, n3, n4);
            if ((n2 -= n4) == 0) break;
            charDataChunk = charDataChunk.fNextChunk;
            n3 = 0;
            n4 = n2 <= 16384 ? n2 : 16384;
        }
    }

    public String toString(int n, int n2) {
        if (n + n2 <= 16384) {
            return new String(this.fData, n, n2);
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 16384 - n;
        stringBuffer.append(this.fData, n, n3);
        n2 -= n3;
        CharDataChunk charDataChunk = this.fNextChunk;
        do {
            n3 = n2 <= 16384 ? n2 : 16384;
            stringBuffer.append(charDataChunk.fData, 0, n3);
            charDataChunk = charDataChunk.fNextChunk;
        } while ((n2 -= n3) > 0);
        String string = stringBuffer.toString();
        stringBuffer = null;
        return string;
    }

    public void releaseString(int n, int n2) {
        this.removeRef();
    }

    public boolean equalsString(int n, int n2, char[] cArray, int n3, int n4) {
        if (n2 != n4) {
            return false;
        }
        if (n + n2 <= 16384) {
            int n5 = 0;
            while (n5 < n2) {
                if (this.fData[n++] != cArray[n3++]) {
                    return false;
                }
                ++n5;
            }
            return true;
        }
        int n6 = 16384 - n;
        n2 -= n6;
        while (n6-- > 0) {
            if (this.fData[n++] == cArray[n3++]) continue;
            return false;
        }
        CharDataChunk charDataChunk = this.fNextChunk;
        do {
            n = 0;
            n6 = n2 <= 16384 ? n2 : 16384;
            n2 -= n6;
            while (n6-- > 0) {
                if (charDataChunk.fData[n++] == cArray[n3++]) continue;
                return false;
            }
            charDataChunk = charDataChunk.fNextChunk;
        } while (n2 > 0);
        return true;
    }

    private CharDataChunk() {
    }

    private void addRef() {
        ++this.fRefCount;
    }

    private void removeRef() {
        --this.fRefCount;
        if (this.fRefCount == 0) {
            this.fStringPool = null;
            this.fChunk = -1;
            this.fPreviousChunk = null;
            Class clazz = class$org$apache$xerces$utils$CharDataChunk != null ? class$org$apache$xerces$utils$CharDataChunk : (class$org$apache$xerces$utils$CharDataChunk = CharDataChunk.class$("org.apache.xerces.utils.CharDataChunk"));
            synchronized (clazz) {
                this.fNextChunk = null;
                fgFreeChunks = this;
                return;
            }
        }
    }

    private void clearNextChunk() {
        if (this.fNextChunk != null) {
            this.fNextChunk.removeRef();
        }
        this.fNextChunk = null;
    }

    private void setNextChunk(CharDataChunk charDataChunk) {
        if (this.fNextChunk != null) {
            throw new RuntimeException("CharDataChunk::setNextChunk");
        }
        charDataChunk.addRef();
        this.fNextChunk = charDataChunk;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

