/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DeferredNode;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.utils.StringPool;
import org.w3c.dom.NamedNodeMap;

public class DeferredElementImpl
extends ElementImpl
implements DeferredNode {
    static final long serialVersionUID = -7670981133940934842L;
    protected transient int fNodeIndex;

    DeferredElementImpl(DeferredDocumentImpl deferredDocumentImpl, int n) {
        super(deferredDocumentImpl, null);
        this.fNodeIndex = n;
        this.syncData = true;
        this.syncChildren = true;
    }

    public final int getNodeIndex() {
        return this.fNodeIndex;
    }

    protected final void synchronizeData() {
        this.syncData = false;
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        int n = deferredDocumentImpl.getNodeName(this.fNodeIndex);
        StringPool stringPool = deferredDocumentImpl.getStringPool();
        this.name = stringPool.toString(n);
        this.setupDefaultAttributes();
        int n2 = deferredDocumentImpl.getNodeValue(this.fNodeIndex);
        if (n2 != -1) {
            NamedNodeMap namedNodeMap = this.getAttributes();
            do {
                NodeImpl nodeImpl = (NodeImpl)((Object)deferredDocumentImpl.getNodeObject(n2));
                namedNodeMap.setNamedItem(nodeImpl);
                nodeImpl.parentNode = this;
            } while ((n2 = deferredDocumentImpl.getNextSibling(n2)) != -1);
        }
    }

    protected final void synchronizeChildren() {
        this.syncChildren = false;
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        NodeImpl nodeImpl = null;
        int n = deferredDocumentImpl.getFirstChild(this.fNodeIndex);
        while (n != -1) {
            NodeImpl nodeImpl2 = (NodeImpl)((Object)deferredDocumentImpl.getNodeObject(n));
            if (nodeImpl == null) {
                this.firstChild = nodeImpl2;
            } else {
                nodeImpl.nextSibling = nodeImpl2;
            }
            nodeImpl2.parentNode = this;
            nodeImpl2.previousSibling = nodeImpl;
            nodeImpl = nodeImpl2;
            n = deferredDocumentImpl.getNextSibling(n);
        }
        if (nodeImpl != null) {
            this.lastChild = nodeImpl;
        }
    }
}

