/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.precompiler;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.exceptions.JSilverAutoEscapingException;
import com.google.clearsilver.jsilver.precompiler.PrecompiledTemplateMapKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecompiledTemplateMapFileReader {
    private final String mapFileName;
    private final String dirPattern;
    private final String rootDir;
    private Map<Object, String> templateMap = null;

    public PrecompiledTemplateMapFileReader(String filename, String dirPattern, String rootDir) {
        this.mapFileName = filename;
        this.dirPattern = dirPattern;
        this.rootDir = rootDir;
    }

    public Map<Object, String> getTemplateMap() throws IOException {
        if (this.templateMap == null) {
            this.templateMap = this.makeTemplateMap(this.mapFileName, this.rootDir);
        }
        return this.templateMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, String> makeTemplateMap(String templateMapFile, String rootDir) throws IOException {
        HashMap<Object, String> templateMap = new HashMap<Object, String>();
        BufferedReader reader = null;
        try {
            reader = new LineNumberReader(this.getMapFileReader(templateMapFile));
            String line = ((LineNumberReader)reader).readLine();
            while (line != null) {
                this.processTemplateMapFileLine(line, ((LineNumberReader)reader).getLineNumber(), templateMap, templateMapFile, rootDir);
                line = ((LineNumberReader)reader).readLine();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return ImmutableMap.copyOf(templateMap);
    }

    private void processTemplateMapFileLine(String line, int lineNumber, Map<Object, String> templateMap, String templateMapFile, String rootDir) {
        EscapeMode escapeMode;
        if ((line = line.trim()).isEmpty() || line.startsWith("#")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(line);
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException("No template file name found in " + templateMapFile + " on line " + lineNumber + ": " + line);
        }
        String templateName = st.nextToken();
        if (this.dirPattern != null && templateName.startsWith(this.dirPattern)) {
            templateName = templateName.substring(this.dirPattern.length());
        }
        if (rootDir != null) {
            templateName = rootDir + templateName;
        }
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException("No class name found in " + templateMapFile + " on line " + lineNumber + ": " + line);
        }
        String className = st.nextToken();
        if (!st.hasMoreTokens()) {
            escapeMode = EscapeMode.ESCAPE_NONE;
        } else {
            String escapeCmd = st.nextToken();
            try {
                escapeMode = EscapeMode.computeEscapeMode(escapeCmd);
            }
            catch (JSilverAutoEscapingException e) {
                throw new IllegalArgumentException("Invalid escape mode found in " + templateMapFile + " on line " + lineNumber + ": " + escapeCmd);
            }
        }
        PrecompiledTemplateMapKey key = new PrecompiledTemplateMapKey(templateName, escapeMode);
        templateMap.put(key, className);
    }

    @VisibleForTesting
    protected Reader getMapFileReader(String templateMapFile) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream in = classLoader.getResourceAsStream(templateMapFile);
        if (in == null) {
            throw new FileNotFoundException("Unable to locate resource: " + templateMapFile);
        }
        return new InputStreamReader(in, "UTF-8");
    }
}

