/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.exceptions.JSilverInterpreterException;
import com.google.clearsilver.jsilver.interpreter.TemplateInterpreter;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.syntax.node.PCommand;
import com.google.clearsilver.jsilver.template.Macro;
import com.google.clearsilver.jsilver.template.RenderingContext;
import com.google.clearsilver.jsilver.template.Template;
import java.io.IOException;

public class InterpretedMacro
implements Macro {
    private final PCommand command;
    private final Template owningTemplate;
    private final String macroName;
    private final String[] argumentNames;
    private final TemplateInterpreter templateInterpreter;
    private final RenderingContext owningContext;

    public InterpretedMacro(PCommand command, Template owningTemplate, String macroName, String[] argumentNames, TemplateInterpreter templateInterpreter, RenderingContext owningContext) {
        this.command = command;
        this.owningTemplate = owningTemplate;
        this.macroName = macroName;
        this.argumentNames = argumentNames;
        this.templateInterpreter = templateInterpreter;
        this.owningContext = owningContext;
    }

    public void render(RenderingContext context) throws IOException {
        boolean doRuntimeAutoEscaping;
        assert (context == this.owningContext) : "Cannot render macro defined in another context";
        context.pushExecutionContext(this);
        boolean bl = doRuntimeAutoEscaping = !context.isRuntimeAutoEscaping();
        if (doRuntimeAutoEscaping) {
            context.startRuntimeAutoEscaping();
        }
        this.command.apply(this.templateInterpreter);
        if (doRuntimeAutoEscaping) {
            context.stopRuntimeAutoEscaping();
        }
        context.popExecutionContext();
    }

    public void render(Data data, Appendable out, ResourceLoader resourceLoader) throws IOException {
        this.render(this.createRenderingContext(data, out, resourceLoader));
    }

    public RenderingContext createRenderingContext(Data data, Appendable out, ResourceLoader resourceLoader) {
        return this.owningTemplate.createRenderingContext(data, out, resourceLoader);
    }

    public String getTemplateName() {
        return this.owningTemplate.getTemplateName();
    }

    public EscapeMode getEscapeMode() {
        return this.owningTemplate.getEscapeMode();
    }

    public String getDisplayName() {
        return this.owningTemplate.getDisplayName() + ":" + this.macroName;
    }

    public String getMacroName() {
        return this.macroName;
    }

    public String getArgumentName(int index) {
        if (index >= this.argumentNames.length) {
            throw new JSilverInterpreterException("Too many arguments supplied to macro " + this.macroName);
        }
        return this.argumentNames[index];
    }

    public int getArgumentCount() {
        return this.argumentNames.length;
    }
}

