/*
 * Decompiled with CFR 0.152.
 */
package org.testng.guice;

import java.lang.reflect.Field;
import org.testng.guice.InjectorImpl;
import org.testng.guice.SingleMemberInjector;
import org.testng.guice.internal.Errors;
import org.testng.guice.internal.ErrorsException;
import org.testng.guice.internal.InternalContext;
import org.testng.guice.internal.InternalFactory;
import org.testng.guice.spi.Dependency;
import org.testng.guice.spi.InjectionPoint;

class SingleFieldInjector
implements SingleMemberInjector {
    final Field field;
    final InjectionPoint injectionPoint;
    final Dependency<?> dependency;
    final InternalFactory<?> factory;

    public SingleFieldInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        this.field = (Field)injectionPoint.getMember();
        this.dependency = injectionPoint.getDependencies().get(0);
        this.field.setAccessible(true);
        this.factory = injector.getInternalFactory(this.dependency.getKey(), errors);
    }

    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    public void inject(Errors errors, InternalContext context, Object o) {
        errors = errors.withSource(this.dependency);
        context.setDependency(this.dependency);
        try {
            Object value = this.factory.get(errors, context, this.dependency);
            this.field.set(o, value);
        }
        catch (ErrorsException e) {
            errors.withSource(this.injectionPoint).merge(e.getErrors());
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            context.setDependency(null);
        }
    }
}

