/*
 * Decompiled with CFR 0.152.
 */
package org.testng.guice;

import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.guice.Binder;
import org.testng.guice.Binding;
import org.testng.guice.ConfigurationException;
import org.testng.guice.ConstantFactory;
import org.testng.guice.ConstructorBindingImpl;
import org.testng.guice.ConstructorInjectorStore;
import org.testng.guice.ContextualCallable;
import org.testng.guice.DeferredLookups;
import org.testng.guice.ImplementedBy;
import org.testng.guice.Initializables;
import org.testng.guice.Initializer;
import org.testng.guice.Injector;
import org.testng.guice.InjectorBuilder;
import org.testng.guice.Key;
import org.testng.guice.Lookups;
import org.testng.guice.MembersInjector;
import org.testng.guice.MembersInjectorImpl;
import org.testng.guice.MembersInjectorStore;
import org.testng.guice.Module;
import org.testng.guice.ProvidedBy;
import org.testng.guice.Provider;
import org.testng.guice.ProvisionException;
import org.testng.guice.Scopes;
import org.testng.guice.SingleParameterInjector;
import org.testng.guice.State;
import org.testng.guice.TypeLiteral;
import org.testng.guice.internal.Annotations;
import org.testng.guice.internal.BindingImpl;
import org.testng.guice.internal.Classes;
import org.testng.guice.internal.Errors;
import org.testng.guice.internal.ErrorsException;
import org.testng.guice.internal.ImmutableList;
import org.testng.guice.internal.ImmutableSet;
import org.testng.guice.internal.InstanceBindingImpl;
import org.testng.guice.internal.InternalContext;
import org.testng.guice.internal.InternalFactory;
import org.testng.guice.internal.LinkedBindingImpl;
import org.testng.guice.internal.LinkedProviderBindingImpl;
import org.testng.guice.internal.Lists;
import org.testng.guice.internal.Maps;
import org.testng.guice.internal.MatcherAndConverter;
import org.testng.guice.internal.Nullable;
import org.testng.guice.internal.Scoping;
import org.testng.guice.internal.SourceProvider;
import org.testng.guice.internal.ToStringBuilder;
import org.testng.guice.spi.BindingTargetVisitor;
import org.testng.guice.spi.ConvertedConstantBinding;
import org.testng.guice.spi.Dependency;
import org.testng.guice.spi.InjectionPoint;
import org.testng.guice.spi.ProviderBinding;
import org.testng.guice.spi.ProviderKeyBinding;
import org.testng.guice.util.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InjectorImpl
implements Injector,
Lookups {
    final State state;
    final InjectorImpl parent;
    final BindingsMultimap bindingsMultimap = new BindingsMultimap();
    final Initializer initializer;
    final Map<Key<?>, BindingImpl<?>> jitBindings = Maps.newHashMap();
    Lookups lookups = new DeferredLookups(this);
    final ConstructorInjectorStore constructors = new ConstructorInjectorStore(this);
    MembersInjectorStore membersInjectorStore;
    final ThreadLocal<Object[]> localContext;

    InjectorImpl(@Nullable InjectorImpl parent, State state, Initializer initializer) {
        this.parent = parent;
        this.state = state;
        this.initializer = initializer;
        this.localContext = parent != null ? parent.localContext : new ThreadLocal<Object[]>(){

            @Override
            protected Object[] initialValue() {
                return new Object[1];
            }
        };
    }

    void index() {
        for (Binding<?> binding : this.state.getExplicitBindingsThisLevel().values()) {
            this.index(binding);
        }
    }

    <T> void index(Binding<T> binding) {
        this.bindingsMultimap.put(binding.getKey().getTypeLiteral(), binding);
    }

    @Override
    public <T> List<Binding<T>> findBindingsByType(TypeLiteral<T> type) {
        return this.bindingsMultimap.getAll(type);
    }

    public <T> BindingImpl<T> getBinding(Key<T> key) {
        Errors errors = new Errors(key);
        try {
            BindingImpl<T> result = this.getBindingOrThrow(key, errors);
            errors.throwConfigurationExceptionIfErrorsExist();
            return result;
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(errors.merge(e.getErrors()).getMessages());
        }
    }

    public <T> BindingImpl<T> getBindingOrThrow(Key<T> key, Errors errors) throws ErrorsException {
        BindingImpl<T> binding = this.state.getExplicitBinding(key);
        if (binding != null) {
            return binding;
        }
        return this.getJustInTimeBinding(key, errors);
    }

    @Override
    public <T> Binding<T> getBinding(Class<T> type) {
        return this.getBinding((Key)Key.get(type));
    }

    @Override
    public Injector getParent() {
        return this.parent;
    }

    @Override
    public Injector createChildInjector(Iterable<? extends Module> modules) {
        return new InjectorBuilder().parentInjector(this).addModules(modules).build();
    }

    @Override
    public Injector createChildInjector(Module ... modules) {
        return this.createChildInjector(ImmutableList.of(modules));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BindingImpl<T> getJustInTimeBinding(Key<T> key, Errors errors) throws ErrorsException {
        Object object = this.state.lock();
        synchronized (object) {
            InjectorImpl injector = this;
            while (injector != null) {
                BindingImpl<?> binding = injector.jitBindings.get(key);
                if (binding != null) {
                    return binding;
                }
                injector = injector.parent;
            }
            return this.createJustInTimeBindingRecursive(key, errors);
        }
    }

    static boolean isProvider(Key<?> key) {
        return key.getTypeLiteral().getRawType().equals(Provider.class);
    }

    static boolean isMembersInjector(Key<?> key) {
        return key.getTypeLiteral().getRawType().equals(MembersInjector.class) && !key.hasAnnotationType();
    }

    private <T> BindingImpl<MembersInjector<T>> createMembersInjectorBinding(Key<MembersInjector<T>> key, Errors errors) throws ErrorsException {
        Type membersInjectorType = key.getTypeLiteral().getType();
        if (!(membersInjectorType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawMembersInjector().toException();
        }
        TypeLiteral<?> instanceType = TypeLiteral.get(((ParameterizedType)membersInjectorType).getActualTypeArguments()[0]);
        MembersInjectorImpl<?> membersInjector = this.membersInjectorStore.get(instanceType, errors);
        ConstantFactory factory = new ConstantFactory(Initializables.of(membersInjector));
        return new InstanceBindingImpl<MembersInjector<T>>(this, key, SourceProvider.UNKNOWN_SOURCE, factory, ImmutableSet.<InjectionPoint>of(), membersInjector);
    }

    private <T> BindingImpl<Provider<T>> createProviderBinding(Key<Provider<T>> key, Errors errors) throws ErrorsException {
        Type providerType = key.getTypeLiteral().getType();
        if (!(providerType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawProvider().toException();
        }
        Type entryType = ((ParameterizedType)providerType).getActualTypeArguments()[0];
        Key<?> providedKey = key.ofType(entryType);
        BindingImpl<?> delegate = this.getBindingOrThrow(providedKey, errors);
        return new ProviderBindingImpl<T>(this, key, delegate);
    }

    private <T> BindingImpl<T> convertConstantStringBinding(Key<T> key, Errors errors) throws ErrorsException {
        Key<String> stringKey = key.ofType(String.class);
        BindingImpl<String> stringBinding = this.state.getExplicitBinding(stringKey);
        if (stringBinding == null || !stringBinding.isConstant()) {
            return null;
        }
        String stringValue = stringBinding.getProvider().get();
        Object source = stringBinding.getSource();
        TypeLiteral<T> type = key.getTypeLiteral();
        MatcherAndConverter matchingConverter = this.state.getConverter(stringValue, type, errors, source);
        if (matchingConverter == null) {
            return null;
        }
        try {
            Object converted = matchingConverter.getTypeConverter().convert(stringValue, type);
            if (converted == null) {
                throw errors.converterReturnedNull(stringValue, source, type, matchingConverter).toException();
            }
            if (!type.getRawType().isInstance(converted)) {
                throw errors.conversionTypeError(stringValue, source, type, matchingConverter, converted).toException();
            }
            return new ConvertedConstantBindingImpl<Object>(this, key, converted, stringBinding);
        }
        catch (ErrorsException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw errors.conversionError(stringValue, source, type, matchingConverter, e).toException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void initializeBinding(BindingImpl<T> binding, Errors errors) throws ErrorsException {
        if (binding instanceof ConstructorBindingImpl) {
            Key<T> key = binding.getKey();
            this.jitBindings.put(key, binding);
            boolean successful = false;
            try {
                ((ConstructorBindingImpl)binding).initialize(this, errors);
                successful = true;
            }
            finally {
                if (!successful) {
                    this.jitBindings.remove(key);
                }
            }
        }
    }

    <T> BindingImpl<T> createUnitializedBinding(Key<T> key, Scoping scoping, Object source, Errors errors) throws ErrorsException {
        Class<? extends Annotation> scopeAnnotation;
        Class<T> rawType = key.getTypeLiteral().getRawType();
        if (rawType.isArray() || rawType.isEnum()) {
            throw errors.missingImplementation(key).toException();
        }
        if (rawType == TypeLiteral.class) {
            BindingImpl<TypeLiteral<T>> binding = this.createTypeLiteralBinding(key, errors);
            return binding;
        }
        ImplementedBy implementedBy = rawType.getAnnotation(ImplementedBy.class);
        if (implementedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(rawType, source, errors);
            return this.createImplementedByBinding(key, scoping, implementedBy, errors);
        }
        ProvidedBy providedBy = rawType.getAnnotation(ProvidedBy.class);
        if (providedBy != null) {
            Annotations.checkForMisplacedScopeAnnotations(rawType, source, errors);
            return this.createProvidedByBinding(key, scoping, providedBy, errors);
        }
        if (Modifier.isAbstract(rawType.getModifiers())) {
            throw errors.missingImplementation(key).toException();
        }
        if (Classes.isInnerClass(rawType)) {
            throw errors.cannotInjectInnerClass(rawType).toException();
        }
        if (!scoping.isExplicitlyScoped() && (scopeAnnotation = Annotations.findScopeAnnotation(errors, rawType)) != null) {
            scoping = Scopes.makeInjectable(Scoping.forAnnotation(scopeAnnotation), this, errors.withSource(rawType));
        }
        return ConstructorBindingImpl.create(this, key, source, scoping);
    }

    private <T> BindingImpl<TypeLiteral<T>> createTypeLiteralBinding(Key<TypeLiteral<T>> key, Errors errors) throws ErrorsException {
        Type typeLiteralType = key.getTypeLiteral().getType();
        if (!(typeLiteralType instanceof ParameterizedType)) {
            throw errors.cannotInjectRawTypeLiteral().toException();
        }
        ParameterizedType parameterizedType = (ParameterizedType)typeLiteralType;
        Type innerType = parameterizedType.getActualTypeArguments()[0];
        if (!(innerType instanceof Class || innerType instanceof GenericArrayType || innerType instanceof ParameterizedType)) {
            throw errors.cannotInjectTypeLiteralOf(innerType).toException();
        }
        TypeLiteral<?> value = TypeLiteral.get(innerType);
        ConstantFactory factory = new ConstantFactory(Initializables.of(value));
        return new InstanceBindingImpl<TypeLiteral<T>>(this, key, SourceProvider.UNKNOWN_SOURCE, factory, ImmutableSet.<InjectionPoint>of(), value);
    }

    <T> BindingImpl<T> createProvidedByBinding(Key<T> key, Scoping scoping, ProvidedBy providedBy, Errors errors) throws ErrorsException {
        final Class<T> rawType = key.getTypeLiteral().getRawType();
        final Class<? extends Provider<?>> providerType = providedBy.value();
        if (providerType == rawType) {
            throw errors.recursiveProviderType().toException();
        }
        final Key<? extends Provider<?>> providerKey = Key.get(providerType);
        final BindingImpl<? extends Provider<?>> providerBinding = this.getBindingOrThrow(providerKey, errors);
        InternalFactory internalFactory = new InternalFactory<T>(){

            @Override
            public T get(Errors errors, InternalContext context, Dependency dependency) throws ErrorsException {
                errors = errors.withSource(providerKey);
                Provider provider = (Provider)providerBinding.getInternalFactory().get(errors, context, dependency);
                try {
                    Object o = provider.get();
                    if (o != null && !rawType.isInstance(o)) {
                        throw errors.subtypeNotProvided(providerType, rawType).toException();
                    }
                    Object t = o;
                    return t;
                }
                catch (RuntimeException e) {
                    throw errors.errorInProvider(e).toException();
                }
            }
        };
        return new LinkedProviderBindingImpl<T>(this, key, rawType, Scopes.scope(key, this, internalFactory, scoping), scoping, providerKey);
    }

    <T> BindingImpl<T> createImplementedByBinding(Key<T> key, Scoping scoping, ImplementedBy implementedBy, Errors errors) throws ErrorsException {
        Class<T> rawType = key.getTypeLiteral().getRawType();
        Class<?> implementationType = implementedBy.value();
        if (implementationType == rawType) {
            throw errors.recursiveImplementationType().toException();
        }
        if (!rawType.isAssignableFrom(implementationType)) {
            throw errors.notASubtype(implementationType, rawType).toException();
        }
        Class<?> subclass = implementationType;
        final Key<?> targetKey = Key.get(subclass);
        final BindingImpl<?> targetBinding = this.getBindingOrThrow(targetKey, errors);
        InternalFactory internalFactory = new InternalFactory<T>(){

            @Override
            public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
                return targetBinding.getInternalFactory().get(errors.withSource(targetKey), context, dependency);
            }
        };
        return new LinkedBindingImpl<T>(this, key, rawType, Scopes.scope(key, this, internalFactory, scoping), scoping, targetKey);
    }

    private <T> BindingImpl<T> createJustInTimeBindingRecursive(Key<T> key, Errors errors) throws ErrorsException {
        if (this.parent != null) {
            try {
                return this.parent.createJustInTimeBindingRecursive(key, new Errors());
            }
            catch (ErrorsException ignored) {
                // empty catch block
            }
        }
        if (this.state.isBlacklisted(key)) {
            throw errors.childBindingAlreadySet(key).toException();
        }
        BindingImpl<T> binding = this.createJustInTimeBinding(key, errors);
        this.state.parent().blacklist(key);
        this.jitBindings.put(key, binding);
        return binding;
    }

    <T> BindingImpl<T> createJustInTimeBinding(Key<T> key, Errors errors) throws ErrorsException {
        if (this.state.isBlacklisted(key)) {
            throw errors.childBindingAlreadySet(key).toException();
        }
        if (InjectorImpl.isProvider(key)) {
            BindingImpl<Provider<T>> binding = this.createProviderBinding(key, errors);
            return binding;
        }
        if (InjectorImpl.isMembersInjector(key)) {
            BindingImpl<MembersInjector<T>> binding = this.createMembersInjectorBinding(key, errors);
            return binding;
        }
        BindingImpl<Provider<T>> convertedBinding = this.convertConstantStringBinding(key, errors);
        if (convertedBinding != null) {
            return convertedBinding;
        }
        if (key.hasAnnotationType()) {
            if (key.hasAttributes()) {
                try {
                    Errors ignored = new Errors();
                    return this.getBindingOrThrow(key.withoutAttributes(), ignored);
                }
                catch (ErrorsException ignored) {
                    // empty catch block
                }
            }
            throw errors.missingImplementation(key).toException();
        }
        Class<Provider<T>> source = key.getTypeLiteral().getRawType();
        BindingImpl<Provider<T>> binding = this.createUnitializedBinding(key, Scoping.UNSCOPED, source, errors);
        this.initializeBinding(binding, errors);
        return binding;
    }

    <T> InternalFactory<? extends T> getInternalFactory(Key<T> key, Errors errors) throws ErrorsException {
        return this.getBindingOrThrow(key, errors).getInternalFactory();
    }

    @Override
    public Map<Key<?>, Binding<?>> getBindings() {
        return this.state.getExplicitBindingsThisLevel();
    }

    SingleParameterInjector<?>[] getParametersInjectors(List<Dependency<?>> parameters, Errors errors) throws ErrorsException {
        if (parameters.isEmpty()) {
            return null;
        }
        int numErrorsBefore = errors.size();
        SingleParameterInjector[] result = new SingleParameterInjector[parameters.size()];
        int i = 0;
        for (Dependency<?> parameter : parameters) {
            try {
                result[i++] = this.createParameterInjector(parameter, errors.withSource(parameter));
            }
            catch (ErrorsException rethrownBelow) {}
        }
        errors.throwIfNewErrors(numErrorsBefore);
        return result;
    }

    <T> SingleParameterInjector<T> createParameterInjector(Dependency<T> dependency, Errors errors) throws ErrorsException {
        InternalFactory<T> factory = this.getInternalFactory(dependency.getKey(), errors);
        return new SingleParameterInjector<T>(dependency, factory);
    }

    @Override
    public void injectMembers(Object instance) {
        MembersInjector<?> membersInjector = this.getMembersInjector(instance.getClass());
        membersInjector.injectMembers(instance);
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(TypeLiteral<T> typeLiteral) {
        Errors errors = new Errors(typeLiteral);
        try {
            return this.membersInjectorStore.get(typeLiteral, errors);
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(errors.merge(e.getErrors()).getMessages());
        }
    }

    @Override
    public <T> MembersInjector<T> getMembersInjector(Class<T> type) {
        return this.getMembersInjector(TypeLiteral.get(type));
    }

    @Override
    public <T> Provider<T> getProvider(Class<T> type) {
        return this.getProvider(Key.get(type));
    }

    <T> Provider<T> getProviderOrThrow(Key<T> key, Errors errors) throws ErrorsException {
        final InternalFactory<T> factory = this.getInternalFactory(key, errors);
        final Dependency<T> dependency = Dependency.get(key);
        return new Provider<T>(){

            @Override
            public T get() {
                final Errors errors = new Errors(dependency);
                try {
                    Object t = InjectorImpl.this.callInContext(new ContextualCallable<T>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public T call(InternalContext context) throws ErrorsException {
                            context.setDependency(dependency);
                            try {
                                Object t = factory.get(errors, context, dependency);
                                return t;
                            }
                            finally {
                                context.setDependency(null);
                            }
                        }
                    });
                    errors.throwIfNewErrors(0);
                    return t;
                }
                catch (ErrorsException e) {
                    throw new ProvisionException(errors.merge(e.getErrors()).getMessages());
                }
            }

            public String toString() {
                return factory.toString();
            }
        };
    }

    @Override
    public <T> Provider<T> getProvider(Key<T> key) {
        Errors errors = new Errors(key);
        try {
            Provider<T> result = this.getProviderOrThrow(key, errors);
            errors.throwIfNewErrors(0);
            return result;
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(errors.merge(e.getErrors()).getMessages());
        }
    }

    @Override
    public <T> T getInstance(Key<T> key) {
        return this.getProvider(key).get();
    }

    @Override
    public <T> T getInstance(Class<T> type) {
        return this.getProvider(type).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T callInContext(ContextualCallable<T> callable) throws ErrorsException {
        Object[] reference = this.localContext.get();
        if (reference[0] == null) {
            reference[0] = new InternalContext();
            try {
                T t = callable.call((InternalContext)reference[0]);
                return t;
            }
            finally {
                reference[0] = null;
            }
        }
        return callable.call((InternalContext)reference[0]);
    }

    public String toString() {
        return new ToStringBuilder(Injector.class).add("bindings", this.state.getExplicitBindingsThisLevel().values()).toString();
    }

    static interface MethodInvoker {
        public Object invoke(Object var1, Object ... var2) throws IllegalAccessException, InvocationTargetException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BindingsMultimap {
        final Map<TypeLiteral<?>, List<Binding<?>>> multimap = Maps.newHashMap();

        private BindingsMultimap() {
        }

        <T> void put(TypeLiteral<T> type, Binding<T> binding) {
            List<Binding<?>> bindingsForType = this.multimap.get(type);
            if (bindingsForType == null) {
                bindingsForType = Lists.newArrayList();
                this.multimap.put(type, bindingsForType);
            }
            bindingsForType.add(binding);
        }

        <T> List<Binding<T>> getAll(TypeLiteral<T> type) {
            List<Binding<?>> bindings = this.multimap.get(type);
            return bindings != null ? Collections.unmodifiableList(this.multimap.get(type)) : ImmutableList.of();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConvertedConstantBindingImpl<T>
    extends BindingImpl<T>
    implements ConvertedConstantBinding<T> {
        final T value;
        final Provider<T> provider;
        final Binding<String> originalBinding;

        ConvertedConstantBindingImpl(Injector injector, Key<T> key, T value, Binding<String> originalBinding) {
            super(injector, key, originalBinding.getSource(), new ConstantFactory<T>(Initializables.of(value)), Scoping.UNSCOPED);
            this.value = value;
            this.provider = Providers.of(value);
            this.originalBinding = originalBinding;
        }

        @Override
        public Provider<T> getProvider() {
            return this.provider;
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
            return visitor.visit(this);
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public Key<String> getSourceKey() {
            return this.originalBinding.getKey();
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return ImmutableSet.of(Dependency.get(this.getSourceKey()));
        }

        @Override
        public void applyTo(Binder binder) {
            throw new UnsupportedOperationException("This element represents a synthetic binding.");
        }

        @Override
        public String toString() {
            return new ToStringBuilder(ConvertedConstantBinding.class).add("key", this.getKey()).add("sourceKey", this.getSourceKey()).add("value", this.value).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ProviderBindingImpl<T>
    extends BindingImpl<Provider<T>>
    implements ProviderBinding<Provider<T>> {
        final BindingImpl<T> providedBinding;

        ProviderBindingImpl(InjectorImpl injector, Key<Provider<T>> key, Binding<T> providedBinding) {
            super(injector, key, providedBinding.getSource(), ProviderBindingImpl.createInternalFactory(providedBinding), Scoping.UNSCOPED);
            this.providedBinding = (BindingImpl)providedBinding;
        }

        static <T> InternalFactory<Provider<T>> createInternalFactory(Binding<T> providedBinding) {
            final Provider<T> provider = providedBinding.getProvider();
            return new InternalFactory<Provider<T>>(){

                @Override
                public Provider<T> get(Errors errors, InternalContext context, Dependency dependency) {
                    return provider;
                }
            };
        }

        @Override
        public Key<? extends T> getProvidedKey() {
            return this.providedBinding.getKey();
        }

        @Override
        public <V> V acceptTargetVisitor(BindingTargetVisitor<? super Provider<T>, V> visitor) {
            return visitor.visit(this);
        }

        @Override
        public void applyTo(Binder binder) {
            throw new UnsupportedOperationException("This element represents a synthetic binding.");
        }

        @Override
        public String toString() {
            return new ToStringBuilder(ProviderKeyBinding.class).add("key", this.getKey()).add("providedKey", this.getProvidedKey()).toString();
        }
    }
}

