/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import net.sourceforge.cobertura.instrument.FirstPassMethodInstrumenter;
import net.sourceforge.cobertura.instrument.JumpHolder;
import net.sourceforge.cobertura.instrument.NewLocalVariableMethodAdapter;
import net.sourceforge.cobertura.instrument.SwitchHolder;
import net.sourceforge.cobertura.util.RegexUtil;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;

public class SecondPassMethodInstrumenter
extends NewLocalVariableMethodAdapter
implements Opcodes {
    private String TOUCH_COLLECTOR_CLASS = "net/sourceforge/cobertura/coveragedata/TouchCollector";
    private int currentLine;
    private int currentJump;
    private boolean methodStarted;
    private int myVariableIndex;
    private Label startLabel;
    private Label endLabel;
    private JumpHolder lastJump;
    private FirstPassMethodInstrumenter firstPass;
    private static final int BOOLEAN_TRUE = 3;
    private static final int BOOLEAN_FALSE = 4;

    public SecondPassMethodInstrumenter(FirstPassMethodInstrumenter firstPass) {
        super(firstPass.getWriterMethodVisitor(), firstPass.getMyAccess(), firstPass.getMyDescriptor(), 2);
        this.firstPass = firstPass;
        this.currentLine = 0;
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.touchBranchFalse();
        if (opcode != 167 && opcode != 168 && this.currentLine != 0 && !this.firstPass.getMyName().equals("<clinit>")) {
            this.lastJump = new JumpHolder(this.currentLine, this.currentJump++);
            this.mv.visitIntInsn(17, this.currentLine);
            this.mv.visitVarInsn(54, this.myVariableIndex);
            this.mv.visitIntInsn(17, this.lastJump.getJumpNumber());
            this.mv.visitVarInsn(54, this.myVariableIndex + 1);
        }
        super.visitJumpInsn(opcode, label);
    }

    public void visitLineNumber(int line, Label start) {
        this.currentLine = line;
        this.currentJump = 0;
        this.instrumentOwnerClass();
        this.mv.visitIntInsn(17, line);
        this.mv.visitMethodInsn(184, this.TOUCH_COLLECTOR_CLASS, "touch", "(Ljava/lang/String;I)V");
        super.visitLineNumber(line, start);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.touchBranchFalse();
        super.visitMethodInsn(opcode, owner, name, desc);
        if (RegexUtil.matches(this.firstPass.getIgnoreRegexs(), owner)) {
            this.firstPass.removeLine(this.currentLine);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.touchBranchFalse();
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitIincInsn(int var, int increment) {
        this.touchBranchFalse();
        super.visitIincInsn(var, increment);
    }

    public void visitInsn(int opcode) {
        this.touchBranchFalse();
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        this.touchBranchFalse();
        super.visitIntInsn(opcode, operand);
    }

    public void visitLabel(Label label) {
        Integer line;
        Label newLabelX;
        if (this.methodStarted) {
            this.methodStarted = false;
            this.myVariableIndex = this.getFirstStackVariable();
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(54, this.myVariableIndex);
            this.mv.visitIntInsn(17, -1);
            this.mv.visitVarInsn(54, this.myVariableIndex + 1);
            this.startLabel = label;
        }
        this.endLabel = label;
        super.visitLabel(label);
        if (this.firstPass.getJumpTargetLabels().keySet().contains(label)) {
            if (this.lastJump != null) {
                newLabelX = this.instrumentIsLastJump();
                this.instrumentOwnerClass();
                this.instrumentPutLineAndBranchNumbers();
                this.mv.visitInsn(4);
                this.instrumentInvokeTouchJump();
                Label newLabelY = new Label();
                this.mv.visitJumpInsn(167, newLabelY);
                this.mv.visitLabel(newLabelX);
                this.mv.visitVarInsn(21, this.myVariableIndex + 1);
                this.mv.visitJumpInsn(155, newLabelY);
                this.instrumentOwnerClass();
                this.instrumentPutLineAndBranchNumbers();
                this.mv.visitInsn(3);
                this.instrumentInvokeTouchJump();
                this.mv.visitLabel(newLabelY);
            } else {
                this.mv.visitVarInsn(21, this.myVariableIndex + 1);
                newLabelX = new Label();
                this.mv.visitJumpInsn(155, newLabelX);
                this.instrumentJumpHit(true);
                this.mv.visitLabel(newLabelX);
            }
        } else if (this.lastJump != null) {
            newLabelX = this.instrumentIsLastJump();
            this.instrumentJumpHit(false);
            this.mv.visitLabel(newLabelX);
        }
        this.lastJump = null;
        SwitchHolder sh = (SwitchHolder)this.firstPass.getSwitchTargetLabels().get(label);
        if (sh != null) {
            this.instrumentSwitchHit(sh.getLineNumber(), sh.getSwitchNumber(), sh.getBranch());
        }
        if ((line = (Integer)this.firstPass.getLineLabels().get(label)) != null) {
            this.visitLineNumber(line, label);
        }
    }

    public void visitLdcInsn(Object cst) {
        this.touchBranchFalse();
        super.visitLdcInsn(cst);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.touchBranchFalse();
        super.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.touchBranchFalse();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.touchBranchFalse();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.touchBranchFalse();
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitTypeInsn(int opcode, String desc) {
        this.touchBranchFalse();
        super.visitTypeInsn(opcode, desc);
    }

    public void visitVarInsn(int opcode, int var) {
        this.touchBranchFalse();
        super.visitVarInsn(opcode, var);
    }

    public void visitCode() {
        this.methodStarted = true;
        super.visitCode();
    }

    private void touchBranchFalse() {
        if (this.lastJump != null) {
            this.lastJump = null;
            this.instrumentJumpHit(false);
        }
    }

    private void instrumentOwnerClass() {
        this.mv.visitLdcInsn((Object)this.firstPass.getOwnerClass());
    }

    private void instrumentSwitchHit(int lineNumber, int switchNumber, int branch) {
        this.instrumentOwnerClass();
        this.mv.visitIntInsn(17, lineNumber);
        this.mv.visitIntInsn(17, switchNumber);
        this.mv.visitIntInsn(17, branch);
        this.instrumentInvokeTouchSwitch();
    }

    private void instrumentJumpHit(boolean branch) {
        this.instrumentOwnerClass();
        this.instrumentPutLineAndBranchNumbers();
        this.mv.visitInsn(branch ? 3 : 4);
        this.instrumentInvokeTouchJump();
    }

    private void instrumentInvokeTouchJump() {
        this.mv.visitMethodInsn(184, this.TOUCH_COLLECTOR_CLASS, "touchJump", "(Ljava/lang/String;IIZ)V");
        this.mv.visitIntInsn(17, -1);
        this.mv.visitVarInsn(54, this.myVariableIndex + 1);
    }

    private void instrumentInvokeTouchSwitch() {
        this.mv.visitMethodInsn(184, this.TOUCH_COLLECTOR_CLASS, "touchSwitch", "(Ljava/lang/String;III)V");
    }

    private void instrumentPutLineAndBranchNumbers() {
        this.mv.visitVarInsn(21, this.myVariableIndex);
        this.mv.visitVarInsn(21, this.myVariableIndex + 1);
    }

    private Label instrumentIsLastJump() {
        this.mv.visitVarInsn(21, this.myVariableIndex);
        this.mv.visitIntInsn(17, this.lastJump.getLineNumber());
        Label newLabelX = new Label();
        this.mv.visitJumpInsn(160, newLabelX);
        this.mv.visitVarInsn(21, this.myVariableIndex + 1);
        this.mv.visitIntInsn(17, this.lastJump.getJumpNumber());
        this.mv.visitJumpInsn(160, newLabelX);
        return newLabelX;
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        this.mv.visitLocalVariable("__cobertura__line__number__", "I", null, this.startLabel, this.endLabel, this.myVariableIndex);
        this.mv.visitLocalVariable("__cobertura__branch__number__", "I", null, this.startLabel, this.endLabel, this.myVariableIndex + 1);
        super.visitMaxs(maxStack, maxLocals);
    }
}

