/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import com.google.clearsilver.jsilver.compiler.JavaExpression;
import java.io.Closeable;
import java.io.Flushable;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JavaSourceWriter
implements Closeable,
Flushable {
    private final PrintWriter out;
    private int indent;

    public JavaSourceWriter(Writer out) {
        this.out = new PrintWriter(out);
    }

    public void writePackage(String packageName) {
        if (packageName != null) {
            this.startLine();
            this.out.append("package ").append(packageName).append(';');
            this.endLine();
            this.emptyLine();
        }
    }

    public void writeImports(Class ... javaClasses) {
        for (Class javaClass : javaClasses) {
            this.startLine();
            this.out.append("import ").append(javaClass.getName()).append(';');
            this.endLine();
        }
        if (javaClasses.length > 0) {
            this.emptyLine();
        }
    }

    public void writeComment(String comment) {
        this.startLine();
        this.out.append("// ").append(comment);
        this.endLine();
    }

    public void startClass(String className, String baseClassName, String ... interfaceNames) {
        this.startLine();
        this.out.append("public class ");
        JavaSourceWriter.writeJavaSymbol(this.out, className);
        if (baseClassName != null) {
            this.out.append(" extends ");
            JavaSourceWriter.writeJavaSymbol(this.out, baseClassName);
        }
        boolean seenAnyInterfaces = false;
        for (String interfaceName : interfaceNames) {
            if (!seenAnyInterfaces) {
                seenAnyInterfaces = true;
                this.out.append(" implements ");
            } else {
                this.out.append(", ");
            }
            JavaSourceWriter.writeJavaSymbol(this.out, interfaceName);
        }
        this.out.append(' ');
        this.startBlock();
        this.emptyLine();
    }

    public void startAnonymousClass(String baseClass, JavaExpression ... constructorArgs) {
        this.out.append("new ");
        JavaSourceWriter.writeJavaSymbol(this.out, baseClass);
        this.out.append('(');
        boolean seenAnyArgs = false;
        for (JavaExpression constructorArg : constructorArgs) {
            if (seenAnyArgs) {
                this.out.append(", ");
            }
            seenAnyArgs = true;
            constructorArg.write(this.out);
        }
        this.out.append(") ");
        this.startBlock();
        this.emptyLine();
    }

    public void endAnonymousClass() {
        this.endBlock();
    }

    public void startMethod(Method method, String ... paramNames) {
        if (paramNames.length != method.getParameterTypes().length) {
            throw new IllegalArgumentException("Did not specifiy correct number of parameter names for method signature " + method);
        }
        this.startLine();
        int modifiers = method.getModifiers();
        if (Modifier.isAbstract(modifiers)) {
            this.out.append("@Override");
            this.endLine();
            this.startLine();
        }
        if (modifiers != 0) {
            this.out.append(Modifier.toString(modifiers &= 0xD)).append(' ');
        }
        this.out.append(method.getReturnType().getSimpleName()).append(' ').append(method.getName()).append('(');
        int paramIndex = 0;
        for (Class<?> paramType : method.getParameterTypes()) {
            if (paramIndex > 0) {
                this.out.append(", ");
            }
            JavaSourceWriter.writeJavaSymbol(this.out, paramType.getSimpleName());
            this.out.append(' ');
            JavaSourceWriter.writeJavaSymbol(this.out, paramNames[paramIndex]);
            ++paramIndex;
        }
        this.out.append(')');
        boolean seenAnyExceptions = false;
        for (Class<?> exception : method.getExceptionTypes()) {
            if (!seenAnyExceptions) {
                seenAnyExceptions = true;
                this.endLine();
                this.startLine();
                this.out.append("    throws ");
            } else {
                this.out.append(", ");
            }
            JavaSourceWriter.writeJavaSymbol(this.out, exception.getSimpleName());
        }
        this.out.append(' ');
        this.startBlock();
    }

    public void startIfBlock(JavaExpression expression) {
        this.startLine();
        this.out.append("if (");
        this.writeExpression(expression);
        this.out.append(") ");
        this.startBlock();
    }

    public void endIfStartElseBlock() {
        this.endBlock();
        this.out.append(" else ");
        this.startBlock();
    }

    public void endIfBlock() {
        this.endBlock();
        this.endLine();
    }

    public void startScopedBlock() {
        this.startLine();
        this.startBlock();
    }

    public void endScopedBlock() {
        this.endBlock();
        this.endLine();
    }

    public void startIterableForLoop(String type, String name, JavaExpression expression) {
        this.startLine();
        this.out.append("for (");
        JavaSourceWriter.writeJavaSymbol(this.out, type);
        this.out.append(' ');
        JavaSourceWriter.writeJavaSymbol(this.out, name);
        this.out.append(" : ");
        this.writeExpression(expression);
        this.out.append(") ");
        this.startBlock();
    }

    public void startForLoop(JavaExpression start, JavaExpression end, JavaExpression increment) {
        this.startLine();
        this.out.append("for (");
        this.writeExpression(start);
        this.out.append("; ");
        this.writeExpression(end);
        this.out.append("; ");
        this.writeExpression(increment);
        this.out.append(") ");
        this.startBlock();
    }

    public void endLoop() {
        this.endBlock();
        this.endLine();
    }

    public void writeStatement(JavaExpression expression) {
        this.startLine();
        this.writeExpression(expression);
        this.out.append(';');
        this.endLine();
    }

    public void writeExpression(JavaExpression expression) {
        expression.write(this.out);
    }

    public void endMethod() {
        this.endBlock();
        this.endLine();
        this.emptyLine();
    }

    public void endClass() {
        this.endBlock();
        this.endLine();
        this.emptyLine();
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    private void startBlock() {
        this.out.append('{');
        this.endLine();
        ++this.indent;
    }

    private void endBlock() {
        --this.indent;
        this.startLine();
        this.out.append('}');
    }

    private void startLine() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.append("  ");
        }
    }

    private void endLine() {
        this.out.append('\n');
    }

    private void emptyLine() {
        this.out.append('\n');
    }

    public static void writeJavaSymbol(PrintWriter out, String symbol) {
        out.append(symbol);
    }

    public void startField(String type, JavaExpression name) {
        this.startLine();
        this.out.append("private final ");
        JavaSourceWriter.writeJavaSymbol(this.out, type);
        this.out.append(' ');
        name.write(this.out);
        this.out.append(" = ");
    }

    public void endField() {
        this.out.append(';');
        this.endLine();
        this.emptyLine();
    }
}

