/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilingClassLoader
extends ClassLoader {
    private Map<String, ByteArrayOutputStream> byteCodeForClasses = new HashMap<String, ByteArrayOutputStream>();
    private static final URI EMPTY_URI;

    public CompilingClassLoader(ClassLoader parent, String className, CharSequence sourceCode, DiagnosticListener<JavaFileObject> diagnosticListener) throws CompilerException {
        super(parent);
        if (!this.compileSourceCodeToByteCode(className, sourceCode, diagnosticListener)) {
            throw new CompilerException("Could not compile " + className);
        }
    }

    public Class findClass(String name) throws ClassNotFoundException {
        ByteArrayOutputStream byteCode = this.byteCodeForClasses.get(name);
        if (byteCode == null) {
            throw new ClassNotFoundException(name);
        }
        return this.defineClass(name, byteCode.toByteArray(), 0, byteCode.size());
    }

    private boolean compileSourceCodeToByteCode(String className, CharSequence sourceCode, DiagnosticListener<JavaFileObject> diagnosticListener) {
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        InMemoryFileManager fileManager = new InMemoryFileManager(javaCompiler.getStandardFileManager(null, null, null));
        InMemoryJavaFile javaFile = new InMemoryJavaFile(className, sourceCode);
        System.setProperty("useJavaUtilZip", "true");
        LinkedList<String> options = new LinkedList<String>();
        options.add("-XDuseJavaUtilZip");
        JavaCompiler.CompilationTask compilationTask = javaCompiler.getTask(null, fileManager, diagnosticListener, options, null, Collections.singleton(javaFile));
        return compilationTask.call();
    }

    static {
        try {
            EMPTY_URI = new URI("");
        }
        catch (URISyntaxException e) {
            throw new Error(e);
        }
    }

    private static class InMemoryJavaFile
    extends SimpleJavaFileObject {
        private final CharSequence sourceCode;

        public InMemoryJavaFile(String className, CharSequence sourceCode) {
            super(InMemoryJavaFile.makeUri(className), JavaFileObject.Kind.SOURCE);
            this.sourceCode = sourceCode;
        }

        private static URI makeUri(String className) {
            try {
                return new URI(className.replaceAll("\\.", "/") + JavaFileObject.Kind.SOURCE.extension);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return this.sourceCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InMemoryFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        public InMemoryFileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, final String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            return new SimpleJavaFileObject(EMPTY_URI, kind){

                public OutputStream openOutputStream() throws IOException {
                    ByteArrayOutputStream outputStream = (ByteArrayOutputStream)CompilingClassLoader.this.byteCodeForClasses.get(className);
                    if (outputStream != null) {
                        throw new IllegalStateException("Cannot write more than once");
                    }
                    outputStream = new ByteArrayOutputStream(256);
                    CompilingClassLoader.this.byteCodeForClasses.put(className, outputStream);
                    return outputStream;
                }
            };
        }
    }

    public static class CompilerException
    extends Exception {
        public CompilerException(String message) {
            super(message);
        }
    }
}

