/*
 * Decompiled with CFR 0.152.
 */
package org.testng.guice.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.testng.guice.AbstractModule;
import org.testng.guice.Binder;
import org.testng.guice.Binding;
import org.testng.guice.Key;
import org.testng.guice.Module;
import org.testng.guice.PrivateBinder;
import org.testng.guice.Scope;
import org.testng.guice.internal.ImmutableSet;
import org.testng.guice.internal.Lists;
import org.testng.guice.internal.Maps;
import org.testng.guice.internal.Sets;
import org.testng.guice.spi.DefaultBindingScopingVisitor;
import org.testng.guice.spi.DefaultElementVisitor;
import org.testng.guice.spi.Element;
import org.testng.guice.spi.Elements;
import org.testng.guice.spi.PrivateElements;
import org.testng.guice.spi.ScopeBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Modules {
    public static final Module EMPTY_MODULE = new Module(){

        public void configure(Binder binder) {
        }
    };

    private Modules() {
    }

    public static OverriddenModuleBuilder override(Module ... modules) {
        return new RealOverriddenModuleBuilder(Arrays.asList(modules));
    }

    public static OverriddenModuleBuilder override(Iterable<? extends Module> modules) {
        return new RealOverriddenModuleBuilder(modules);
    }

    public static Module combine(Module ... modules) {
        return Modules.combine(ImmutableSet.of(modules));
    }

    public static Module combine(Iterable<? extends Module> modules) {
        final ImmutableSet<? extends Module> modulesSet = ImmutableSet.copyOf(modules);
        return new Module(){

            public void configure(Binder binder) {
                binder = binder.skipSources(this.getClass());
                for (Module module : modulesSet) {
                    binder.install(module);
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModuleWriter
    extends DefaultElementVisitor<Void> {
        protected final Binder binder;

        ModuleWriter(Binder binder) {
            this.binder = binder;
        }

        @Override
        protected Void visitOther(Element element) {
            element.applyTo(this.binder);
            return null;
        }

        void writeAll(Iterable<? extends Element> elements) {
            for (Element element : elements) {
                element.acceptVisitor(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RealOverriddenModuleBuilder
    implements OverriddenModuleBuilder {
        private final ImmutableSet<Module> baseModules;

        private RealOverriddenModuleBuilder(Iterable<? extends Module> baseModules) {
            this.baseModules = ImmutableSet.copyOf(baseModules);
        }

        @Override
        public Module with(Module ... overrides) {
            return this.with(Arrays.asList(overrides));
        }

        @Override
        public Module with(final Iterable<? extends Module> overrides) {
            return new AbstractModule(){

                @Override
                public void configure() {
                    List<Element> elements = Elements.getElements(RealOverriddenModuleBuilder.this.baseModules);
                    List<Element> overrideElements = Elements.getElements(overrides);
                    final HashSet overriddenKeys = Sets.newHashSet();
                    final HashSet overridesScopeAnnotations = Sets.newHashSet();
                    new ModuleWriter(this.binder()){

                        @Override
                        public <T> Void visit(Binding<T> binding) {
                            overriddenKeys.add(binding.getKey());
                            return (Void)super.visit(binding);
                        }

                        @Override
                        public Void visit(ScopeBinding scopeBinding) {
                            overridesScopeAnnotations.add(scopeBinding.getAnnotationType());
                            return (Void)super.visit(scopeBinding);
                        }

                        @Override
                        public Void visit(PrivateElements privateElements) {
                            overriddenKeys.addAll(privateElements.getExposedKeys());
                            return (Void)super.visit(privateElements);
                        }
                    }.writeAll(overrideElements);
                    final HashMap scopeInstancesInUse = Maps.newHashMap();
                    final ArrayList scopeBindings = Lists.newArrayList();
                    new ModuleWriter(this.binder()){

                        @Override
                        public <T> Void visit(Binding<T> binding) {
                            if (!overriddenKeys.remove(binding.getKey())) {
                                super.visit(binding);
                                Scope scope = this.getScopeInstanceOrNull(binding);
                                if (scope != null) {
                                    scopeInstancesInUse.put(scope, binding.getSource());
                                }
                            }
                            return null;
                        }

                        @Override
                        public Void visit(PrivateElements privateElements) {
                            PrivateBinder privateBinder = this.binder.withSource(privateElements.getSource()).newPrivateBinder();
                            HashSet<Key<?>> skippedExposes = Sets.newHashSet();
                            for (Key<?> key : privateElements.getExposedKeys()) {
                                if (overriddenKeys.remove(key)) {
                                    skippedExposes.add(key);
                                    continue;
                                }
                                privateBinder.withSource(privateElements.getExposedSource(key)).expose(key);
                            }
                            for (Element element : privateElements.getElements()) {
                                if (element instanceof Binding && skippedExposes.contains(((Binding)element).getKey())) continue;
                                element.applyTo(privateBinder);
                            }
                            return null;
                        }

                        @Override
                        public Void visit(ScopeBinding scopeBinding) {
                            scopeBindings.add(scopeBinding);
                            return null;
                        }
                    }.writeAll(elements);
                    new ModuleWriter(this.binder()){

                        public Void visit(ScopeBinding scopeBinding) {
                            if (!overridesScopeAnnotations.remove(scopeBinding.getAnnotationType())) {
                                super.visit(scopeBinding);
                            } else {
                                Object source = scopeInstancesInUse.get(scopeBinding.getScope());
                                if (source != null) {
                                    this.binder().withSource(source).addError("The scope for @%s is bound directly and cannot be overridden.", scopeBinding.getAnnotationType().getSimpleName());
                                }
                            }
                            return null;
                        }
                    }.writeAll(scopeBindings);
                }

                private Scope getScopeInstanceOrNull(Binding<?> binding) {
                    return binding.acceptScopingVisitor(new DefaultBindingScopingVisitor<Scope>(){

                        @Override
                        public Scope visitScope(Scope scope) {
                            return scope;
                        }
                    });
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface OverriddenModuleBuilder {
        public Module with(Module ... var1);

        public Module with(Iterable<? extends Module> var1);
    }
}

