/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TypeInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterInfo {
    private String mName;
    private String mTypeName;
    private TypeInfo mType;
    private SourcePositionInfo mPosition;

    public ParameterInfo(String name, String typeName, TypeInfo type, SourcePositionInfo position) {
        this.mName = name;
        this.mTypeName = typeName;
        this.mType = type;
        this.mPosition = position;
    }

    TypeInfo type() {
        return this.mType;
    }

    String name() {
        return this.mName;
    }

    String typeName() {
        return this.mTypeName;
    }

    SourcePositionInfo position() {
        return this.mPosition;
    }

    public void makeHDF(Data data, String base, boolean isLastVararg, HashSet<String> typeVariables) {
        data.setValue(base + ".name", this.name());
        this.type().makeHDF(data, base + ".type", isLastVararg, typeVariables);
    }

    public static void makeHDF(Data data, String base, List<ParameterInfo> params, boolean isVararg, HashSet<String> typeVariables) {
        int i = 0;
        Iterator<ParameterInfo> p = params.iterator();
        while (p.hasNext()) {
            ParameterInfo parameterInfo = p.next();
            parameterInfo.makeHDF(data, base + "." + i, isVararg && !p.hasNext(), typeVariables);
            ++i;
        }
    }

    public boolean matchesDimension(String dimension, boolean varargs) {
        if (varargs) {
            dimension = dimension + "[]";
        }
        return this.mType.dimension().equals(dimension);
    }

    public String toString() {
        return this.mTypeName;
    }
}

