/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.data.Data;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.doclava.AnnotationInstanceInfo;
import com.google.doclava.AnnotationValueInfo;
import com.google.doclava.AttrTagInfo;
import com.google.doclava.ClassInfo;
import com.google.doclava.Errors;
import com.google.doclava.InheritedTags;
import com.google.doclava.MemberInfo;
import com.google.doclava.ParamTagInfo;
import com.google.doclava.ParameterInfo;
import com.google.doclava.ParsedTagInfo;
import com.google.doclava.Project;
import com.google.doclava.SeeTagInfo;
import com.google.doclava.SinceTagger;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import com.google.doclava.ThrowsTagInfo;
import com.google.doclava.TypeInfo;
import com.google.doclava.apicheck.AbstractMethodInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodInfo
extends MemberInfo
implements AbstractMethodInfo,
Cloneable {
    public static final Ordering<MethodInfo> ORDER_BY_NAME_AND_SIGNATURE = new Ordering<MethodInfo>(){

        @Override
        public int compare(MethodInfo a, MethodInfo b) {
            int result = a.name().compareTo(b.name());
            if (result != 0) {
                return result;
            }
            return a.signature().compareTo(b.signature());
        }
    };
    private String mFlatSignature;
    private MethodInfo mOverriddenMethod;
    private TypeInfo mReturnType;
    private boolean mIsAbstract;
    private boolean mIsSynchronized;
    private boolean mIsNative;
    private boolean mIsVarargs;
    private boolean mDeprecatedKnown;
    private boolean mIsDeprecated;
    private List<ParameterInfo> mParameters;
    private List<ClassInfo> mThrownExceptions;
    private List<ThrowsTagInfo> mThrowsTags;
    private ParamTagInfo[] mParamTags;
    private List<TypeInfo> mTypeParameters;
    private AnnotationValueInfo mDefaultAnnotationElementValue;

    private static void addInterfaces(List<ClassInfo> ifaces, List<ClassInfo> queue) {
        for (ClassInfo i : ifaces) {
            queue.add(i);
        }
        for (ClassInfo i : ifaces) {
            MethodInfo.addInterfaces(i.realInterfaces(), queue);
        }
    }

    public MethodInfo findOverriddenMethod(String name, String signature) {
        if (this.mReturnType == null) {
            return null;
        }
        if (this.mOverriddenMethod != null) {
            return this.mOverriddenMethod;
        }
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>();
        MethodInfo.addInterfaces(this.containingClass().realInterfaces(), queue);
        for (ClassInfo ifc : queue) {
            for (MethodInfo methodInfo : ifc.allSelfMethods()) {
                if (!methodInfo.name().equals(name) || !methodInfo.signature().equals(signature) || methodInfo.inlineTags().tags() == null || methodInfo.inlineTags().tags().isEmpty()) continue;
                return methodInfo;
            }
        }
        return null;
    }

    public MethodInfo findRealOverriddenMethod(MethodInfo other, Set<ClassInfo> notStrippable) {
        String name = other.name();
        String signature = other.signature();
        if (this.mReturnType == null) {
            return null;
        }
        if (this.mOverriddenMethod != null) {
            return this.mOverriddenMethod;
        }
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>();
        if (this.containingClass().realSuperclass() != null && this.containingClass().realSuperclass().isAbstract()) {
            queue.add(this.containingClass());
        }
        MethodInfo.addInterfaces(this.containingClass().realInterfaces(), queue);
        for (ClassInfo iface : queue) {
            for (MethodInfo me : iface.getMethods()) {
                if (!me.name().equals(name) || !me.signature().equals(signature) || me.inlineTags().tags() == null || me.inlineTags().tags().isEmpty() || !notStrippable.contains(me.containingClass())) continue;
                return me;
            }
        }
        return null;
    }

    public MethodInfo findSuperclassImplementation(Set<ClassInfo> notStrippable) {
        if (this.mReturnType == null) {
            return null;
        }
        if (this.mOverriddenMethod != null && this.signature().equals(this.mOverriddenMethod.signature())) {
            return this.mOverriddenMethod;
        }
        ArrayList<ClassInfo> queue = new ArrayList<ClassInfo>();
        if (this.containingClass().realSuperclass() != null && this.containingClass().realSuperclass().isAbstract()) {
            queue.add(this.containingClass());
        }
        MethodInfo.addInterfaces(this.containingClass().realInterfaces(), queue);
        for (ClassInfo iface : queue) {
            for (MethodInfo me : iface.getMethods()) {
                if (!me.name().equals(this.name()) || !me.signature().equals(this.signature()) || !notStrippable.contains(me.containingClass())) continue;
                return me;
            }
        }
        return null;
    }

    public boolean isDeprecated() {
        if (!this.mDeprecatedKnown) {
            boolean commentDeprecated = this.comment().isDeprecated();
            boolean annotationDeprecated = false;
            for (AnnotationInstanceInfo annotation : this.annotations()) {
                if (!annotation.type().qualifiedName().equals("java.lang.Deprecated")) continue;
                annotationDeprecated = true;
                break;
            }
            if (commentDeprecated != annotationDeprecated) {
                Errors.error(Errors.DEPRECATION_MISMATCH, this.position(), "Method " + this.mContainingClass.qualifiedName() + "." + this.name() + ": @Deprecated annotation and @deprecated doc tag do not match");
            }
            this.mIsDeprecated = commentDeprecated | annotationDeprecated;
            this.mDeprecatedKnown = true;
        }
        return this.mIsDeprecated;
    }

    @Override
    public void setDeprecated(boolean deprecated) {
        this.mDeprecatedKnown = true;
        this.mIsDeprecated = deprecated;
    }

    public List<TypeInfo> getTypeParameters() {
        return this.mTypeParameters;
    }

    protected MethodInfo clone() {
        try {
            return (MethodInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public MethodInfo cloneForClass(ClassInfo newContainingClass) {
        MethodInfo result = this.clone();
        result.setContainingClass(newContainingClass);
        return result;
    }

    public MethodInfo(String rawCommentText, List<TypeInfo> typeParameters, String name, String signature, ClassInfo containingClass, ClassInfo realContainingClass, boolean isPublic, boolean isProtected, boolean isPackagePrivate, boolean isPrivate, boolean isFinal, boolean isStatic, boolean isSynthetic, boolean isAbstract, boolean isSynchronized, boolean isNative, String kind, String flatSignature, MethodInfo overriddenMethod, TypeInfo returnType, List<ParameterInfo> parameters, List<ClassInfo> thrownExceptions, SourcePositionInfo position, AnnotationInstanceInfo[] annotations) {
        super(rawCommentText, name, signature, containingClass, realContainingClass, isPublic, isProtected, isPackagePrivate, isPrivate, name.equals("values") && containingClass.isEnum() ? true : isFinal, isStatic, isSynthetic, kind, position, annotations);
        if (containingClass.isInterface()) {
            isAbstract = true;
        }
        this.mTypeParameters = typeParameters;
        this.mIsAbstract = isAbstract;
        this.mIsSynchronized = isSynchronized;
        this.mIsNative = isNative;
        this.mFlatSignature = flatSignature;
        this.mOverriddenMethod = overriddenMethod;
        this.mReturnType = returnType;
        this.mParameters = parameters;
        this.mThrownExceptions = thrownExceptions;
    }

    public void init(AnnotationValueInfo defaultAnnotationElementValue) {
        this.mDefaultAnnotationElementValue = defaultAnnotationElementValue;
    }

    @Override
    public void initVisible(Project project) {
        super.initVisible(project);
        ArrayList<ThrowsTagInfo> throwsTags = new ArrayList<ThrowsTagInfo>();
        throwsTags.addAll(this.comment().throwsTags());
        for (ClassInfo classInfo : this.mThrownExceptions) {
            if (this.inList(classInfo, throwsTags)) continue;
            throwsTags.add(new ThrowsTagInfo("@throws", "@throws", classInfo.qualifiedName(), classInfo, "", this.containingClass(), this.position()));
        }
        this.mThrowsTags = ImmutableList.copyOf(throwsTags);
        this.mParamTags = this.computeParamTags();
        for (ParsedTagInfo parsedTagInfo : Iterables.concat(throwsTags, Arrays.asList(this.mParamTags))) {
            ((TagInfo)parsedTagInfo).initVisible(project);
        }
    }

    public ParamTagInfo[] computeParamTags() {
        String[] names = new String[this.mParameters.size()];
        String[] comments = new String[this.mParameters.size()];
        SourcePositionInfo[] positions = new SourcePositionInfo[this.mParameters.size()];
        int i = 0;
        for (ParameterInfo p : this.mParameters) {
            names[i] = p.name();
            comments[i] = "";
            positions[i] = p.position();
            ++i;
        }
        for (ParamTagInfo tag : this.comment().paramTags()) {
            int index = MethodInfo.indexOfParam(tag.parameterName(), names);
            if (index >= 0) {
                comments[index] = tag.parameterComment();
                positions[index] = tag.position();
                continue;
            }
            Errors.error(Errors.UNKNOWN_PARAM_TAG_NAME, tag.position(), "@param tag with name that doesn't match the parameter list: '" + tag.parameterName() + "'");
        }
        MethodInfo overridden = this.findOverriddenMethod(this.name(), this.signature());
        if (overridden != null) {
            ParamTagInfo[] maternal = overridden.computeParamTags();
            for (i = 0; i < this.mParameters.size(); ++i) {
                if (!comments[i].equals("")) continue;
                comments[i] = maternal[i].parameterComment();
                positions[i] = maternal[i].position();
            }
        }
        ParamTagInfo[] result = new ParamTagInfo[this.mParameters.size()];
        for (i = 0; i < this.mParameters.size(); ++i) {
            result[i] = new ParamTagInfo("@param", "@param", names[i] + " " + comments[i], this.parent(), positions[i]);
            if (!comments[i].equals("")) continue;
            Errors.error(Errors.UNDOCUMENTED_PARAMETER, positions[i], "Undocumented parameter '" + names[i] + "' on method '" + this.name() + "'");
        }
        return result;
    }

    public boolean isAbstract() {
        return this.mIsAbstract;
    }

    public boolean isSynchronized() {
        return this.mIsSynchronized;
    }

    public boolean isNative() {
        return this.mIsNative;
    }

    public String flatSignature() {
        return this.mFlatSignature;
    }

    public InheritedTags inlineTags() {
        return new InlineTags();
    }

    public InheritedTags firstSentenceTags() {
        return new FirstSentenceTags();
    }

    public InheritedTags returnTags() {
        return new ReturnTags();
    }

    public TypeInfo returnType() {
        return this.mReturnType;
    }

    public String prettySignature() {
        return this.name() + this.prettyParameters();
    }

    public String prettyParameters() {
        StringBuilder params = new StringBuilder("(");
        for (ParameterInfo pInfo : this.mParameters) {
            if (params.length() > 1) {
                params.append(",");
            }
            params.append(pInfo.type().simpleTypeName());
        }
        params.append(")");
        return params.toString();
    }

    public String getHashableName() {
        StringBuilder result = new StringBuilder();
        result.append(this.name());
        Iterator<ParameterInfo> p = this.mParameters.iterator();
        while (p.hasNext()) {
            ParameterInfo parameterInfo = p.next();
            result.append(":");
            if (!p.hasNext() && this.isVarArgs()) {
                result.append(parameterInfo.type().fullNameNoDimension(this.typeVariables())).append("...");
                continue;
            }
            result.append(parameterInfo.type().fullName(this.typeVariables()));
        }
        return result.toString();
    }

    private boolean inList(ClassInfo item, List<ThrowsTagInfo> list) {
        int len = list.size();
        String qn = item.qualifiedName();
        for (int i = 0; i < len; ++i) {
            ClassInfo ex = list.get(i).exception();
            if (ex == null || !ex.qualifiedName().equals(qn)) continue;
            return true;
        }
        return false;
    }

    public List<ThrowsTagInfo> throwsTags() {
        if (this.mThrowsTags == null) {
            throw new IllegalStateException("Call initVisible() first");
        }
        return this.mThrowsTags;
    }

    private static int indexOfParam(String name, String[] list) {
        int N = list.length;
        for (int i = 0; i < N; ++i) {
            if (!name.equals(list[i])) continue;
            return i;
        }
        return -1;
    }

    public ParamTagInfo[] paramTags() {
        if (this.mParamTags == null) {
            throw new IllegalStateException("Call initVisible() first!");
        }
        return this.mParamTags;
    }

    public List<SeeTagInfo> seeTags() {
        List<SeeTagInfo> result = this.comment().seeTags();
        if (result == null && this.mOverriddenMethod != null) {
            result = this.mOverriddenMethod.seeTags();
        }
        return result;
    }

    public List<TagInfo> deprecatedTags() {
        List<TagInfo> result = this.comment().deprecatedTags();
        if (result.isEmpty() && this.comment().undeprecateTags().isEmpty() && this.mOverriddenMethod != null) {
            result = this.mOverriddenMethod.deprecatedTags();
        }
        return result;
    }

    public List<ParameterInfo> parameters() {
        return this.mParameters;
    }

    public boolean matchesParams(String[] params, String[] dimensions, boolean varargs) {
        List<ParameterInfo> mine = this.mParameters;
        int len = mine.size();
        if (len != params.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (!mine.get(i).matchesDimension(dimensions[i], varargs)) {
                return false;
            }
            TypeInfo myType = mine.get(i).type();
            String qualifiedName = myType.qualifiedTypeName();
            String realType = myType.isPrimitive() ? "" : myType.asClassInfo().qualifiedName();
            String s = params[i];
            if (this.matchesType(qualifiedName, s) || this.matchesType(realType, s)) continue;
            return false;
        }
        return true;
    }

    private boolean matchesType(String signatureParam, String callerParam) {
        int signatureLength = signatureParam.length();
        int callerLength = callerParam.length();
        return signatureParam.equals(callerParam) || callerLength + 1 < signatureLength && signatureParam.charAt(signatureLength - callerLength - 1) == '.' && signatureParam.endsWith(callerParam);
    }

    public void makeHDF(Data data, String base) {
        data.setValue(base + ".kind", this.kind());
        data.setValue(base + ".name", this.name());
        data.setValue(base + ".href", this.htmlPage());
        data.setValue(base + ".anchor", this.anchor());
        if (this.mReturnType != null) {
            this.returnType().makeHDF(data, base + ".returnType", false, this.typeVariables());
            data.setValue(base + ".abstract", this.mIsAbstract ? "abstract" : "");
        }
        data.setValue(base + ".synchronized", this.mIsSynchronized ? "synchronized" : "");
        data.setValue(base + ".final", this.isFinal() ? "final" : "");
        data.setValue(base + ".static", this.isStatic() ? "static" : "");
        TagInfo.makeHDF(data, base + ".shortDescr", this.firstSentenceTags());
        TagInfo.makeHDF(data, base + ".descr", this.inlineTags());
        TagInfo.makeHDF(data, base + ".deprecated", this.deprecatedTags());
        TagInfo.makeHDF(data, base + ".seeAlso", this.seeTags());
        data.setValue(base + ".since.key", SinceTagger.keyForName(this.getSince()));
        data.setValue(base + ".since.name", this.getSince());
        ParamTagInfo.makeHDF(data, base + ".paramTags", this.paramTags());
        AttrTagInfo.makeReferenceHDF(data, base + ".attrRefs", this.comment().attrTags());
        ThrowsTagInfo.makeHDF(data, base + ".throws", this.throwsTags());
        ParameterInfo.makeHDF(data, base + ".params", this.parameters(), this.isVarArgs(), this.typeVariables());
        if (this.isProtected()) {
            data.setValue(base + ".scope", "protected");
        } else if (this.isPublic()) {
            data.setValue(base + ".scope", "public");
        }
        TagInfo.makeHDF(data, base + ".returns", this.returnTags());
        if (this.mTypeParameters != null) {
            TypeInfo.makeHDF(data, base + ".generic.typeArguments", this.mTypeParameters, false);
        }
        this.setFederatedReferences(data, base);
    }

    public HashSet<String> typeVariables() {
        HashSet<String> result = TypeInfo.typeVariables(this.mTypeParameters);
        for (ClassInfo cl = this.containingClass(); cl != null; cl = cl.containingClass()) {
            List<TypeInfo> types = cl.asTypeInfo().typeArguments();
            if (types == null) continue;
            TypeInfo.typeVariables(types, result);
        }
        return result;
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    public List<ClassInfo> thrownExceptions() {
        return this.mThrownExceptions;
    }

    public String typeArgumentsName(HashSet<String> typeVars) {
        if (this.mTypeParameters == null || this.mTypeParameters.isEmpty()) {
            return "";
        }
        return TypeInfo.typeArgumentsName(this.mTypeParameters, typeVars);
    }

    public AnnotationValueInfo defaultAnnotationElementValue() {
        return this.mDefaultAnnotationElementValue;
    }

    @Override
    public void setVarargs(boolean set) {
        this.mIsVarargs = set;
    }

    @Override
    public boolean isVarArgs() {
        return this.mIsVarargs;
    }

    public String toString() {
        return this.name();
    }

    @Override
    public void addException(String exec) {
        this.mThrownExceptions.add(new ClassInfo(exec));
    }

    @Override
    public void addParameter(ParameterInfo p) {
        this.mParameters.add(p);
        this.mTypeParameters.add(p.type());
    }

    public String qualifiedName() {
        String parentQName = this.containingClass() != null ? this.containingClass().qualifiedName() + "." : "";
        return parentQName + this.name();
    }

    @Override
    public String signature() {
        if (this.mSignature == null) {
            StringBuilder params = new StringBuilder("(");
            for (ParameterInfo pInfo : this.mParameters) {
                if (params.length() > 1) {
                    params.append(", ");
                }
                params.append(pInfo.type().fullName());
            }
            params.append(")");
            this.mSignature = params.toString();
        }
        return this.mSignature;
    }

    public boolean matches(MethodInfo other) {
        return this.prettySignature().equals(other.prettySignature());
    }

    public boolean throwsException(ClassInfo exception) {
        for (ClassInfo e : this.mThrownExceptions) {
            if (!e.qualifiedName().equals(exception.qualifiedName())) continue;
            return true;
        }
        return false;
    }

    public boolean isConsistent(MethodInfo mInfo) {
        boolean consistent = true;
        if (!this.mReturnType.equals(mInfo.mReturnType)) {
            consistent = false;
            Errors.error(Errors.CHANGED_TYPE, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed return type from " + this.mReturnType + " to " + mInfo.mReturnType);
        }
        if (this.mIsAbstract != mInfo.mIsAbstract) {
            consistent = false;
            Errors.error(Errors.CHANGED_ABSTRACT, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'abstract' qualifier");
        }
        if (this.mIsNative != mInfo.mIsNative) {
            consistent = false;
            Errors.error(Errors.CHANGED_NATIVE, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'native' qualifier");
        }
        if (!(this.mIsFinal == mInfo.mIsFinal || this.mIsStatic || this.containingClass() != null && this.containingClass().isFinal())) {
            consistent = false;
            Errors.error(Errors.CHANGED_FINAL, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'final' qualifier");
        }
        if (this.mIsStatic != mInfo.mIsStatic) {
            consistent = false;
            Errors.error(Errors.CHANGED_STATIC, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'static' qualifier");
        }
        if (!this.scope().equals(mInfo.scope())) {
            consistent = false;
            Errors.error(Errors.CHANGED_SCOPE, mInfo.position(), "Method " + mInfo.qualifiedName() + " changed scope from " + this.scope() + " to " + mInfo.scope());
        }
        if (!this.isDeprecated() == mInfo.isDeprecated()) {
            Errors.error(Errors.CHANGED_DEPRECATED, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed deprecation state");
            consistent = false;
        }
        if (this.mIsSynchronized != mInfo.mIsSynchronized) {
            Errors.error(Errors.CHANGED_SYNCHRONIZED, mInfo.position(), "Method " + mInfo.qualifiedName() + " has changed 'synchronized' qualifier from " + this.mIsSynchronized + " to " + mInfo.mIsSynchronized);
            consistent = false;
        }
        for (ClassInfo exception : this.thrownExceptions()) {
            if (mInfo.throwsException(exception) || this.name().equals("finalize") && this.mParameters.isEmpty()) continue;
            Errors.error(Errors.CHANGED_THROWS, mInfo.position(), "Method " + mInfo.qualifiedName() + " no longer throws exception " + exception.qualifiedName());
            consistent = false;
        }
        for (ClassInfo exec : mInfo.thrownExceptions()) {
            if (this.throwsException(exec) || this.name().equals("finalize") && this.mParameters.isEmpty()) continue;
            Errors.error(Errors.CHANGED_THROWS, mInfo.position(), "Method " + mInfo.qualifiedName() + " added thrown exception " + exec.qualifiedName());
            consistent = false;
        }
        return consistent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReturnTags
    implements InheritedTags {
        private ReturnTags() {
        }

        @Override
        public List<TagInfo> tags() {
            return MethodInfo.this.comment().returnTags();
        }

        @Override
        public InheritedTags inherited() {
            MethodInfo m = MethodInfo.this.findOverriddenMethod(MethodInfo.this.name(), MethodInfo.this.signature());
            if (m != null) {
                return m.returnTags();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FirstSentenceTags
    implements InheritedTags {
        private FirstSentenceTags() {
        }

        @Override
        public List<TagInfo> tags() {
            return MethodInfo.this.comment().briefTags();
        }

        @Override
        public InheritedTags inherited() {
            MethodInfo m = MethodInfo.this.findOverriddenMethod(MethodInfo.this.name(), MethodInfo.this.signature());
            if (m != null) {
                return m.firstSentenceTags();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InlineTags
    implements InheritedTags {
        private InlineTags() {
        }

        @Override
        public List<TagInfo> tags() {
            return MethodInfo.this.comment().tags();
        }

        @Override
        public InheritedTags inherited() {
            MethodInfo m = MethodInfo.this.findOverriddenMethod(MethodInfo.this.name(), MethodInfo.this.signature());
            if (m != null) {
                return m.inlineTags();
            }
            return null;
        }
    }
}

