/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.common.collect.ImmutableList;
import com.google.doclava.AnnotationInstanceInfo;
import com.google.doclava.AnnotationValueInfo;
import com.google.doclava.ClassInfo;
import com.google.doclava.ClearPage;
import com.google.doclava.Errors;
import com.google.doclava.FieldInfo;
import com.google.doclava.MethodInfo;
import com.google.doclava.PackageInfo;
import com.google.doclava.ParameterInfo;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TypeInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Stubs {
    private Set<ClassInfo> notStrippable;

    public void initVisible(HashSet<String> stubPackages, Iterable<ClassInfo> allClasses) {
        this.notStrippable = new LinkedHashSet<ClassInfo>();
        for (ClassInfo cl : allClasses) {
            if (!cl.checkLevel() || !cl.isDefinedLocally()) continue;
            this.cantStripThis(cl, this.notStrippable);
        }
        for (ClassInfo cl : this.notStrippable) {
            if (!cl.isHidden()) {
                ClassInfo returnClass;
                for (MethodInfo m : cl.allSelfMethods()) {
                    if (m.isHidden()) continue;
                    if (m.isDeprecated()) {
                        Errors.error(Errors.DEPRECATED, m.position(), "Method " + cl.qualifiedName() + "." + m.name() + " is deprecated");
                    }
                    if ((returnClass = m.returnType().asClassInfo()) != null && returnClass.isHidden()) {
                        Errors.error(Errors.UNAVAILABLE_SYMBOL, m.position(), "Method " + cl.qualifiedName() + "." + m.name() + " returns unavailable type " + returnClass.name());
                    }
                    List<ParameterInfo> params = m.parameters();
                    for (ParameterInfo p : params) {
                        TypeInfo t = p.type();
                        if (t.isPrimitive() || !t.asClassInfo().isHidden()) continue;
                        Errors.error(Errors.UNAVAILABLE_SYMBOL, m.position(), "Parameter of hidden type " + t.fullName() + " in " + cl.qualifiedName() + "." + m.name() + "()");
                    }
                }
                for (MethodInfo m : cl.annotationElements()) {
                    if (m.isHidden()) {
                        Errors.error(Errors.UNAVAILABLE_SYMBOL, m.position(), "Reference to hidden annotation " + m.name());
                    }
                    if ((returnClass = m.returnType().asClassInfo()) != null && returnClass.isHidden()) {
                        Errors.error(Errors.UNAVAILABLE_SYMBOL, m.position(), "Annotation '" + m.name() + "' returns unavailable type " + returnClass.name());
                    }
                    for (ParameterInfo p : m.parameters()) {
                        TypeInfo t = p.type();
                        if (t.isPrimitive() || !t.asClassInfo().isHidden()) continue;
                        Errors.error(Errors.UNAVAILABLE_SYMBOL, p.position(), "Reference to unavailable annotation class " + t.fullName());
                    }
                }
                continue;
            }
            if (!cl.isDeprecated()) continue;
            Errors.error(Errors.DEPRECATED, cl.position(), "Class " + cl.qualifiedName() + " is deprecated");
        }
        if (stubPackages != null) {
            for (ClassInfo cl : this.notStrippable) {
                if (stubPackages.contains(cl.containingPackage().name())) continue;
                this.notStrippable.remove(cl);
            }
        }
    }

    public Set<ClassInfo> getNotStrippable() {
        return this.notStrippable;
    }

    public void writeStubsAndXml(String stubsDir, File xmlFile) {
        if (stubsDir == null && xmlFile == null) {
            return;
        }
        PrintStream xmlWriter = null;
        if (xmlFile != null) {
            ClearPage.ensureDirectory(xmlFile);
            try {
                xmlWriter = new PrintStream(xmlFile);
            }
            catch (FileNotFoundException e) {
                Errors.error(Errors.IO_ERROR, new SourcePositionInfo(xmlFile.getAbsolutePath(), 0, 0), "Cannot open file for write.");
            }
        }
        this.writeStubsAndXml(stubsDir, xmlWriter, this.notStrippable);
    }

    private void writeStubsAndXml(String stubsDir, PrintStream xmlWriter, Set<ClassInfo> classes) {
        HashMap<PackageInfo, List<ClassInfo>> packages = new HashMap<PackageInfo, List<ClassInfo>>();
        for (ClassInfo cl : classes) {
            if (cl.isDocOnly()) continue;
            if (stubsDir != null) {
                this.writeClassFile(stubsDir, cl);
            }
            if (xmlWriter == null || !cl.isDefinedLocally()) continue;
            if (packages.containsKey(cl.containingPackage())) {
                ((List)packages.get(cl.containingPackage())).add(cl);
                continue;
            }
            ArrayList<ClassInfo> adding = new ArrayList<ClassInfo>();
            adding.add(cl);
            packages.put(cl.containingPackage(), adding);
        }
        if (xmlWriter != null) {
            this.writeXML(xmlWriter, packages, classes);
            xmlWriter.close();
        }
    }

    private void cantStripThis(ClassInfo cl, Set<ClassInfo> notStrippable) {
        ClassInfo supr;
        if (!notStrippable.add(cl)) {
            return;
        }
        if (cl.allSelfFields() != null) {
            for (FieldInfo fInfo : cl.allSelfFields()) {
                if (fInfo.type() == null) continue;
                if (fInfo.type().asClassInfo() != null) {
                    this.cantStripThis(fInfo.type().asClassInfo(), notStrippable);
                }
                if (fInfo.type().typeArguments() == null) continue;
                for (TypeInfo tTypeInfo : fInfo.type().typeArguments()) {
                    if (tTypeInfo.asClassInfo() == null) continue;
                    this.cantStripThis(tTypeInfo.asClassInfo(), notStrippable);
                }
            }
        }
        if (cl.asTypeInfo() != null && cl.asTypeInfo().typeArguments() != null) {
            for (TypeInfo tInfo : cl.asTypeInfo().typeArguments()) {
                if (tInfo.asClassInfo() == null) continue;
                this.cantStripThis(tInfo.asClassInfo(), notStrippable);
            }
        }
        this.cantStripThis(cl.allSelfMethods(), notStrippable);
        this.cantStripThis(cl.allConstructors(), notStrippable);
        if (cl.containingClass() != null) {
            this.cantStripThis(cl.containingClass(), notStrippable);
        }
        if ((supr = cl.realSuperclass()) != null) {
            if (supr.isHidden()) {
                cl.init(cl.asTypeInfo(), cl.realInterfaces(), cl.realInterfaceTypes(), cl.innerClasses(), cl.allConstructors(), cl.allSelfMethods(), cl.annotationElements(), cl.allSelfFields(), cl.enumConstants(), cl.containingPackage(), cl.containingClass(), null, null, cl.annotations(), ImmutableList.<ClassInfo>of());
                Errors.error(Errors.HIDDEN_SUPERCLASS, cl.position(), "Public class " + cl.qualifiedName() + " stripped of unavailable superclass " + supr.qualifiedName());
            } else {
                this.cantStripThis(supr, notStrippable);
            }
        }
    }

    private void cantStripThis(List<MethodInfo> mInfos, Set<ClassInfo> notStrippable) {
        if (mInfos == null) {
            return;
        }
        for (MethodInfo mInfo : mInfos) {
            if (mInfo.isHidden()) continue;
            if (mInfo.getTypeParameters() != null) {
                for (TypeInfo tInfo : mInfo.getTypeParameters()) {
                    if (tInfo.asClassInfo() == null) continue;
                    this.cantStripThis(tInfo.asClassInfo(), notStrippable);
                }
            }
            if (mInfo.parameters() != null) {
                for (ParameterInfo pInfo : mInfo.parameters()) {
                    if (pInfo.type() == null || pInfo.type().asClassInfo() == null) continue;
                    this.cantStripThis(pInfo.type().asClassInfo(), notStrippable);
                    if (pInfo.type().typeArguments() == null) continue;
                    for (TypeInfo tInfoType : pInfo.type().typeArguments()) {
                        if (tInfoType.asClassInfo() == null) continue;
                        ClassInfo tcl = tInfoType.asClassInfo();
                        if (tcl.isHidden()) {
                            Errors.error(Errors.UNAVAILABLE_SYMBOL, mInfo.position(), "Parameter of hidden type " + tInfoType.fullName() + " in " + mInfo.containingClass().qualifiedName() + '.' + mInfo.name() + "()");
                            continue;
                        }
                        this.cantStripThis(tcl, notStrippable);
                    }
                }
            }
            for (ClassInfo thrown : mInfo.thrownExceptions()) {
                this.cantStripThis(thrown, notStrippable);
            }
            if (mInfo.returnType() == null || mInfo.returnType().asClassInfo() == null) continue;
            this.cantStripThis(mInfo.returnType().asClassInfo(), notStrippable);
            if (mInfo.returnType().typeArguments() == null) continue;
            for (TypeInfo tyInfo : mInfo.returnType().typeArguments()) {
                if (tyInfo.asClassInfo() == null) continue;
                this.cantStripThis(tyInfo.asClassInfo(), notStrippable);
            }
        }
    }

    private static String javaFileName(ClassInfo cl) {
        String dir = "";
        PackageInfo pkg = cl.containingPackage();
        if (pkg != null) {
            dir = pkg.name();
            dir = dir.replace('.', '/') + '/';
        }
        return dir + cl.name() + ".java";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClassFile(String stubsDir, ClassInfo cl) {
        if (cl.containingClass() != null) {
            return;
        }
        if (cl.containingPackage() != null && cl.containingPackage().name().equals("default package")) {
            return;
        }
        String filename = stubsDir + '/' + Stubs.javaFileName(cl);
        File file = new File(filename);
        ClearPage.ensureDirectory(file);
        PrintStream stream = null;
        try {
            stream = new PrintStream(file);
            this.writeClassFile(stream, cl);
        }
        catch (FileNotFoundException e) {
            System.err.println("error writing file: " + filename);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private void writeClassFile(PrintStream stream, ClassInfo cl) {
        PackageInfo pkg = cl.containingPackage();
        if (pkg != null) {
            stream.println("package " + pkg.name() + ";");
        }
        this.writeClass(stream, cl);
    }

    private void writeClass(PrintStream stream, ClassInfo cl) {
        int period;
        Stubs.writeAnnotations(stream, cl.annotations());
        stream.print(cl.scope() + " ");
        if (cl.isAbstract() && !cl.isAnnotation() && !cl.isInterface()) {
            stream.print("abstract ");
        }
        if (cl.isStatic()) {
            stream.print("static ");
        }
        if (cl.isFinal() && !cl.isEnum()) {
            stream.print("final ");
        }
        HashSet<String> classDeclTypeVars = new HashSet<String>();
        String leafName = cl.asTypeInfo().fullName(classDeclTypeVars);
        int bracket = leafName.indexOf(60);
        if (bracket < 0) {
            bracket = leafName.length() - 1;
        }
        if ((period = leafName.lastIndexOf(46, bracket)) < 0) {
            period = -1;
        }
        leafName = leafName.substring(period + 1);
        String kind = cl.kind();
        stream.println(kind + " " + leafName);
        TypeInfo base = cl.superclassType();
        if (!"enum".equals(kind) && base != null && !"java.lang.Object".equals(base.qualifiedTypeName())) {
            stream.println("  extends " + base.fullName(classDeclTypeVars));
        }
        List<TypeInfo> interfaces = cl.realInterfaceTypes();
        ArrayList<TypeInfo> usedInterfaces = new ArrayList<TypeInfo>();
        for (TypeInfo iface : interfaces) {
            if (!this.notStrippable.contains(iface.asClassInfo()) || iface.asClassInfo().isDocOnly()) continue;
            usedInterfaces.add(iface);
        }
        if (usedInterfaces.size() > 0 && !cl.isAnnotation()) {
            if (cl.isInterface() || cl.isAnnotation()) {
                stream.print("  extends ");
            } else {
                stream.print("  implements ");
            }
            String comma = "";
            for (TypeInfo iface : usedInterfaces) {
                stream.print(comma + iface.fullName(classDeclTypeVars));
                comma = ", ";
            }
            stream.println();
        }
        stream.println("{");
        Iterator<FieldInfo> f = cl.enumConstants().iterator();
        while (f.hasNext()) {
            FieldInfo field = f.next();
            if (!field.constantLiteralValue().equals("null")) {
                stream.println(field.name() + "(" + field.constantLiteralValue() + (f.hasNext() ? ")," : ");"));
                continue;
            }
            stream.println(field.name() + "(" + (f.hasNext() ? ")," : ");"));
        }
        for (ClassInfo inner : cl.getRealInnerClasses()) {
            if (!this.notStrippable.contains(inner) || inner.isDocOnly()) continue;
            this.writeClass(stream, inner);
        }
        for (MethodInfo method : cl.getConstructors()) {
            if (method.isDocOnly()) continue;
            Stubs.writeMethod(stream, method, true);
        }
        boolean fieldNeedsInitialization = false;
        boolean staticFieldNeedsInitialization = false;
        for (FieldInfo field : cl.allSelfFields()) {
            if (field.isDocOnly()) continue;
            if (!field.isStatic() && field.isFinal() && !Stubs.fieldIsInitialized(field)) {
                fieldNeedsInitialization = true;
            }
            if (!field.isStatic() || !field.isFinal() || Stubs.fieldIsInitialized(field)) continue;
            staticFieldNeedsInitialization = true;
        }
        if (!(!cl.getConstructors().isEmpty() || cl.getNonWrittenConstructors().isEmpty() && !fieldNeedsInitialization || cl.isAnnotation() || cl.isInterface() || cl.isEnum())) {
            stream.println(cl.leafName() + "() { " + Stubs.superCtorCall(cl, null) + "throw new" + " RuntimeException(\"Stub!\"); }");
        }
        for (MethodInfo method : cl.getMethods()) {
            if (cl.isEnum() && ("values".equals(method.name()) && "()".equals(method.signature()) || "valueOf".equals(method.name()) && "(java.lang.String)".equals(method.signature())) || method.isDocOnly()) continue;
            Stubs.writeMethod(stream, method, false);
        }
        for (MethodInfo method : cl.getHiddenMethods()) {
            MethodInfo overriddenMethod = method.findRealOverriddenMethod(method, this.notStrippable);
            if (overriddenMethod == null || overriddenMethod.isHidden() || overriddenMethod.isDocOnly() || !overriddenMethod.isAbstract() && !overriddenMethod.containingClass().isInterface()) continue;
            cl.addMethod(method);
            Stubs.writeMethod(stream, method, false);
        }
        for (MethodInfo element : cl.annotationElements()) {
            if (element.isDocOnly()) continue;
            Stubs.writeAnnotationElement(stream, element);
        }
        for (FieldInfo field : cl.allSelfFields()) {
            if (field.isDocOnly()) continue;
            Stubs.writeField(stream, field);
        }
        if (staticFieldNeedsInitialization) {
            stream.print("static { ");
            for (FieldInfo field : cl.allSelfFields()) {
                if (field.isDocOnly() || !field.isStatic() || !field.isFinal() || Stubs.fieldIsInitialized(field) || field.constantValue() != null) continue;
                stream.print(field.name() + " = " + field.type().defaultValue() + "; ");
            }
            stream.println("}");
        }
        stream.println("}");
    }

    private static void writeMethod(PrintStream stream, MethodInfo method, boolean isConstructor) {
        String n;
        int pos;
        stream.print(method.scope() + " ");
        if (method.isStatic()) {
            stream.print("static ");
        }
        if (method.isFinal()) {
            stream.print("final ");
        }
        if (method.isAbstract()) {
            stream.print("abstract ");
        }
        if (method.isSynchronized()) {
            stream.print("synchronized ");
        }
        if (method.isNative()) {
            stream.print("native ");
        }
        stream.print(method.typeArgumentsName(new HashSet<String>()) + " ");
        if (!isConstructor) {
            stream.print(method.returnType().fullName(method.typeVariables()) + " ");
        }
        if ((pos = (n = method.name()).lastIndexOf(46)) >= 0) {
            n = n.substring(pos + 1);
        }
        stream.print(n + "(");
        String comma = "";
        int count = 1;
        int size = method.parameters().size();
        for (ParameterInfo param : method.parameters()) {
            stream.print(comma + Stubs.fullParameterTypeName(method, param.type(), count == size) + " " + param.name());
            comma = ", ";
            ++count;
        }
        stream.print(")");
        comma = "";
        if (!method.thrownExceptions().isEmpty()) {
            stream.print(" throws ");
            for (ClassInfo thrown : method.thrownExceptions()) {
                stream.print(comma + thrown.qualifiedName());
                comma = ", ";
            }
        }
        if (method.isAbstract() || method.isNative() || method.containingClass().isInterface()) {
            stream.println(";");
        } else {
            stream.print(" { ");
            if (isConstructor) {
                stream.print(Stubs.superCtorCall(method.containingClass(), method.thrownExceptions()));
            }
            stream.println("throw new RuntimeException(\"Stub!\"); }");
        }
    }

    private static void writeField(PrintStream stream, FieldInfo field) {
        stream.print(field.scope() + " ");
        if (field.isStatic()) {
            stream.print("static ");
        }
        if (field.isFinal()) {
            stream.print("final ");
        }
        if (field.isTransient()) {
            stream.print("transient ");
        }
        if (field.isVolatile()) {
            stream.print("volatile ");
        }
        stream.print(field.type().fullName());
        stream.print(" ");
        stream.print(field.name());
        if (Stubs.fieldIsInitialized(field)) {
            stream.print(" = " + field.constantLiteralValue());
        }
        stream.println(";");
    }

    private static boolean fieldIsInitialized(FieldInfo field) {
        return field.isFinal() && field.constantValue() != null || !field.type().dimension().equals("") || field.containingClass().isInterface();
    }

    private boolean methodIsOverride(MethodInfo mi) {
        if (mi.isAbstract() || mi.isStatic() || mi.isFinal()) {
            return false;
        }
        MethodInfo om = mi.findSuperclassImplementation(this.notStrippable);
        return om != null && mi.mIsPrivate == om.mIsPrivate && mi.mIsPublic == om.mIsPublic && mi.mIsProtected == om.mIsProtected && !om.isAbstract() && !om.isHidden() && !mi.mContainingClass.equals(om.mContainingClass);
    }

    private static boolean canCallMethod(ClassInfo from, MethodInfo m) {
        String pkg;
        String fromPkg;
        if (m.isPublic() || m.isProtected()) {
            return true;
        }
        return m.isPackagePrivate() && (fromPkg = from.containingPackage().name()).equals(pkg = m.containingClass().containingPackage().name());
    }

    private static String superCtorCall(ClassInfo cl, List<ClassInfo> thrownExceptions) {
        ClassInfo base = cl.realSuperclass();
        if (base == null) {
            return "";
        }
        HashSet<String> exceptionNames = new HashSet<String>();
        if (thrownExceptions != null) {
            for (ClassInfo thrown : thrownExceptions) {
                exceptionNames.add(thrown.name());
            }
        }
        MethodInfo ctor = null;
        Boolean badException = false;
        for (MethodInfo m : base.getConstructors()) {
            if (!Stubs.canCallMethod(cl, m)) continue;
            if (m.thrownExceptions() != null) {
                for (ClassInfo thrown : m.thrownExceptions()) {
                    if (exceptionNames.contains(thrown.name())) continue;
                    badException = true;
                }
            }
            if (badException.booleanValue()) {
                badException = false;
                continue;
            }
            if (m.parameters().isEmpty()) {
                return "";
            }
            ctor = m;
        }
        if (ctor != null) {
            String result = "";
            result = result + "super(";
            List<ParameterInfo> params = ctor.parameters();
            int N = params.size();
            for (int i = 0; i < N; ++i) {
                String n;
                TypeInfo t = params.get(i).type();
                result = t.isPrimitive() && t.dimension().equals("") ? (("byte".equals(n = t.simpleTypeName()) || "short".equals(n) || "int".equals(n) || "long".equals(n) || "float".equals(n) || "double".equals(n)) && t.dimension().equals("") ? result + "0" : ("char".equals(n) ? result + "'\\0'" : ("boolean".equals(n) ? result + "false" : result + "<<unknown-" + n + ">>"))) : result + (!t.isTypeVariable() ? "(" + t.qualifiedTypeName() + t.dimension() + ")" : "") + "null";
                if (i == N - 1) continue;
                result = result + ",";
            }
            result = result + "); ";
            return result;
        }
        return "";
    }

    private static void writeAnnotations(PrintStream stream, AnnotationInstanceInfo[] annotations) {
        for (AnnotationInstanceInfo ann : annotations) {
            if (ann.type().isHidden()) continue;
            stream.println(ann.toString());
        }
    }

    private static void writeAnnotationElement(PrintStream stream, MethodInfo ann) {
        stream.print(ann.returnType().fullName());
        stream.print(" ");
        stream.print(ann.name());
        stream.print("()");
        AnnotationValueInfo def = ann.defaultAnnotationElementValue();
        if (def != null) {
            stream.print(" default ");
            stream.print(def.valueString());
        }
        stream.println(";");
    }

    private void writeXML(PrintStream xmlWriter, Map<PackageInfo, List<ClassInfo>> allClasses, Set<ClassInfo> notStrippable) {
        Set<PackageInfo> allClassKeys = allClasses.keySet();
        PackageInfo[] allPackages = allClassKeys.toArray(new PackageInfo[allClassKeys.size()]);
        Arrays.sort(allPackages, PackageInfo.ORDER_BY_NAME);
        xmlWriter.println("<api>");
        for (PackageInfo pack : allPackages) {
            this.writePackageXML(xmlWriter, pack, allClasses.get(pack), notStrippable);
        }
        xmlWriter.println("</api>");
    }

    private void writePackageXML(PrintStream xmlWriter, PackageInfo pack, List<ClassInfo> classList, Set<ClassInfo> notStrippable) {
        ClassInfo[] classes = classList.toArray(new ClassInfo[classList.size()]);
        Arrays.sort(classes, ClassInfo.ORDER_BY_NAME);
        if (pack.name().equals("default package")) {
            return;
        }
        xmlWriter.println("<package name=\"" + pack.name() + "\"\n" + ">");
        for (ClassInfo cl : classes) {
            this.writeClassXML(xmlWriter, cl, notStrippable);
        }
        xmlWriter.println("</package>");
    }

    private void writeClassXML(PrintStream xmlWriter, ClassInfo cl, Set<ClassInfo> notStrippable) {
        String scope = cl.scope();
        String declString = cl.isInterface() ? "interface" : "class";
        String deprecatedString = cl.isDeprecated() ? "deprecated" : "not deprecated";
        xmlWriter.println("<" + declString + " name=\"" + cl.name() + "\"");
        if (!cl.isInterface() && !cl.qualifiedName().equals("java.lang.Object")) {
            xmlWriter.println(" extends=\"" + (cl.realSuperclass() == null ? "java.lang.Object" : cl.realSuperclass().qualifiedName()) + "\"");
        }
        xmlWriter.println(" abstract=\"" + cl.isAbstract() + "\"\n" + " static=\"" + cl.isStatic() + "\"\n" + " final=\"" + cl.isFinal() + "\"\n" + " deprecated=\"" + deprecatedString + "\"\n" + " visibility=\"" + scope + "\"\n" + ">");
        List<ClassInfo> interfaces = cl.realInterfaces();
        Collections.sort(interfaces, ClassInfo.ORDER_BY_NAME);
        for (ClassInfo iface : interfaces) {
            if (!notStrippable.contains(iface)) continue;
            xmlWriter.println("<implements name=\"" + iface.qualifiedName() + "\">");
            xmlWriter.println("</implements>");
        }
        for (MethodInfo mi : cl.getConstructors()) {
            Stubs.writeConstructorXML(xmlWriter, mi);
        }
        for (MethodInfo mi : cl.getMethods()) {
            if (this.methodIsOverride(mi)) continue;
            Stubs.writeMethodXML(xmlWriter, mi);
        }
        for (FieldInfo fi : cl.getFields()) {
            Stubs.writeFieldXML(xmlWriter, fi);
        }
        xmlWriter.println("</" + declString + ">");
    }

    private static void writeMethodXML(PrintStream xmlWriter, MethodInfo mi) {
        String scope = mi.scope();
        String deprecatedString = mi.isDeprecated() ? "deprecated" : "not deprecated";
        xmlWriter.println("<method name=\"" + mi.name() + "\"\n" + (mi.returnType() != null ? " return=\"" + Stubs.makeXMLcompliant(Stubs.fullParameterTypeName(mi, mi.returnType(), false)) + "\"\n" : "") + " abstract=\"" + mi.isAbstract() + "\"\n" + " native=\"" + mi.isNative() + "\"\n" + " synchronized=\"" + mi.isSynchronized() + "\"\n" + " static=\"" + mi.isStatic() + "\"\n" + " final=\"" + mi.isFinal() + "\"\n" + " deprecated=\"" + deprecatedString + "\"\n" + " visibility=\"" + scope + "\"\n" + ">");
        int numParameters = mi.parameters().size();
        int count = 0;
        for (ParameterInfo pi : mi.parameters()) {
            Stubs.writeParameterXML(xmlWriter, mi, pi, ++count == numParameters);
        }
        List<ClassInfo> exceptions = mi.thrownExceptions();
        Collections.sort(exceptions, ClassInfo.ORDER_BY_NAME);
        for (ClassInfo pi : exceptions) {
            xmlWriter.println("<exception name=\"" + pi.name() + "\" type=\"" + pi.qualifiedName() + "\">");
            xmlWriter.println("</exception>");
        }
        xmlWriter.println("</method>");
    }

    private static void writeConstructorXML(PrintStream xmlWriter, MethodInfo mi) {
        String scope = mi.scope();
        String deprecatedString = mi.isDeprecated() ? "deprecated" : "not deprecated";
        xmlWriter.println("<constructor name=\"" + mi.name() + "\"\n" + " type=\"" + mi.containingClass().qualifiedName() + "\"\n" + " static=\"" + mi.isStatic() + "\"\n" + " final=\"" + mi.isFinal() + "\"\n" + " deprecated=\"" + deprecatedString + "\"\n" + " visibility=\"" + scope + "\"\n" + ">");
        int numParameters = mi.parameters().size();
        int count = 0;
        for (ParameterInfo pi : mi.parameters()) {
            Stubs.writeParameterXML(xmlWriter, mi, pi, ++count == numParameters);
        }
        List<ClassInfo> exceptions = mi.thrownExceptions();
        Collections.sort(exceptions, ClassInfo.ORDER_BY_NAME);
        for (ClassInfo pi : exceptions) {
            xmlWriter.println("<exception name=\"" + pi.name() + "\" type=\"" + pi.qualifiedName() + "\">");
            xmlWriter.println("</exception>");
        }
        xmlWriter.println("</constructor>");
    }

    private static void writeParameterXML(PrintStream xmlWriter, MethodInfo method, ParameterInfo pi, boolean isLast) {
        xmlWriter.println("<parameter name=\"" + pi.name() + "\" type=\"" + Stubs.makeXMLcompliant(Stubs.fullParameterTypeName(method, pi.type(), isLast)) + "\">");
        xmlWriter.println("</parameter>");
    }

    private static void writeFieldXML(PrintStream xmlWriter, FieldInfo fi) {
        String scope = fi.scope();
        String deprecatedString = fi.isDeprecated() ? "deprecated" : "not deprecated";
        String value = Stubs.makeXMLcompliant(fi.constantLiteralValue());
        String fullTypeName = Stubs.makeXMLcompliant(fi.type().qualifiedTypeName()) + fi.type().dimension();
        xmlWriter.println("<field name=\"" + fi.name() + "\"\n" + " type=\"" + fullTypeName + "\"\n" + " transient=\"" + fi.isTransient() + "\"\n" + " volatile=\"" + fi.isVolatile() + "\"\n" + (Stubs.fieldIsInitialized(fi) ? " value=\"" + value + "\"\n" : "") + " static=\"" + fi.isStatic() + "\"\n" + " final=\"" + fi.isFinal() + "\"\n" + " deprecated=\"" + deprecatedString + "\"\n" + " visibility=\"" + scope + "\"\n" + ">");
        xmlWriter.println("</field>");
    }

    private static String makeXMLcompliant(String s) {
        String returnString = s.replaceAll("&", "&amp;");
        returnString = returnString.replaceAll("<", "&lt;");
        returnString = returnString.replaceAll(">", "&gt;");
        returnString = returnString.replaceAll("\"", "&quot;");
        returnString = returnString.replaceAll("'", "&pos;");
        return returnString;
    }

    private static String fullParameterTypeName(MethodInfo method, TypeInfo type, boolean isLast) {
        String fullTypeName = type.fullName(method.typeVariables());
        if (isLast && method.isVarArgs()) {
            fullTypeName = type.fullNameNoDimension(method.typeVariables()) + "...";
        }
        return fullTypeName;
    }
}

