/*
 * Decompiled with CFR 0.152.
 */
package com.google.streamhtmlparser.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.streamhtmlparser.util.HtmlUtils;
import java.util.Map;

public class EntityResolver {
    private static final int MAX_ENTITY_SIZE = 10;
    private static final Map<String, String> HTML_ENTITIES_MAP = new ImmutableMap.Builder<String, String>().put("&lt", "<").put("&gt", ">").put("&amp", "&").put("&apos", "'").build();
    private final StringBuilder sb = new StringBuilder();
    private Status status;
    private String entity;

    public EntityResolver() {
        this.status = Status.NOT_STARTED;
        this.entity = "";
    }

    public EntityResolver(EntityResolver aEntityResolver) {
        this.sb.replace(0, this.sb.length(), aEntityResolver.sb.toString());
        this.entity = aEntityResolver.entity;
        this.status = aEntityResolver.status;
    }

    public void reset() {
        this.status = Status.NOT_STARTED;
        this.sb.setLength(0);
        this.entity = "";
    }

    public String toString() {
        return String.format("Status: %s; Contents (%d): %s", this.status.toString(), this.sb.length(), this.sb.toString());
    }

    public String getEntity() {
        return this.entity;
    }

    public Status processChar(char input) {
        Preconditions.checkState(this.status != Status.NOT_STARTED || this.sb.length() == 0);
        if (this.status == Status.NOT_STARTED) {
            if (input == '&') {
                this.sb.append(input);
                this.status = Status.IN_PROGRESS;
            }
        } else if (this.status == Status.IN_PROGRESS) {
            if (input == ';' || HtmlUtils.isHtmlSpace(input)) {
                this.status = Status.COMPLETED;
                this.entity = this.convertEntity(input);
            } else if (this.sb.length() < 10) {
                this.sb.append(input);
            } else {
                this.status = Status.COMPLETED;
                this.entity = this.uncovertedInput(input);
            }
        }
        return this.status;
    }

    private String convertEntity(char terminator) {
        Preconditions.checkArgument(this.sb.length() > 0);
        Preconditions.checkArgument(this.sb.charAt(0) == '&');
        if (this.sb.length() > 1) {
            if (this.sb.charAt(1) == '#') {
                if (this.sb.length() <= 2) {
                    return this.uncovertedInput(terminator);
                }
                try {
                    if (this.sb.charAt(2) == 'x' || this.sb.charAt(2) == 'X') {
                        return new String(Character.toChars(Integer.parseInt(this.sb.substring(3), 16)));
                    }
                    return new String(Character.toChars(Integer.parseInt(this.sb.substring(2))));
                }
                catch (NumberFormatException e) {
                    return this.uncovertedInput(terminator);
                }
            }
            String key = this.sb.toString();
            if (HTML_ENTITIES_MAP.containsKey(key)) {
                return HTML_ENTITIES_MAP.get(key);
            }
        }
        return this.uncovertedInput(terminator);
    }

    private String uncovertedInput(char terminator) {
        return String.format("%s%c", this.sb.toString(), Character.valueOf(terminator));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOT_STARTED("Not Started"),
        IN_PROGRESS("In Progress"),
        COMPLETED("Completed");

        private final String message;

        private Status(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }
}

