/*
 * Copyright 2013 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package demo.org.powermock.examples.easymock31;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.core.classloader.annotations.SuppressStaticInitializationFor;
import org.powermock.modules.junit4.PowerMockRunner;

import static junit.framework.Assert.assertEquals;
import static org.easymock.EasyMock.expect;
import static org.powermock.api.easymock.PowerMock.*;
import static org.powermock.reflect.Whitebox.invokeMethod;

@RunWith(PowerMockRunner.class)
@SuppressStaticInitializationFor("demo.org.powermock.examples.easymock31.SimpleConfig")
@PrepareForTest( { Greeter.class, Logger.class })
public class GreeterTest {

    @Test
    public void testGetMessage() throws Exception {
        mockStatic(SimpleConfig.class);
        expect(SimpleConfig.getGreeting()).andReturn("Hi");
        expect(SimpleConfig.getTarget()).andReturn("All");
        replay(SimpleConfig.class);

        assertEquals("Hi All", invokeMethod(Greeter.class, "getMessage"));

        verify(SimpleConfig.class);
    }



    @Test(expected = IllegalArgumentException.class)
    public void testRunWhenLoggerThrowsUnexpectedRuntimeException() throws Exception {
        expectNew(Logger.class).andThrow(new IllegalArgumentException("Unexpected exeception"));
        replay(Logger.class);

        invokeMethod(new Greeter(), "run", 10, "Hello");

        verify(Logger.class);
    }

    /**
     * This test demonstrates that <a
     * href="http://code.google.com/p/powermock/issues/detail?id=110">issue
     * 110</a> has been resolved.
     */
    @Test
    @PrepareForTest( { SimpleConfig.class })
    public void assertItsOkToInvokeReflectionMethodsOnClasses() throws Exception {
        new SimpleConfig();
    }
}