package org.codehaus.plexus.compiler.j2objc;

/**
 * The MIT License
 *
 * Copyright (c) 2005, The Codehaus
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import junit.framework.Assert;
import junit.framework.TestCase;

import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;

/**
 * j2objc must be in the PATH
 * @author lmaitre
 */
public class J2ObjCCompilerTest
    extends TestCase
{
	
	public void testJ2ObjCCompiler() throws IOException {
		J2ObjCCompiler comp = new J2ObjCCompiler();
		Map<String,String> customCompilerArguments = new HashMap<String,String>();
		customCompilerArguments.put("-use-arc", null);
		customCompilerArguments.put("-sourcepath", "src/test/resources");
		CompilerConfiguration cc = new CompilerConfiguration();
		cc.setOutputLocation("target/generated/objective-c");
		cc.setSourceLocations(Arrays.asList(new String[]{
				"src/test/resources"
		}));
		cc.setWorkingDirectory(new File("."));
		cc.setFork(true);
		cc.setCustomCompilerArgumentsAsMap(customCompilerArguments);
		try {
			comp.performCompile(cc);
			Assert.assertTrue(new File("target/generated/objective-c/de/test/App.h").exists());
			Assert.assertTrue(new File("target/generated/objective-c/de/test/App.m").exists());
		} catch ( CompilerException ce ) {
			fail("An exception has occured: " + ce.getMessage());
		}
	}

}
