/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.SourceFileData;
import net.sourceforge.cobertura.javancss.FunctionMetric;
import net.sourceforge.cobertura.javancss.Javancss;
import net.sourceforge.cobertura.util.FileFinder;
import net.sourceforge.cobertura.util.Source;
import org.apache.log4j.Logger;

public class ComplexityCalculator {
    private static final Logger logger = Logger.getLogger(ComplexityCalculator.class);
    public static final Complexity ZERO_COMPLEXITY = new Complexity();
    private final FileFinder finder;
    private Map sourceFileCNNCache = new HashMap();
    private Map packageCNNCache = new HashMap();

    public ComplexityCalculator(FileFinder finder) {
        if (finder == null) {
            throw new NullPointerException();
        }
        this.finder = finder;
    }

    private Complexity getAccumlatedCCNForSource(String sourceFileName, Source source) {
        if (source == null) {
            return ZERO_COMPLEXITY;
        }
        if (!sourceFileName.endsWith(".java")) {
            return ZERO_COMPLEXITY;
        }
        Javancss javancss = new Javancss(source.getInputStream());
        if (javancss.getLastErrorMessage() != null) {
            logger.warn((Object)("JavaNCSS got an error while parsing the java " + source.getOriginDesc() + "\n" + javancss.getLastErrorMessage()));
        }
        List methodMetrics = javancss.getFunctionMetrics();
        int classCcn = 0;
        for (FunctionMetric singleMethodMetrics : methodMetrics) {
            classCcn += singleMethodMetrics.ccn;
        }
        return new Complexity(classCcn, methodMetrics.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Complexity getAccumlatedCCNForSingleFile(String sourceFileName) throws IOException {
        Source source = this.finder.getSource(sourceFileName);
        try {
            Complexity complexity = this.getAccumlatedCCNForSource(sourceFileName, source);
            return complexity;
        }
        finally {
            if (source != null) {
                source.close();
            }
        }
    }

    public double getCCNForProject(ProjectData projectData) {
        Complexity act = new Complexity();
        for (PackageData packageData : projectData.getPackages()) {
            act.add(this.getCCNForPackageInternal(packageData));
        }
        return act.averageCCN();
    }

    public double getCCNForPackage(PackageData packageData) {
        return this.getCCNForPackageInternal(packageData).averageCCN();
    }

    private Complexity getCCNForPackageInternal(PackageData packageData) {
        Complexity cachedCCN = (Complexity)this.packageCNNCache.get(packageData.getName());
        if (cachedCCN != null) {
            return cachedCCN;
        }
        Complexity act = new Complexity();
        for (SourceFileData sourceData : packageData.getSourceFiles()) {
            act.add(this.getCCNForSourceFileNameInternal(sourceData.getName()));
        }
        this.packageCNNCache.put(packageData.getName(), act);
        return act;
    }

    public double getCCNForSourceFile(SourceFileData sourceFile) {
        return this.getCCNForSourceFileNameInternal(sourceFile.getName()).averageCCN();
    }

    private Complexity getCCNForSourceFileNameInternal(String sourceFileName) {
        Complexity cachedCCN = (Complexity)this.sourceFileCNNCache.get(sourceFileName);
        if (cachedCCN != null) {
            return cachedCCN;
        }
        Complexity result = ZERO_COMPLEXITY;
        try {
            result = this.getAccumlatedCCNForSingleFile(sourceFileName);
        }
        catch (IOException ex) {
            logger.info((Object)("Cannot find source file during CCN computation, source=[" + sourceFileName + "]"));
        }
        this.sourceFileCNNCache.put(sourceFileName, result);
        return result;
    }

    public double getCCNForClass(ClassData classData) {
        return this.getCCNForSourceFileNameInternal(classData.getSourceFileName()).averageCCN();
    }

    private static class Complexity {
        private double accumlatedCCN;
        private int methodsNum;

        public Complexity(double accumlatedCCN, int methodsNum) {
            this.accumlatedCCN = accumlatedCCN;
            this.methodsNum = methodsNum;
        }

        public Complexity() {
            this(0.0, 0);
        }

        public double averageCCN() {
            if (this.methodsNum == 0) {
                return 0.0;
            }
            return this.accumlatedCCN / (double)this.methodsNum;
        }

        public void add(Complexity second) {
            this.accumlatedCCN += second.accumlatedCCN;
            this.methodsNum += second.methodsNum;
        }
    }
}

