/*
 * Decompiled with CFR 0.152.
 */
package javax.script.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.script.SimpleScriptContext;
import javax.script.http.HttpScriptContext;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleHttpScriptContext
extends SimpleScriptContext
implements HttpScriptContext {
    protected boolean disableScript;
    protected boolean displayResults;
    protected boolean useSession;
    protected String[] methods;
    protected String[] languages;
    protected String docRoot;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected Servlet servlet;
    public static final String[] defaultMethods = new String[]{"GET", "POST"};
    private static List<Integer> scopes = new ArrayList<Integer>();

    public SimpleHttpScriptContext() {
        this.release();
    }

    @Override
    public boolean disableScript() {
        return this.disableScript;
    }

    @Override
    public boolean displayResults() {
        return this.displayResults;
    }

    @Override
    public void forward(String relativePath) throws ServletException, IOException {
        ServletContext context = this.servlet.getServletConfig().getServletContext();
        String uri = this.request.getServletPath();
        String baseURI = uri.substring(0, uri.lastIndexOf(47));
        String path = baseURI + '/' + relativePath;
        context.getRequestDispatcher(path).forward((ServletRequest)this.request, (ServletResponse)this.response);
    }

    @Override
    public String[] getMethods() {
        return this.methods;
    }

    @Override
    public String[] getAllowedLanguages() {
        return this.languages;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public Reader getScriptSource() {
        String requestURI = (String)this.request.getAttribute("javax.servlet.include.request_uri");
        if (requestURI == null || requestURI.equals("")) {
            requestURI = this.request.getRequestURI();
        }
        String resourcePath = requestURI.substring(this.request.getContextPath().length());
        try {
            if (this.docRoot != null) {
                String separator = this.docRoot.endsWith(File.separator) || resourcePath.startsWith(File.separator) ? "" : File.separator;
                String fullPath = this.docRoot + separator + resourcePath;
                return new InputStreamReader(new FileInputStream(fullPath));
            }
            InputStream stream = this.servlet.getServletConfig().getServletContext().getResourceAsStream(resourcePath);
            return new BufferedReader(new InputStreamReader(stream));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Servlet getServlet() {
        return this.servlet;
    }

    private void includeOnNewThread(final String path, final ServletContext context) {
        try {
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        context.getRequestDispatcher(path).include((ServletRequest)SimpleHttpScriptContext.this.request, (ServletResponse)SimpleHttpScriptContext.this.response);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            Thread t = new Thread(r);
            t.start();
            t.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void include(String relativePath) throws ServletException, IOException {
        ServletContext context = this.servlet.getServletConfig().getServletContext();
        String uri = this.request.getServletPath();
        String baseURI = uri.substring(0, uri.lastIndexOf(47));
        String path = baseURI + '/' + relativePath;
        context.getRequestDispatcher(path).include((ServletRequest)this.request, (ServletResponse)this.response);
    }

    @Override
    public void initialize(Servlet servlet, HttpServletRequest req, HttpServletResponse res) throws ServletException {
        StringTokenizer tokenizer;
        this.request = new RequestWrapper(req);
        this.response = new ResponseWrapper(res);
        this.servlet = servlet;
        ServletContext context = servlet.getServletConfig().getServletContext();
        this.docRoot = context.getInitParameter("script-directory");
        String disable = context.getInitParameter("script-disable");
        String session = context.getInitParameter("script-use-session");
        String display = context.getInitParameter("script-display-results");
        String methodstring = context.getInitParameter("script-methods");
        String languagesstring = context.getInitParameter("allow-languages");
        if (this.docRoot != null && !new File(this.docRoot).isDirectory()) {
            throw new ServletException("Specified document root ," + this.docRoot + " either does not exist or is not a directory.");
        }
        if (disable != null && disable.equals("true")) {
            this.disableScript = true;
            return;
        }
        if (session != null && session.equals("false")) {
            this.useSession = false;
        }
        if (display != null && display.equals("false")) {
            this.displayResults = false;
        }
        if (methodstring != null) {
            tokenizer = new StringTokenizer(methodstring, ",");
            ArrayList<String> methodList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                methodList.add(tokenizer.nextToken());
            }
            this.methods = methodList.toArray(new String[methodList.size()]);
        }
        if (languagesstring != null && !languagesstring.equals("")) {
            tokenizer = new StringTokenizer(languagesstring, ",");
            ArrayList<String> languagesList = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                languagesList.add(tokenizer.nextToken());
            }
            this.languages = languagesList.toArray(new String[languagesList.size()]);
        } else {
            this.languages = null;
        }
    }

    @Override
    public void release() {
        this.disableScript = false;
        this.displayResults = true;
        this.useSession = true;
        this.methods = defaultMethods;
        this.request = null;
        this.response = null;
        this.servlet = null;
    }

    private void testScopeValue(int scope) {
        if (scope != 0 && scope != 150 && scope != 175) {
            throw new IllegalArgumentException("Invalid scope value.");
        }
        if (scope == 150) {
            HttpSession sess = this.request.getSession();
            if (!this.useSession || sess == null) {
                throw new IllegalStateException("Session state disabled.");
            }
        }
    }

    @Override
    public void setAttribute(String key, Object value, int scope) {
        this.testScopeValue(scope);
        if (scope == 0) {
            this.request.setAttribute(key, value);
        } else if (scope == 150) {
            this.request.getSession().setAttribute(key, value);
        } else if (scope == 175) {
            System.out.println("setting key = " + key + " value = " + value);
            this.servlet.getServletConfig().getServletContext().setAttribute(key, value);
        }
    }

    @Override
    public Object getAttribute(String key) {
        Object ret = this.getAttribute(key, 0);
        if (null != ret) {
            return ret;
        }
        ret = this.getAttribute(key, 150);
        if (null != ret) {
            return ret;
        }
        ret = this.getAttribute(key, 175);
        if (null != ret) {
            return ret;
        }
        return null;
    }

    @Override
    public Object getAttribute(String key, int scope) {
        this.testScopeValue(scope);
        if (scope == 0) {
            return this.request.getAttribute(key);
        }
        if (scope == 150) {
            return this.request.getSession().getAttribute(key);
        }
        if (scope == 175) {
            Object obj = this.servlet.getServletConfig().getServletContext().getAttribute(key);
            System.out.println("value = " + obj);
            return obj;
        }
        return null;
    }

    @Override
    public boolean useSession() {
        return this.useSession;
    }

    @Override
    public Writer getWriter() {
        try {
            return this.response.getWriter();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public List<Integer> getScopes() {
        return scopes;
    }

    static {
        scopes.add(0);
        scopes.add(150);
        scopes.add(175);
        scopes.add(100);
        scopes.add(200);
        scopes = Collections.unmodifiableList(scopes);
    }

    public class ResponseWrapper
    extends HttpServletResponseWrapper {
        public ResponseWrapper(HttpServletResponse res) {
            super(res);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return super.getOutputStream();
        }
    }

    public class RequestWrapper
    extends HttpServletRequestWrapper {
        public RequestWrapper(HttpServletRequest req) {
            super(req);
        }

        public HttpSession getSession() {
            if (SimpleHttpScriptContext.this.useSession()) {
                return super.getSession();
            }
            return null;
        }
    }
}

