/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.ant;

import com.sun.wts.tools.ant.Command;
import com.sun.wts.tools.ant.RenamePattern;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class PackageRenameTask
extends MatchingTask {
    private File destDir;
    private File srcDir;
    private List<RenamePattern> patterns = new ArrayList<RenamePattern>();
    private List<Command> commands = new ArrayList<Command>();

    public void setDestdir(File destDir) {
        this.destDir = destDir;
    }

    public void setSrcDir(File srcDir) {
        this.srcDir = srcDir;
    }

    public void addConfiguredPattern(RenamePattern p) {
        p.addCommands(this.commands);
        this.patterns.add(p);
    }

    public void execute() throws BuildException {
        String[] files;
        this.log("performing package renaming", 2);
        for (String relPath : files = this.getDirectoryScanner(this.srcDir).getIncludedFiles()) {
            RenamePattern p;
            File sfile = new File(this.srcDir, relPath);
            String dstRelPath = null;
            Iterator<RenamePattern> i$ = this.patterns.iterator();
            while (i$.hasNext() && (dstRelPath = (p = i$.next()).convertPath(relPath)) == null) {
            }
            if (dstRelPath == null) {
                dstRelPath = relPath;
            }
            File dfile = new File(this.destDir, dstRelPath);
            this.process(sfile, dfile);
        }
    }

    private void process(File src, File dest) {
        if (src.lastModified() < dest.lastModified()) {
            this.log("skipping " + dest, 3);
            return;
        }
        this.log("generating " + dest, 3);
        dest.getParentFile().mkdirs();
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(src));
            BufferedWriter out = new BufferedWriter(new FileWriter(dest));
            while ((line = in.readLine()) != null) {
                out.write(this.process(line));
                out.newLine();
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private String process(String line) {
        for (Command cmd : this.commands) {
            line = cmd.replace(line);
        }
        return line;
    }
}

