package org.apache.lucene.geo3d;

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Static methods globally useful for 3d geometric work.
 *
 * @lucene.experimental
 */
public class Tools {
  private Tools() {
  }

  /**
   * Java acos yields a NAN if you take an arc-cos of an
   * angle that's just a tiny bit greater than 1.0, so
   * here's a more resilient version.
   */
  public static double safeAcos(double value) {
    if (value > 1.0)
      value = 1.0;
    else if (value < -1.0)
      value = -1.0;
    return Math.acos(value);
  }

}
