/*
 * Decompiled with CFR 0.152.
 */
package org.testng.guice.internal;

import java.util.Set;
import org.testng.guice.Binder;
import org.testng.guice.Injector;
import org.testng.guice.Key;
import org.testng.guice.Provider;
import org.testng.guice.internal.BindingImpl;
import org.testng.guice.internal.ImmutableSet;
import org.testng.guice.internal.InternalFactory;
import org.testng.guice.internal.Scoping;
import org.testng.guice.internal.ToStringBuilder;
import org.testng.guice.spi.BindingTargetVisitor;
import org.testng.guice.spi.Dependency;
import org.testng.guice.spi.HasDependencies;
import org.testng.guice.spi.InjectionPoint;
import org.testng.guice.spi.ProviderInstanceBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderInstanceBindingImpl<T>
extends BindingImpl<T>
implements ProviderInstanceBinding<T> {
    final Provider<? extends T> providerInstance;
    final ImmutableSet<InjectionPoint> injectionPoints;

    public ProviderInstanceBindingImpl(Injector injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping, Provider<? extends T> providerInstance, Set<InjectionPoint> injectionPoints) {
        super(injector, key, source, internalFactory, scoping);
        this.providerInstance = providerInstance;
        this.injectionPoints = ImmutableSet.copyOf(injectionPoints);
    }

    public ProviderInstanceBindingImpl(Object source, Key<T> key, Scoping scoping, Set<InjectionPoint> injectionPoints, Provider<? extends T> providerInstance) {
        super(source, key, scoping);
        this.injectionPoints = ImmutableSet.copyOf(injectionPoints);
        this.providerInstance = providerInstance;
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Provider<? extends T> getProviderInstance() {
        return this.providerInstance;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return this.providerInstance instanceof HasDependencies ? ImmutableSet.copyOf(((HasDependencies)((Object)this.providerInstance)).getDependencies()) : Dependency.forInjectionPoints(this.injectionPoints);
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new ProviderInstanceBindingImpl<T>(this.getSource(), this.getKey(), scoping, this.injectionPoints, this.providerInstance);
    }

    @Override
    public BindingImpl<T> withKey(Key<T> key) {
        return new ProviderInstanceBindingImpl<T>(this.getSource(), key, this.getScoping(), this.injectionPoints, this.providerInstance);
    }

    @Override
    public void applyTo(Binder binder) {
        this.getScoping().applyTo(binder.withSource(this.getSource()).bind(this.getKey()).toProvider(this.getProviderInstance()));
    }

    @Override
    public String toString() {
        return new ToStringBuilder(ProviderInstanceBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("scope", this.getScoping()).add("provider", this.providerInstance).toString();
    }
}

