/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.CommentParser;
import DTDDoc.DtdXhtmlRenderer;
import DTDDoc.ElementTreeBuilder;
import DTDDoc.ExtendedDTD;
import DTDDoc.Logger;
import DTDDoc.SystemLogger;
import DTDDoc.Tools;
import com.wutka.dtd.DTDAny;
import com.wutka.dtd.DTDAttlist;
import com.wutka.dtd.DTDAttribute;
import com.wutka.dtd.DTDCardinal;
import com.wutka.dtd.DTDChoice;
import com.wutka.dtd.DTDComment;
import com.wutka.dtd.DTDContainer;
import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDElement;
import com.wutka.dtd.DTDEmpty;
import com.wutka.dtd.DTDEntity;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDItem;
import com.wutka.dtd.DTDMixed;
import com.wutka.dtd.DTDName;
import com.wutka.dtd.DTDNotation;
import com.wutka.dtd.DTDNotationList;
import com.wutka.dtd.DTDPCData;
import com.wutka.dtd.DTDProcessingInstruction;
import com.wutka.dtd.DTDSequence;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.Collator;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class DTDCommenter {
    private Logger log;
    private boolean getAroundNetBeanComments;
    private boolean showHiddenTags;
    private boolean showFixmeTags;
    public static final String VERSION;
    private File sourceDir = null;
    private File destDir = null;
    public static final char BEGIN_TAG = '@';
    public static final String COMMENT_TAG = "@comment";
    public static final String ATTR_COMMENT_TAG = "@attr";
    public static final String FIXME_TAG = "@fixme";
    public static final String EXAMPLE_TAG = "@example";
    public static final String HIDDEN_TAG = "@hidden";
    public static final String ROOT_TAG = "@root";
    public static final String TITLE_TAG = "@title";
    public static final String DOCTYPE_TAG = "@doctype";
    public static final char CODE_SEPARATOR_DEPRECATED = '\u00a7';
    public static final char CODE_SEPARATOR = '%';
    private static final String CSS_FILENAME = "DTDDocStyle.css";
    private static final String DTREE_CSS_FILENAME = "dtreeStyle.css";
    private SortedMap elementsIndex = new TreeMap(Collator.getInstance());

    public DTDCommenter() {
        this(new SystemLogger());
    }

    public DTDCommenter(Logger log) {
        this.log = log;
    }

    private String getRelativePath(File origin) throws IOException {
        String srcDir = this.sourceDir.getCanonicalPath();
        String fullPath = origin.getCanonicalPath();
        if (fullPath.startsWith(srcDir)) {
            return fullPath.substring(srcDir.length() + 1);
        }
        return fullPath;
    }

    private void mkdestdirsRelativePath(File srcFile) throws IOException {
        String fullRelativePath = this.getRelativePath(srcFile);
        int lastSeparator = fullRelativePath.lastIndexOf(File.separatorChar);
        if (lastSeparator >= 0) {
            String relativePath = fullRelativePath.substring(0, lastSeparator);
            File dirToMake = new File(this.destDir, relativePath);
            dirToMake.mkdirs();
        }
    }

    private static boolean isFlat(DTDItem node) {
        if (node instanceof DTDContainer) {
            Iterator items = ((DTDContainer)node).getItemsVec().iterator();
            while (items.hasNext()) {
                DTDItem item = (DTDItem)items.next();
                if (!(item instanceof DTDChoice)) continue;
                return true;
            }
        }
        return false;
    }

    private String getHREFToParents(ExtendedDTD dtd, DTDElement e) {
        Iterator i = dtd.getParents(e.getName()).iterator();
        StringBuffer buffer = new StringBuffer();
        while (i.hasNext()) {
            DTDElement p = (DTDElement)i.next();
            buffer.append(this.getInternalHREF(dtd, p));
            if (!i.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    public String getInternalHREF(ExtendedDTD dtd, DTDElement element) {
        if (element != null) {
            return "<a href='#" + ExtendedDTD.getUniqueId(element) + "'>" + element.getName() + "</a>";
        }
        this.log.error("Can't build a HREF to a null element");
        return "";
    }

    public String getExternalHREF(ExtendedDTD dtd, DTDElement element, String text) throws IOException {
        return "<a href='" + this.newURITo(dtd, element).toString() + "'>" + text + "</a>";
    }

    public String getExternalHREF(ExtendedDTD dtd, String elementName, String text) throws IOException {
        return this.getExternalHREF(dtd, dtd.getElementByName(elementName), text);
    }

    public String getDTDBaseURI(ExtendedDTD dtd) {
        try {
            return (this.getRelativePath(dtd.getSystemPath()) + ".html").replace(File.separatorChar, '/');
        }
        catch (IOException ex) {
            this.log.error("Unable to make a relative path to DTD: " + dtd.getSystemPath(), ex);
            return null;
        }
    }

    private URI toURI(String uri) {
        try {
            return new URI(uri.replace(File.separatorChar, '/'));
        }
        catch (URISyntaxException ex) {
            this.log.error("Unable to create a URI out of the string '" + uri + "'.", ex);
            return null;
        }
    }

    public URI newURITo(ExtendedDTD dtd) {
        return this.toURI(this.getDTDBaseURI(dtd));
    }

    public URI newURITo(ExtendedDTD dtd, DTDElement element) {
        return this.toURI(this.getDTDBaseURI(dtd) + '#' + ExtendedDTD.getUniqueId(element));
    }

    public URI newURITo(ExtendedDTD dtd, DTDAttlist list, DTDAttribute attribute) {
        return this.toURI(this.getDTDBaseURI(dtd) + '#' + ExtendedDTD.getUniqueId(list, attribute));
    }

    public URI newURITo(ExtendedDTD dtd, DTDElement element, DTDAttribute attribute) {
        return this.toURI(this.getDTDBaseURI(dtd) + '#' + ExtendedDTD.getUniqueId(element, attribute));
    }

    public char cardinalToChar(DTDCardinal cardinal) {
        if (cardinal == DTDCardinal.NONE) {
            return '1';
        }
        if (cardinal == DTDCardinal.OPTIONAL) {
            return '?';
        }
        if (cardinal == DTDCardinal.ZEROMANY) {
            return '*';
        }
        if (cardinal == DTDCardinal.ONEMANY) {
            return '+';
        }
        this.log.error("Unrecognized cardinality! " + cardinal);
        return 'x';
    }

    private SortedSet collectChildrenNames(DTDItem child, String context, ExtendedDTD dtd) throws IOException {
        if (child instanceof DTDContainer) {
            Iterator items = ((DTDContainer)child).getItemsVec().iterator();
            context = context + this.cardinalToChar(((DTDContainer)child).getCardinal());
            if (child instanceof DTDChoice) {
                context = context + '|';
            } else if (child instanceof DTDSequence) {
                context = context + ',';
            } else if (child instanceof DTDMixed) {
                context = context + '|';
            }
            SortedSet names = null;
            while (items.hasNext()) {
                DTDItem item = (DTDItem)items.next();
                SortedSet s = this.collectChildrenNames(item, context, dtd);
                if (names != null && s != null) {
                    names.addAll(s);
                    continue;
                }
                names = s;
            }
            return names;
        }
        if (child instanceof DTDName) {
            NameInfo ni = new NameInfo((DTDName)child, context + this.cardinalToChar(((DTDName)child).getCardinal()));
            TreeSet<NameInfo> singleName = new TreeSet<NameInfo>();
            singleName.add(ni);
            return singleName;
        }
        if (!(child instanceof DTDPCData)) {
            this.log.error("showChildrenHelper(): Unsupported child " + child.getClass().getName());
            return null;
        }
        return null;
    }

    private void showChildrenHelper_print(NameInfo elementName, PrintWriter out, ExtendedDTD dtd) {
        DTDElement element = dtd.getElementByName(elementName.getName());
        out.print("<tr>");
        out.print("<td>");
        if (element == null) {
            this.log.warn("'" + elementName.getName() + "' element is " + "undefined in " + dtd.getSystemPath());
            out.print(elementName.getName());
        } else {
            out.print(this.getInternalHREF(dtd, element));
        }
        out.print("</td>");
        if (element != null) {
            out.print("<td>");
            out.print(elementName.getCardinality());
            out.print("</td>");
            out.println("</tr>");
        }
    }

    private void showChildren(DTDElement element, PrintWriter out, ExtendedDTD dtd) throws IOException {
        String summary = "&lt;" + element.getName() + "&gt;'s children";
        out.println("<table summary=\"" + summary + "\">");
        out.println("<thead>");
        out.println("<tr><th class='title' colspan='2'>" + summary + "</th></tr>");
        out.println("<tr><th colspan='2' height='1' class='ruler'></th></tr>");
        out.print("<tr>");
        out.print("<th class='subtitle'>Name</th>");
        out.print("<th class='subtitle'>Cardinality</th>");
        out.println("</tr>");
        out.println("<tr><th colspan='2' height='1' class='ruler'></th></tr>");
        out.println("</thead>");
        out.print("<tbody>");
        SortedSet names = this.collectChildrenNames(element.getContent(), "", dtd);
        Iterator i = names.iterator();
        while (i.hasNext()) {
            this.showChildrenHelper_print((NameInfo)i.next(), out, dtd);
        }
        out.print("</tbody>");
        out.print("</table>");
    }

    private static String getAttributeValues(DTDAttribute attr) {
        if (attr.getType() instanceof DTDNotationList) {
            DTDNotationList e = (DTDNotationList)attr.getType();
            return Tools.join(e.getItems(), ", ");
        }
        if (attr.getType() instanceof DTDEnumeration) {
            DTDEnumeration e = (DTDEnumeration)attr.getType();
            return Tools.join(e.getItems(), ", ");
        }
        if (attr.getType() instanceof String) {
            return "<i>Match the " + attr.getType() + " rules.</i>";
        }
        return "unknown attribute type " + attr.getType();
    }

    private static boolean isCDATA(DTDAttribute attr) {
        return "CDATA".equals(attr.getType());
    }

    private void showAttributes(DTDElement element, PrintWriter out, ExtendedDTD dtd) {
        String summary = "&lt;" + element.getName() + "&gt;'s attributes";
        out.print("<table  summary=\"" + summary + "\">");
        out.println("<tr>");
        out.println("<th class='title' colspan='3'>" + summary + "</th>");
        out.println("</tr>");
        out.println("<tr><th colspan='3' height='1' class='ruler'></th></tr>");
        out.println("<tr>");
        out.print("<th class='subtitle'>Name</th>");
        out.print("<th class='subtitle'>Values</th>");
        out.print("<th class='subtitle'>Default</th>");
        out.println("</tr>");
        out.println("<tr><th colspan='3' height='1' class='ruler'></th></tr>");
        List attributes = Tools.enumerationToList(element.attributes.keys());
        Collections.sort(attributes, Collator.getInstance());
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            DTDAttribute attr = (DTDAttribute)element.attributes.get(name);
            out.print("<tr>");
            out.print("<td>");
            out.print("<a href='#" + ExtendedDTD.getUniqueId(dtd.locateAttributesList(attr), attr) + "'>");
            out.print(name + "</a></td>");
            out.print("<td>");
            if (!DTDCommenter.isCDATA(attr)) {
                out.print(DTDCommenter.getAttributeValues(attr));
            }
            out.print("</td>");
            out.print("<td>");
            if (attr.defaultValue != null) {
                out.print(attr.defaultValue);
            }
            out.print("</td>");
            out.print("</tr>");
        }
        out.print("</table>");
    }

    private static void showElementTitle(String left, String right, PrintWriter out, String titleSummary) {
        DTDCommenter.showTitle(false, left, right, out, titleSummary);
    }

    private static void showAttributeTitle(String left, String right, PrintWriter out, String titleSummary) {
        DTDCommenter.showTitle(true, left, right, out, titleSummary);
    }

    private static void showTitle(boolean forAttribute, String left, String right, PrintWriter out, String titleSummary) {
        out.print("<br />");
        out.println("<table class='" + (forAttribute ? "attributeTitle" : "elementTitle") + "' summary=\"" + titleSummary + "\"><tr><td class='" + (forAttribute ? "leftAttributeTitle" : "leftElementTitle") + "'>");
        out.print(left);
        out.println("</td><td class='" + (forAttribute ? "rightAttributeTitle" : "rightElementTitle") + "'>");
        if (right != null) {
            out.println(right);
        }
        out.println("</td></tr></table>");
    }

    private void showAttributesList(DTDAttlist dtdAttList, PrintWriter out, ExtendedDTD dtd) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(dtdAttList.getAttribute(0).getName());
        for (int i = 1; i < dtdAttList.getAttribute().length; ++i) {
            buffer.append(", ");
            buffer.append(dtdAttList.getAttribute(i).getName());
        }
        String s = buffer.toString();
        String a = "Attribute";
        if (dtdAttList.getAttribute().length > 1) {
            a = a + "s";
        }
        a = a + " of " + this.getInternalHREF(dtd, dtd.getElementByName(dtdAttList.getName()));
        DTDCommenter.showAttributeTitle(s, a, out, s);
    }

    private Set parseDTDFiles(Set filePaths) throws IOException {
        HashSet<ExtendedDTD> dtds = new HashSet<ExtendedDTD>();
        Iterator it = filePaths.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            this.log.info("Parsing '" + f + "'...");
            dtds.add(new ExtendedDTD(f, this.log, this.getAroundNetBeanComments));
        }
        return dtds;
    }

    public void makeTOC(Set dtds, String docTitle) throws IOException {
        File tocPath = new File(this.destDir, "toc.html");
        this.log.info("Making the table of content in '" + tocPath.getName() + "'...");
        OutputStreamWriter htmlFile = new OutputStreamWriter(new FileOutputStream(tocPath));
        PrintWriter out = new PrintWriter(htmlFile);
        DateFormat dateFormatter = DateFormat.getDateInstance(2);
        String today = Tools.escapeHTMLUnicode(dateFormatter.format(new Date()), false);
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        out.println("<html><head>");
        out.println("<meta http-equiv='CONTENT-TYPE' content='text/html' />");
        out.println("<link rel='StyleSheet' href='DTDDocStyle.css' type='text/css' media='screen' />");
        out.println("<link rel='StyleSheet' href='dtreeStyle.css' type='text/css' media='screen' />");
        ElementTreeBuilder.generateJavascriptSetup(out);
        out.println("<title>" + docTitle + ", " + today + "</title>");
        out.println("</head><body>");
        out.println("<h1 class='TOCTitle'>" + docTitle + "</h1>");
        out.println("<h2 class='TOCTitle'>" + today + "</h2>");
        out.println("<a href='elementsIndex.html' target='detail'>Elements' index</a><hr />");
        ElementTreeBuilder builder = new ElementTreeBuilder(out, this, dtds, this.log);
        builder.generateTree();
        out.println("</body></html>");
        out.close();
        String[] imageNames = new String[]{"empty.gif", "join.gif", "joinbottom.gif", "line.gif", "minus.gif", "minusbottom.gif", "plus.gif", "plusbottom.gif"};
        File imgPath = new File(this.destDir, "img");
        imgPath.mkdirs();
        for (int i = 0; i < imageNames.length; ++i) {
            Tools.copyFromResource("/resources/img/" + imageNames[i], new File(imgPath, imageNames[i]));
        }
        Tools.copyFromResource("/resources/cctree.js", new File(this.destDir, "cctree.js"));
    }

    private boolean isCodeFragmentSeparator(char c) {
        if (c == '\u00a7') {
            this.log.warn("Warning ! Usage of '\u00a7' as the code fragment delimiter is deprecated. Please use '%' instead.");
            return true;
        }
        return c == '%';
    }

    private static boolean isPre(String str, int ndx) {
        if ('<' != str.charAt(ndx) || ndx + "<PRE".length() >= str.length()) {
            return false;
        }
        String pre = str.substring(ndx, ndx + "<PRE".length());
        return pre.equalsIgnoreCase("<PRE");
    }

    private static boolean isPreEnd(String str, int ndx) {
        int end = ndx + "</PRE>".length();
        if (end <= str.length()) {
            String pre = str.substring(ndx, end);
            return pre.equalsIgnoreCase("</PRE>");
        }
        return false;
    }

    private static String guardHtmlCharacter(char c) {
        if (c == '<') {
            return "&lt;";
        }
        if (c == '>') {
            return "&gt;";
        }
        return String.valueOf(c);
    }

    private boolean isCharEscaped(String p, int ndx) {
        return p.charAt(ndx) == '\\' && ndx + 1 < p.length() && this.isCodeFragmentSeparator(p.charAt(ndx + 1));
    }

    private void forcePrintParagraph(String p, PrintWriter out, String titleCode) {
        if (!p.startsWith("<p>")) {
            out.print("<p>");
        }
        if (titleCode != null) {
            out.print("<span class='inTextTitle'>" + titleCode + "</span> ");
        }
        int ndx = 0;
        while (ndx < p.length()) {
            int spaces = 0;
            int linefeeds = 0;
            while (ndx < p.length() && Character.isWhitespace(p.charAt(ndx))) {
                ++spaces;
                if (p.charAt(ndx) == '\n') {
                    ++linefeeds;
                }
                ++ndx;
            }
            if (linefeeds >= 2) {
                out.print("</p><p>");
            } else if (linefeeds == 1) {
                out.println();
            } else if (spaces > 0) {
                out.print(' ');
            }
            if (ndx >= p.length()) continue;
            if (DTDCommenter.isPre(p, ndx)) {
                out.print("</p><pre");
                ndx += 4;
                while (ndx < p.length() && !DTDCommenter.isPreEnd(p, ndx)) {
                    out.print(p.charAt(ndx));
                    ++ndx;
                }
                if (ndx >= p.length()) continue;
                out.print("</pre><p>");
                ndx += 6;
                continue;
            }
            if (this.isCharEscaped(p, ndx)) {
                out.print(p.charAt(ndx + 1));
                ndx += 2;
                continue;
            }
            if (this.isCodeFragmentSeparator(p.charAt(ndx))) {
                out.print("</p><pre>");
                ++ndx;
                while (ndx < p.length()) {
                    if (this.isCharEscaped(p, ndx)) {
                        out.print(p.charAt(ndx + 1));
                        ndx += 2;
                        continue;
                    }
                    if (this.isCodeFragmentSeparator(p.charAt(ndx))) break;
                    out.print(DTDCommenter.guardHtmlCharacter(p.charAt(ndx)));
                    ++ndx;
                }
                out.print("</pre><p>");
                ++ndx;
                continue;
            }
            if ('<' == p.charAt(ndx) && !Tools.startsWithHtmlTag(p.substring(ndx))) {
                out.print("&lt;");
                ++ndx;
                continue;
            }
            out.print(p.charAt(ndx));
            ++ndx;
        }
        if (!p.endsWith("</p>")) {
            out.print("</p>");
        }
    }

    private boolean printBaseCommentTags(PrintWriter out, CommentParser cp, boolean headComment) {
        String example;
        String fixme;
        String hidden;
        String comment;
        String doctype;
        if (cp == null) {
            return false;
        }
        boolean commentShown = false;
        if (headComment && (doctype = cp.getUniqueTagValue(DOCTYPE_TAG)) != null) {
            out.println("<p><span class='inTextTitle'>Usage</span>: <code>&lt;!DOCTYPE " + doctype + "&gt;</code></p>");
            commentShown = true;
        }
        if ((comment = cp.getUniqueTagValue(COMMENT_TAG)) != null) {
            this.forcePrintParagraph(comment, out, null);
            commentShown = true;
        }
        if ((hidden = cp.getUniqueTagValue(HIDDEN_TAG)) != null && this.showHiddenTags) {
            this.forcePrintParagraph(hidden, out, null);
            commentShown = true;
        }
        if ((fixme = cp.getUniqueTagValue(FIXME_TAG)) != null && this.showFixmeTags) {
            this.forcePrintParagraph(fixme, out, "To fix:");
            commentShown = true;
        }
        if ((example = cp.getUniqueTagValue(EXAMPLE_TAG)) != null) {
            this.forcePrintParagraph(example, out, "Example:");
            commentShown = true;
        }
        return commentShown;
    }

    private void printComment(DTDComment pComment, PrintWriter out, boolean headComment) {
        CommentParser cp;
        if (pComment != null && this.printBaseCommentTags(out, cp = new CommentParser(pComment, this.log, this.getAroundNetBeanComments), headComment)) {
            return;
        }
        out.print("<p>Sorry, no documentation.</p>");
    }

    private void copyStyleSheets(File styleSheet) throws FileNotFoundException, IOException {
        Tools.copyFromResource("/resources/dtreeStyle.css", new File(this.destDir, DTREE_CSS_FILENAME));
        if (styleSheet == null) {
            Tools.copyFromResource("/resources/DTDDocStyle.css", new File(this.destDir, CSS_FILENAME));
        } else {
            Tools.copy(styleSheet, new File(this.destDir, CSS_FILENAME));
        }
    }

    private String getRelativePathTo(ExtendedDTD fromDtd, String to) throws IOException {
        if (fromDtd == null) {
            return to;
        }
        StringBuffer path = new StringBuffer();
        String relPath = this.getRelativePath(fromDtd.getSystemPath());
        for (int i = 0; i < relPath.length(); ++i) {
            if (relPath.charAt(i) != File.separatorChar) continue;
            path.append("../");
        }
        path.append(to);
        return path.toString();
    }

    private void linkToStyleSheet(ExtendedDTD dtd, PrintWriter out) throws IOException {
        String cssPath = this.getRelativePathTo(dtd, CSS_FILENAME);
        out.println("<link rel='StyleSheet' href='" + cssPath + "' type='text/css' media='screen' />");
    }

    private void showPageStart(ExtendedDTD dtd, PrintWriter out, String currentFilename) throws IOException {
        out.print("<p class='DTDSource'>");
        if (dtd == null) {
            out.print("Elements - Entities - Source");
        } else {
            String filename = dtd.getSystemPath().getName();
            out.print("<b><code>" + filename + "</code></b>: ");
            out.print("<a href='" + filename + ".html'>Elements</a> - ");
            if (dtd.getEntities().size() > 0) {
                out.print("<a href='" + filename + ".entities.html'>Entities</a>");
            } else {
                out.print("Entities");
            }
            out.print(" - <a href='" + filename + ".org.html'>Source</a>");
        }
        out.print(" | <a href='" + this.getRelativePathTo(dtd, "intro.html") + "'>Intro</a>");
        out.print(" - <a href='" + this.getRelativePathTo(dtd, "elementsIndex.html") + "'>Index</a>");
        out.print("<br /><a href='" + this.getRelativePathTo(dtd, "index.html") + "' target='_top'>FRAMES</a>");
        out.print("&nbsp;/&nbsp;<a href='" + currentFilename + "' target='_top'>NO FRAMES</a>");
        out.print("</p>");
    }

    private void showIntroduction(ExtendedDTD dtd, PrintWriter out) throws IOException {
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        out.println("<html><head>");
        out.println("<meta http-equiv='CONTENT-TYPE' content='text/html; charset=" + dtd.getEffectiveEncoding() + "' />");
        this.linkToStyleSheet(dtd, out);
        if (dtd.getTitle() != null) {
            out.print("<title>");
            out.print(dtd.getTitle());
            out.println("</title>");
        }
        out.println("</head><body>");
        this.showPageStart(dtd, out, dtd.getSystemPath().getName() + ".html");
        if (dtd.getTitle() != null) {
            out.print("<h1>");
            out.print(dtd.getTitle());
            out.println("</h1>");
        }
    }

    private void showAttributeUsage(DTDAttribute attr, PrintWriter out) {
        String possibleValues = null;
        if (DTDCommenter.getAttributeValues(attr) != null && !DTDCommenter.isCDATA(attr)) {
            possibleValues = "<span class='inTextTitle'>Possible values</span>: " + DTDCommenter.getAttributeValues(attr);
        }
        String usage = null;
        if (attr.decl == DTDDecl.REQUIRED) {
            usage = "<span class='inTextTitle'>Required</span>";
        } else if (attr.decl == DTDDecl.FIXED) {
            usage = "<span class='inTextTitle'>Fixed value:</span> " + attr.defaultValue;
        } else if (attr.defaultValue != null && attr.defaultValue.length() > 0) {
            usage = "<span class='inTextTitle'>Default value</span>: " + attr.defaultValue;
        }
        if (possibleValues != null || usage != null) {
            out.print("<p>");
            if (possibleValues != null) {
                out.print(possibleValues);
            }
            if (possibleValues != null && usage != null) {
                out.print(" - ");
            }
            if (usage != null) {
                out.print(usage);
            }
            out.print("</p>");
        }
    }

    private void documentAttributesList(ExtendedDTD dtd, DTDAttlist list, PrintWriter out, DTDComment comment) {
        if (list == null || out == null) {
            String err = "documentAttributesList: wrong argument: ";
            if (list == null) {
                err = err + "list ";
            }
            if (out == null) {
                err = err + "out ";
            }
            throw new IllegalArgumentException(err);
        }
        CommentParser cp = null;
        Map attrComments = null;
        if (comment != null) {
            cp = new CommentParser(comment, this.log, this.getAroundNetBeanComments);
            if (list.getAttribute().length > 1 && cp.getUniqueTagValue(COMMENT_TAG) != null) {
                this.log.warn("When commenting a list of attributes, use @attr instead of a regular comment.");
            }
            attrComments = cp.getMultipleTagValue(ATTR_COMMENT_TAG);
        }
        for (int i = 0; i < list.getAttribute().length; ++i) {
            String a = "Attribute of " + this.getInternalHREF(dtd, dtd.getElementByName(list.getName()));
            DTDAttribute attr = list.getAttribute(i);
            out.println("<a name='" + ExtendedDTD.getUniqueId(list, attr) + "'></a>");
            DTDCommenter.showAttributeTitle("@" + attr.getName(), a, out, attr.getName());
            String attrComment = null;
            if (attrComments != null && (attrComment = (String)attrComments.get(attr.getName())) != null) {
                this.forcePrintParagraph(attrComment, out, null);
            } else if (!this.printBaseCommentTags(out, cp, false)) {
                if ("id".equals(attr.getName())) {
                    out.print("<p>Element identifier.</p>");
                } else if ("xmlns".equals(attr.getName())) {
                    out.print("<p>XML namespace of the element.</p>");
                } else {
                    out.print("<p>Sorry, no documentation.</p>");
                    this.log.warn("UNDOCUMENTED attribute '" + attr.getName() + "' in element '" + list.getName() + "'");
                }
            }
            this.showAttributeUsage(attr, out);
        }
    }

    void showContainerModel(ExtendedDTD dtd, PrintWriter out, DTDContainer container, String sep) {
        out.print('(');
        Iterator i = container.getItemsVec().iterator();
        boolean printSep = false;
        while (i.hasNext()) {
            if (printSep) {
                out.print(sep);
            } else {
                printSep = true;
            }
            this.showElementModel(dtd, out, (DTDItem)i.next());
        }
        out.print(')');
    }

    void showElementModel(ExtendedDTD dtd, PrintWriter out, DTDItem item) {
        if (item instanceof DTDAny) {
            out.print("ANY");
        } else if (item instanceof DTDEmpty) {
            out.print("EMPTY");
        } else if (item instanceof DTDPCData) {
            out.print("#PCDATA");
        } else {
            if (item instanceof DTDName) {
                out.print(this.getInternalHREF(dtd, dtd.getElementByName((DTDName)item)));
            } else if (item instanceof DTDChoice) {
                this.showContainerModel(dtd, out, (DTDContainer)item, " | ");
            } else if (item instanceof DTDSequence) {
                this.showContainerModel(dtd, out, (DTDContainer)item, ", ");
            } else if (item instanceof DTDMixed) {
                this.showContainerModel(dtd, out, (DTDContainer)item, " | ");
            }
            if (item.getCardinal() == DTDCardinal.OPTIONAL) {
                out.print('?');
            } else if (item.getCardinal() == DTDCardinal.ZEROMANY) {
                out.print('*');
            } else if (item.getCardinal() == DTDCardinal.ONEMANY) {
                out.print('+');
            }
        }
    }

    private PrintWriter newPrintWriter(ExtendedDTD dtd, String suffix) throws IOException {
        File outputName = new File(this.destDir, this.getRelativePath(dtd.getSystemPath()) + suffix);
        Tools.makeFileDir(outputName);
        FileOutputStream outFile = new FileOutputStream(outputName);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)outFile, dtd.getEffectiveEncoding());
        return new PrintWriter(new BufferedWriter(out));
    }

    private void makeDocumentation(ExtendedDTD dtd) throws IOException {
        this.log.info("Making doc for '" + this.getRelativePath(dtd.getSystemPath()) + "' [" + dtd.getEffectiveEncoding() + "]");
        PrintWriter out = this.newPrintWriter(dtd, ".html");
        this.showIntroduction(dtd, out);
        DTDComment currentComment = null;
        boolean firstCommentImpossible = false;
        for (int i = 0; i < dtd.getItems().size(); ++i) {
            Object e = dtd.getItems().get(i);
            if (e instanceof DTDComment) {
                currentComment = (DTDComment)e;
                if (i + 1 < dtd.getItems().size() && dtd.getItems().get(i + 1) instanceof DTDComment && !firstCommentImpossible) {
                    this.printComment(currentComment, out, true);
                    out.println("<br />");
                }
                firstCommentImpossible = true;
                continue;
            }
            if (e instanceof DTDAttlist) {
                this.documentAttributesList(dtd, (DTDAttlist)e, out, currentComment);
                firstCommentImpossible = true;
                currentComment = null;
                continue;
            }
            if (e instanceof DTDElement) {
                boolean attributesToShow;
                firstCommentImpossible = true;
                DTDElement dtdElement = (DTDElement)e;
                HashSet<ExtendedDTD> declaredInDtds = (HashSet<ExtendedDTD>)this.elementsIndex.get(dtdElement.getName());
                if (declaredInDtds == null) {
                    declaredInDtds = new HashSet<ExtendedDTD>();
                    this.elementsIndex.put(dtdElement.getName(), declaredInDtds);
                }
                declaredInDtds.add(dtd);
                if (currentComment == null) {
                    this.log.warn("UNDOCUMENTED element: " + dtdElement.getName());
                }
                out.println("<a name='" + ExtendedDTD.getUniqueId(dtdElement) + "'></a>");
                String linkToParent = null;
                linkToParent = dtd.getParents(dtdElement.getName()) != null ? (dtdElement == dtd.getRootElement() ? "Root element, child of " + this.getHREFToParents(dtd, dtdElement) : "Child of " + this.getHREFToParents(dtd, dtdElement)) : "Root element";
                DTDItem item = dtdElement.getContent();
                String elementPresentation = "&lt;" + dtdElement.getName();
                if (item instanceof DTDEmpty) {
                    elementPresentation = elementPresentation + '/';
                }
                elementPresentation = elementPresentation + "&gt;";
                if (linkToParent == null) {
                    DTDCommenter.showElementTitle(elementPresentation, null, out, dtdElement.getName());
                } else {
                    DTDCommenter.showElementTitle(elementPresentation, linkToParent, out, dtdElement.getName());
                }
                this.printComment(currentComment, out, false);
                if (item instanceof DTDContainer) {
                    boolean childrenToShow;
                    attributesToShow = dtdElement.attributes != null && dtdElement.attributes.size() > 0;
                    boolean bl = childrenToShow = !(((DTDContainer)item).getItem(0) instanceof DTDPCData) || ((DTDContainer)item).getItems().length != 1;
                    if (childrenToShow || attributesToShow) {
                        out.println("<blockquote><table summary='element info'><tr>");
                    }
                    if (childrenToShow) {
                        out.print("<td class='construct'>");
                        this.showChildren(dtdElement, out, dtd);
                        out.print("</td>");
                    }
                    if (attributesToShow) {
                        out.print("<td class='construct'>");
                        this.showAttributes(dtdElement, out, dtd);
                        out.print("</td>");
                    }
                    if (childrenToShow || attributesToShow) {
                        out.println("</tr></table></blockquote>");
                    }
                    if (childrenToShow) {
                        out.print("<span class='inTextTitle'>Element's model:</span>");
                        out.print("<p class='model'>");
                        this.showElementModel(dtd, out, item);
                        out.print("</p>");
                    }
                } else if (item instanceof DTDEmpty) {
                    firstCommentImpossible = true;
                    boolean bl = attributesToShow = dtdElement.attributes != null && dtdElement.attributes.size() > 0;
                    if (attributesToShow) {
                        out.println("<blockquote>");
                        this.showAttributes(dtdElement, out, dtd);
                        out.println("</blockquote>");
                    }
                    out.print("<p class='emptyTagNote'>This element is always empty.</p>");
                } else if (item instanceof DTDAny) {
                    firstCommentImpossible = true;
                    boolean bl = attributesToShow = dtdElement.attributes != null && dtdElement.attributes.size() > 0;
                    if (attributesToShow) {
                        out.println("<blockquote>");
                        this.showAttributes(dtdElement, out, dtd);
                        out.println("</blockquote>");
                    }
                    out.print("<p class='emptyTagNote'>This element accepts any declared element as its children.</p>");
                } else {
                    out.println("type= " + item.getClass().getName() + " is unsupported !");
                }
                currentComment = null;
                continue;
            }
            if (e instanceof DTDNotation) {
                DTDNotation notation = (DTDNotation)e;
                this.log.warn("NOTATION declaration is still not supported: ignoring <!NOTATION " + notation.getName() + " ...>");
                continue;
            }
            if (e instanceof DTDEntity || e instanceof DTDElement || e instanceof DTDProcessingInstruction) continue;
            this.log.error("makeHTMLDoc(): " + e.getClass().getName() + " not supported");
        }
        out.println("</body></html>");
        out.close();
        if (dtd.getEntities().size() > 0) {
            this.makeEntitiesPage(dtd);
        }
        this.makeDTDtoHtml(dtd);
    }

    private void makeDocumentation(Set dtds) throws IOException {
        if (dtds == null) {
            this.log.warn("No DTD to make documentation for");
            return;
        }
        Iterator iter = dtds.iterator();
        while (iter.hasNext()) {
            ExtendedDTD dtd = (ExtendedDTD)iter.next();
            this.mkdestdirsRelativePath(dtd.getSystemPath());
            this.makeDocumentation(dtd);
        }
    }

    private void makeDTDtoHtml(ExtendedDTD dtd) throws IOException {
        PrintWriter pw = this.newPrintWriter(dtd, ".org.html");
        pw.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        pw.println("<html> <head>");
        pw.println("<meta http-equiv='CONTENT-TYPE' content='text/html; charset=" + dtd.getEffectiveEncoding() + "' />");
        this.linkToStyleSheet(dtd, pw);
        pw.println("<title>" + dtd.getTitle() + "</title>");
        pw.println("</head><body>");
        this.showPageStart(dtd, pw, dtd.getSystemPath().getName() + ".org.html");
        DtdXhtmlRenderer renderer = new DtdXhtmlRenderer();
        pw.print("<pre id='dtd_source'>");
        renderer.highlight(new InputStreamReader((InputStream)new FileInputStream(dtd.getSystemPath()), dtd.getEffectiveEncoding()), pw);
        pw.println("</pre>");
        pw.println("</body></html>");
        pw.close();
    }

    private void showIntro(Set dtds, String docTitle, PrintWriter out) throws IOException {
        this.showPageStart(null, out, "intro.html");
        out.println("<h1>" + docTitle + "</h1>");
        TreeMap<Object, ExtendedDTD> sortedDtds = new TreeMap<Object, ExtendedDTD>(Collator.getInstance());
        Iterator iter = dtds.iterator();
        while (iter.hasNext()) {
            ExtendedDTD dtd = (ExtendedDTD)iter.next();
            sortedDtds.put(dtd.getSystemPath().getName(), dtd);
        }
        Set keys = sortedDtds.keySet();
        out.println("<table border='1' cellspacing='0'>");
        Iterator iter2 = keys.iterator();
        while (iter2.hasNext()) {
            String filename = (String)iter2.next();
            ExtendedDTD dtd = (ExtendedDTD)sortedDtds.get(filename);
            String title = dtd.getTitle();
            out.print("<tr><td><code><a href='" + this.getRelativePath(dtd.getSystemPath()) + ".html'>" + filename + "</a></code></td>");
            out.print("<td>");
            boolean empty = true;
            if (!filename.equals(title)) {
                out.print(Tools.escapeHTMLUnicode(title, false));
                empty = false;
            }
            if (dtd.getDoctype() != null) {
                if (!empty) {
                    out.print("<br />");
                }
                out.print("<code>&lt;!DOCTYPE " + dtd.getDoctype() + "&gt;</code>");
                empty = false;
            }
            if (empty) {
                out.print("&nbsp;");
            }
            out.print("</td>");
            out.println("</tr>");
        }
        out.println("</table>");
        out.println("<p>This documentation was generated by <a href='http://dtddoc.sourceforge.net'>DTDDoc</a> " + VERSION + " !</p>");
    }

    private void makeIntroPageHtml(Set dtds, String docTitle) throws IOException {
        File introPath = new File(this.destDir, "intro.html");
        this.log.info("Making the introduction page in '" + introPath.getName() + "'...");
        OutputStreamWriter htmlFile = new OutputStreamWriter((OutputStream)new FileOutputStream(introPath), "US-ASCII");
        PrintWriter out = new PrintWriter(new BufferedWriter(htmlFile));
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        out.println("<html><head><title>DTDDoc for " + docTitle + "</title>");
        out.println("<link rel='StyleSheet' href='DTDDocStyle.css' type='text/css' media='screen' />");
        out.println("</head><body>");
        this.showIntro(dtds, docTitle, out);
        out.println("<p>Use the left menu to navigate through the DTDs !</p>");
        out.println("</body></html>");
        out.close();
    }

    private void makeIndexHtml(Set dtds, String docTitle) throws IOException {
        File indexPath = new File(this.destDir, "index.html");
        this.log.info("Making '" + indexPath.getName() + "'...");
        OutputStreamWriter htmlFile = new OutputStreamWriter((OutputStream)new FileOutputStream(indexPath), "US-ASCII");
        PrintWriter out = new PrintWriter(new BufferedWriter(htmlFile));
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">\n<html><head>\n<title>DTDDoc for " + docTitle + "</title>\n" + "<link rel='StyleSheet' href='" + CSS_FILENAME + "' type='text/css' media='screen' />" + "</head>\n" + "<frameset cols='20%, 80%'>\n" + "   <frame src='toc.html' />\n" + "   <frame src='intro.html' name='detail' />\n" + "   <noframes><body>");
        this.showIntro(dtds, docTitle, out);
        out.println("</body></noframes>\n</frameset></html>");
        out.close();
    }

    private void makeElementsIndex() throws IOException {
        File elIndex = new File(this.destDir, "elementsIndex.html");
        this.log.info("Making the elements' index '" + elIndex.getName() + "'...");
        OutputStreamWriter htmlFile = new OutputStreamWriter((OutputStream)new FileOutputStream(elIndex), "US-ASCII");
        PrintWriter out = new PrintWriter(new BufferedWriter(htmlFile));
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        out.println("<html><head><title>elements' index</title>");
        out.println("<meta http-equiv='CONTENT-TYPE' content='text/html' />");
        out.println("<link rel='StyleSheet' href='DTDDocStyle.css' type='text/css' media='screen' />");
        out.println("</head><body>");
        this.showPageStart(null, out, elIndex.getName());
        char lastLetter = ' ';
        Iterator<Object> iter = this.elementsIndex.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            char newLetter = Character.toUpperCase(name.charAt(0));
            if (newLetter == lastLetter) continue;
            lastLetter = newLetter;
            out.print("<a href='#" + lastLetter + "'>" + lastLetter + "</a> ");
        }
        out.println("<br />");
        lastLetter = ' ';
        iter = this.elementsIndex.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String name = (String)entry.getKey();
            Set dtds = (Set)entry.getValue();
            char newLetter = Character.toUpperCase(name.charAt(0));
            if (newLetter != lastLetter) {
                lastLetter = newLetter;
                out.println("<a name='" + lastLetter + "'></a>");
                out.println("<h2>" + lastLetter + "</h2>");
            }
            out.print(name + " - ");
            TreeMap<Object, ExtendedDTD> sortedDtds = new TreeMap<Object, ExtendedDTD>(Collator.getInstance());
            Iterator dtdIter = dtds.iterator();
            while (dtdIter.hasNext()) {
                ExtendedDTD dtd = (ExtendedDTD)dtdIter.next();
                sortedDtds.put(dtd.getTitle(), dtd);
            }
            Iterator sortedDtdIter = sortedDtds.entrySet().iterator();
            while (sortedDtdIter.hasNext()) {
                Map.Entry dtdEntry = sortedDtdIter.next();
                ExtendedDTD dtd = (ExtendedDTD)dtdEntry.getValue();
                String url = this.getExternalHREF(dtd, name, Tools.escapeHTMLUnicode(dtd.getTitle(), false));
                out.print(url);
                if (!sortedDtdIter.hasNext()) continue;
                out.print(", ");
            }
            if (!iter.hasNext()) continue;
            out.println("<br />");
        }
        out.println("</body></html>");
        out.close();
    }

    private void makeEntitiesPage(ExtendedDTD dtd) throws IOException {
        this.log.info("Making the entities page for " + dtd.getSystemPath().getName() + "...");
        PrintWriter out = this.newPrintWriter(dtd, ".entities.html");
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        out.println("<html><head><title>" + dtd.getSystemPath().getName() + "'s entities</title>");
        out.println("<meta http-equiv='CONTENT-TYPE' content='text/html; charset=" + dtd.getEffectiveEncoding() + "' />");
        this.linkToStyleSheet(dtd, out);
        out.println("</head><body>");
        this.showPageStart(dtd, out, dtd.getSystemPath().getName() + ".entities.html");
        out.println("<h1>Entities for " + dtd.getTitle() + "</h1>");
        out.println("<table summary='Entities'>");
        out.println("<thead><tr><th>Name</th><th>Value</th></tr></thead>");
        out.println("<tbody>");
        out.println("<tr><th colspan='2' height='1' class='ruler'></th></tr>");
        Iterator i = dtd.getEntities().values().iterator();
        while (i.hasNext()) {
            out.println("<tr>");
            DTDEntity entity = (DTDEntity)i.next();
            out.println("<td>" + entity.name + "</td>");
            out.println("<td>");
            if (entity.value != null) {
                out.println(entity.value);
            }
            if (entity.ndata != null) {
                out.println(entity.ndata);
            }
            if (entity.externalID != null) {
                out.println(entity.externalID.system + " <i>(system)</i>");
            }
            out.println("</td>");
            out.println("</tr>");
        }
        out.println("</tbody>");
        out.println("</table>");
        out.println("</body></html>");
        out.close();
    }

    public void commentDTDs(HashSet scan, File sourceDir, File destDir, boolean showHiddenTags, boolean showFixmeTags, String docTitle, File styleSheet) throws IOException, Exception {
        this.commentDTDs(scan, sourceDir, destDir, showHiddenTags, showFixmeTags, true, docTitle, styleSheet);
    }

    public void commentDTDs(Set scan, File sourceDir, File destDir, boolean showHiddenTags, boolean showFixmeTags, boolean getAroundNetBeanComments, String docTitle, File styleSheet) throws IOException {
        this.sourceDir = sourceDir;
        this.destDir = destDir;
        this.showHiddenTags = showHiddenTags;
        this.showFixmeTags = showFixmeTags;
        this.getAroundNetBeanComments = getAroundNetBeanComments;
        if (scan == null || scan.isEmpty()) {
            this.log.error("No files to process ! Please note that you have to specify which files to include with the <include> tags. There's no automatic selection of all DTD's anymore (as of 0.0.7).");
        } else {
            destDir.mkdir();
            Set parsedDTDs = this.parseDTDFiles(scan);
            this.makeDocumentation(parsedDTDs);
            this.makeIndexHtml(parsedDTDs, docTitle);
            this.makeIntroPageHtml(parsedDTDs, docTitle);
            this.makeTOC(parsedDTDs, docTitle);
            this.copyStyleSheets(styleSheet);
            this.makeElementsIndex();
        }
    }

    static {
        Package pkg = DTDCommenter.class.getPackage();
        VERSION = pkg == null ? "(unknown version)" : pkg.getImplementationVersion();
    }

    class NameInfo
    implements Comparable {
        public final DTDName name;
        public final Set contexts = new HashSet();

        public NameInfo(DTDName name, String context) {
            this.name = name;
            this.contexts.add(context);
        }

        public String getName() {
            return this.name.getValue();
        }

        public void addContext(String context) {
            this.contexts.add(context);
        }

        public String getCardinality() {
            String indexBase = "1?+*|,";
            String[] xform = new String[]{"1?+*?1", "??**??", "+*+**+", "******", "??**||", "1?+*|,"};
            int overallCardinal = -1;
            Iterator ic = this.contexts.iterator();
            while (ic.hasNext()) {
                String context = (String)ic.next();
                int i = context.length() - 1;
                int currentCardinal = "1?+*|,".indexOf(context.charAt(i));
                while (i > 0) {
                    int previous = "1?+*|,".indexOf(context.charAt(--i));
                    currentCardinal = "1?+*|,".indexOf(xform[previous].charAt(currentCardinal));
                }
                if (overallCardinal == -1) {
                    overallCardinal = currentCardinal;
                    continue;
                }
                if (overallCardinal == currentCardinal) continue;
                return "See model";
            }
            switch (overallCardinal) {
                case 0: {
                    return "Only one";
                }
                case 1: {
                    return "One or none";
                }
                case 2: {
                    return "At least one";
                }
                case 3: {
                    return "Any number";
                }
            }
            DTDCommenter.this.log.error("Something wrong happened while establishing cardinality");
            return null;
        }

        public int compareTo(Object o) {
            Collator collator = Collator.getInstance();
            String oName = ((NameInfo)o).getName();
            return collator.compare(this.getName(), oName);
        }
    }
}

