/*
 * Decompiled with CFR 0.152.
 */
package DTDDoc;

import DTDDoc.Logger;
import com.wutka.dtd.DTDComment;
import java.util.HashMap;
import java.util.Map;

public class CommentParser {
    private final Logger log;
    private static final char BEGIN_TAG = '@';
    private static final String COMMENT_TAG = "@comment";
    private final Map values = new HashMap();

    private void parseComment(String comment, boolean getAroundNetBeanComments) {
        int start = 0;
        if (getAroundNetBeanComments && comment.startsWith("-")) {
            comment = comment.substring(1);
        }
        comment = "@comment " + comment;
        while (start < comment.length()) {
            int tagNameStart = comment.indexOf(64, start);
            int tagNameEnd = comment.indexOf(32, tagNameStart);
            if (tagNameStart >= start && tagNameEnd > tagNameStart) {
                String tagName = comment.substring(tagNameStart, tagNameEnd);
                int tagValueStart = tagNameEnd + 1;
                int tagValueEnd = comment.indexOf(64, tagValueStart);
                if (tagValueEnd == -1) {
                    tagValueEnd = comment.length();
                }
                if (tagValueEnd > tagValueStart && comment.substring(tagValueStart, tagValueEnd).trim().length() > 0) {
                    String tagValue = comment.substring(tagValueStart, tagValueEnd).trim();
                    this.putTagValue(tagName, tagValue);
                } else if (!COMMENT_TAG.equals(tagName)) {
                    this.log.warn("The tag " + tagName + " can not be empty.");
                }
                start = tagNameEnd + 1;
                continue;
            }
            start = comment.length();
        }
    }

    public String getUniqueTagValue(String tagName) {
        Object v = this.values.get(tagName);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        if (v instanceof Map) {
            this.log.warn("Expected a unique value for tag @" + tagName);
            return null;
        }
        this.log.error("Internal error, unexpected type for tag @" + tagName + "'s value.");
        return null;
    }

    public Map getMultipleTagValue(String tagName) {
        Object v = this.values.get(tagName);
        if (v == null) {
            return null;
        }
        if (v instanceof Map) {
            return (Map)v;
        }
        if (v instanceof String) {
            this.log.warn("Expected a multiple value for tag @" + tagName);
            return null;
        }
        this.log.error("Unexpected type for tag @" + tagName + "'s value.");
        return null;
    }

    private void putTagValue(String name, String content) {
        if (name == null) {
            throw new IllegalArgumentException("putTagValue(): null tag name !");
        }
        if ("@attr".equalsIgnoreCase(name)) {
            if (content == null) {
                throw new IllegalArgumentException("putTagValue(): content null for " + name + " !");
            }
            String key = null;
            String value = null;
            int firstSpaceIndex = content.indexOf(32);
            if (firstSpaceIndex == -1 || firstSpaceIndex + 1 >= content.length()) {
                this.log.warn("The tag " + name + " requires a key and a value !");
                return;
            }
            key = content.substring(0, firstSpaceIndex);
            value = content.substring(firstSpaceIndex + 1, content.length());
            HashMap<String, String> current = (HashMap<String, String>)this.values.get(name);
            if (current == null) {
                current = new HashMap<String, String>();
                this.values.put(name, current);
            }
            current.put(key, value);
        } else {
            this.values.put(name, content);
        }
    }

    public CommentParser(DTDComment comment, Logger log, boolean getAroundNetBeanComments) {
        this.log = log;
        this.parseComment(comment.getText(), getAroundNetBeanComments);
    }
}

