/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.doclava.Comment;
import com.google.doclava.ContainerInfo;
import com.google.doclava.Project;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedTagInfo
extends TagInfo {
    private final ContainerInfo mContainer;
    private String mCommentText;
    private Comment mComment;

    ParsedTagInfo(String name, String kind, String text, ContainerInfo base, SourcePositionInfo sp) {
        super(name, kind, text, SourcePositionInfo.findBeginning(sp, text));
        this.mContainer = base;
        this.mCommentText = text;
    }

    public ContainerInfo getContainer() {
        return this.mContainer;
    }

    @Override
    public void initVisible(Project project) {
        super.initVisible(project);
        this.mComment = new Comment(this.mCommentText, this.mContainer, this.position());
        this.mComment.initVisible(project);
    }

    public List<TagInfo> commentTags() {
        if (this.mComment == null) {
            throw new IllegalStateException("Expected initVisible() to be called first");
        }
        return this.mComment.tags();
    }

    protected void setCommentText(String comment) {
        this.mCommentText = comment;
    }

    public static <T extends ParsedTagInfo> List<TagInfo> joinTags(T[] tags) {
        ArrayList<TagInfo> result = new ArrayList<TagInfo>();
        for (T tag : tags) {
            for (TagInfo tagInfo : ((ParsedTagInfo)tag).commentTags()) {
                result.add(tagInfo);
            }
        }
        return result;
    }
}

