/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.doclava.ClassInfo;
import com.google.doclava.ContainerInfo;
import com.google.doclava.Errors;
import com.google.doclava.FieldInfo;
import com.google.doclava.MemberInfo;
import com.google.doclava.MethodInfo;
import com.google.doclava.PackageInfo;
import com.google.doclava.Project;
import com.google.doclava.SourcePositionInfo;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinkReference {
    public String text;
    public String kind;
    public String label;
    public String href;
    public boolean isLocal = true;
    public PackageInfo packageInfo;
    public ClassInfo classInfo;
    public MemberInfo memberInfo;
    public String referencedMemberName;
    public boolean good;
    private static final Pattern HREF_PATTERN = Pattern.compile("^<a href=\"([^\"]*)\">([^<]*)</a>[ \n\r\t]*$", 2);
    private static final Pattern QUOTE_PATTERN = Pattern.compile("^\"([^\"]*)\"[ \n\r\t]*$");

    /*
     * Enabled aggressive block sorting
     */
    public static LinkReference parse(String text, ContainerInfo base, SourcePositionInfo pos, boolean printOnErrors, Project project) {
        String mem;
        String ref;
        char c;
        int index;
        LinkReference result = new LinkReference();
        result.text = text;
        int len = text.length();
        int pairs = 0;
        int pound = -1;
        block13: for (index = 0; index < len; ++index) {
            char c2 = text.charAt(index);
            switch (c2) {
                case '(': {
                    ++pairs;
                    break;
                }
                case '[': {
                    ++pairs;
                    break;
                }
                case ')': {
                    --pairs;
                    break;
                }
                case ']': {
                    --pairs;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (pairs != 0) break;
                    break block13;
                }
                case '#': {
                    if (pound >= 0) break;
                    pound = index;
                }
            }
        }
        if (index == len && pairs != 0) {
            Errors.error(Errors.UNRESOLVED_LINK, pos, "unable to parse link/see tag: " + text.trim());
            return result;
        }
        int linkend = index;
        while (index < len && ((c = text.charAt(index)) == ' ' || c == '\t' || c == '\r' || c == '\n')) {
            ++index;
        }
        result.label = text.substring(index);
        if (pound == 0) {
            ref = null;
            mem = text.substring(1, linkend);
        } else if (pound > 0) {
            ref = text.substring(0, pound);
            mem = text.substring(pound + 1, linkend);
        } else {
            ref = text.substring(0, linkend);
            mem = null;
        }
        String[] params = null;
        String[] paramDimensions = null;
        boolean varargs = false;
        if (mem != null && (index = mem.indexOf(40)) > 0) {
            ArrayList<String> paramList = new ArrayList<String>();
            ArrayList<String> paramDimensionList = new ArrayList<String>();
            len = mem.length();
            int start = index + 1;
            boolean START = false;
            boolean TYPE = true;
            int NAME = 2;
            int dimension = 0;
            int arraypair = 0;
            int state = 0;
            int typestart = 0;
            int typeend = -1;
            block15: for (int i = start; i < len; ++i) {
                char c3 = mem.charAt(i);
                switch (state) {
                    case 0: {
                        if (c3 == ' ' || c3 == '\t' || c3 == '\r' || c3 == '\n') continue block15;
                        state = 1;
                        typestart = i;
                        continue block15;
                    }
                    case 1: {
                        if (c3 == '.') {
                            if (mem.length() <= i + 2 || mem.charAt(i + 1) != '.' || mem.charAt(i + 2) != '.') continue block15;
                            if (typeend < 0) {
                                typeend = i;
                            }
                            varargs = true;
                            continue block15;
                        }
                        if (c3 == '[') {
                            if (typeend < 0) {
                                typeend = i;
                            }
                            ++dimension;
                            ++arraypair;
                            continue block15;
                        }
                        if (c3 == ']') {
                            --arraypair;
                            continue block15;
                        }
                        if (c3 == ' ' || c3 == '\t' || c3 == '\r' || c3 == '\n') {
                            if (typeend >= 0) continue block15;
                            typeend = i;
                            continue block15;
                        }
                        if (typeend < 0 && c3 != ')' && c3 != ',') continue block15;
                        if (typeend < 0) {
                            typeend = i;
                        }
                        String s = mem.substring(typestart, typeend);
                        paramList.add(s);
                        s = "";
                        for (int j = 0; j < dimension; ++j) {
                            s = s + "[]";
                        }
                        paramDimensionList.add(s);
                        state = 0;
                        typeend = -1;
                        dimension = 0;
                        if (c3 == ',' || c3 == ')') {
                            state = 0;
                            continue block15;
                        }
                        state = 2;
                        continue block15;
                    }
                    case 2: {
                        if (c3 != ',' && c3 != ')') continue block15;
                        state = 0;
                        continue block15;
                    }
                }
            }
            params = paramList.toArray(new String[paramList.size()]);
            paramDimensions = paramDimensionList.toArray(new String[paramList.size()]);
            mem = mem.substring(0, index);
        }
        ClassInfo cl = null;
        if (base instanceof ClassInfo) {
            cl = (ClassInfo)base;
        }
        if (ref == null) {
            if (cl != null) {
                result.classInfo = cl;
            }
        } else {
            if (cl != null) {
                result.classInfo = cl.extendedFindClass(ref);
                if (result.classInfo == null) {
                    result.classInfo = cl.findClass(ref, project);
                }
                if (result.classInfo == null) {
                    result.classInfo = cl.findInnerClass(ref, project);
                }
            }
            if (result.classInfo == null) {
                result.classInfo = project.getClassByName(ref);
            }
            if (result.classInfo == null) {
                result.packageInfo = project.getPackage(ref);
            }
        }
        if (result.classInfo != null && mem != null) {
            MethodInfo method;
            FieldInfo field;
            if (params == null && (field = result.classInfo.findField(mem)) != null) {
                result.classInfo = field.containingClass();
                result.memberInfo = field;
            }
            if (result.memberInfo == null && (method = result.classInfo.findMethod(mem, params, paramDimensions, varargs)) != null) {
                result.classInfo = method.containingClass();
                result.memberInfo = method;
            }
        }
        result.referencedMemberName = mem;
        if (params != null) {
            result.referencedMemberName = result.referencedMemberName + '(';
            len = params.length;
            if (len > 0) {
                --len;
                for (int i = 0; i < len; ++i) {
                    result.referencedMemberName = result.referencedMemberName + params[i] + (String)paramDimensions[i] + ", ";
                }
                result.referencedMemberName = result.referencedMemberName + params[len] + (String)paramDimensions[len];
            }
            result.referencedMemberName = result.referencedMemberName + ")";
        }
        MethodInfo method = null;
        boolean skipHref = false;
        if (result.memberInfo != null && result.memberInfo.isExecutable()) {
            method = (MethodInfo)result.memberInfo;
        }
        if (text.startsWith("\"")) {
            Matcher matcher = QUOTE_PATTERN.matcher(text);
            if (!matcher.matches()) {
                Errors.error(Errors.UNRESOLVED_LINK, pos, "unbalanced quoted link/see tag: " + text.trim());
                result.makeError();
                return result;
            }
            skipHref = true;
            result.label = matcher.group(1);
            result.kind = "@seeJustLabel";
        } else if (text.startsWith("<")) {
            Matcher matcher = HREF_PATTERN.matcher(text);
            if (!matcher.matches()) {
                Errors.error(Errors.UNRESOLVED_LINK, pos, "invalid <a> link/see tag: " + text.trim());
                result.makeError();
                return result;
            }
            result.isLocal = false;
            result.href = matcher.group(1);
            result.label = matcher.group(2);
            result.kind = "@seeHref";
        } else if (result.packageInfo != null) {
            result.href = result.packageInfo.htmlPage();
            result.isLocal = result.packageInfo.isDefinedLocally();
            if (result.label.length() == 0) {
                result.label = result.packageInfo.name();
            }
        } else if (result.classInfo != null && result.referencedMemberName == null) {
            if (result.label.length() == 0) {
                result.label = result.classInfo.name();
            }
            result.href = result.classInfo.htmlPage();
            result.isLocal = result.classInfo.isDefinedLocally();
        } else if (result.memberInfo != null) {
            ClassInfo containing = result.memberInfo.containingClass();
            if (result.memberInfo.isExecutable() && result.referencedMemberName.indexOf(40) < 0) {
                result.referencedMemberName = result.referencedMemberName + method.flatSignature();
            }
            if (result.label.length() == 0) {
                result.label = result.referencedMemberName;
            }
            result.href = containing.htmlPage() + '#' + result.memberInfo.anchor();
            result.isLocal = containing.isDefinedLocally();
        }
        if (result.href == null && !skipHref) {
            if (printOnErrors && (base == null || base.checkLevel())) {
                Errors.error(Errors.UNRESOLVED_LINK, pos, "Unresolved link/see tag \"" + text.trim() + "\" in " + (base != null ? base.qualifiedName() : "[null]"));
            }
            result.makeError();
        } else if (result.memberInfo != null && !result.memberInfo.checkLevel()) {
            if (printOnErrors && (base == null || base.checkLevel())) {
                Errors.error(Errors.HIDDEN_LINK, pos, "Link to hidden member: " + text.trim());
                result.href = null;
            }
            result.kind = "@seeJustLabel";
        } else if (result.classInfo != null && !result.classInfo.checkLevel()) {
            if (printOnErrors && (base == null || base.checkLevel())) {
                Errors.error(Errors.HIDDEN_LINK, pos, "Link to hidden class: " + text.trim() + " label=" + result.label);
                result.href = null;
            }
            result.kind = "@seeJustLabel";
        } else if (result.packageInfo != null && !result.packageInfo.checkLevel()) {
            if (printOnErrors && (base == null || base.checkLevel())) {
                Errors.error(Errors.HIDDEN_LINK, pos, "Link to hidden package: " + text.trim());
                result.href = null;
            }
            result.kind = "@seeJustLabel";
        }
        result.good = true;
        return result;
    }

    public boolean checkLevel() {
        if (this.memberInfo != null) {
            return this.memberInfo.checkLevel();
        }
        if (this.classInfo != null) {
            return this.classInfo.checkLevel();
        }
        if (this.packageInfo != null) {
            return this.packageInfo.checkLevel();
        }
        return false;
    }

    private void makeError() {
        this.label = this.text.trim();
        this.kind = "@seeJustLabel";
    }

    private LinkReference() {
    }
}

