/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.common.collect.Iterables;
import com.google.doclava.AttrTagInfo;
import com.google.doclava.CodeTagInfo;
import com.google.doclava.ContainerInfo;
import com.google.doclava.Doclava;
import com.google.doclava.Errors;
import com.google.doclava.LiteralTagInfo;
import com.google.doclava.ParamTagInfo;
import com.google.doclava.ParsedTagInfo;
import com.google.doclava.Project;
import com.google.doclava.SampleTagInfo;
import com.google.doclava.SeeTagInfo;
import com.google.doclava.SourcePositionInfo;
import com.google.doclava.TagInfo;
import com.google.doclava.TextTagInfo;
import com.google.doclava.ThrowsTagInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comment {
    static final Pattern LEADING_WHITESPACE = Pattern.compile("^[ \t\n\r]*(.*)$", 32);
    static final Pattern TAG_BEGIN = Pattern.compile("[\r\n][\r\n \t]*@", 32);
    static final Pattern TAG = Pattern.compile("(@[^ \t\r\n]+)[ \t\r\n]+(.*)", 32);
    static final Pattern INLINE_TAG = Pattern.compile("(.*?)\\{(@[^ \t\r\n\\}]+)[ \t\r\n]*(.*?)\\}", 32);
    static final Pattern FIRST_SENTENCE = Pattern.compile("((.*?)\\.)[ \t\r\n\\<](.*)", 32);
    private static final String[] KNOWN_TAGS = new String[]{"@author", "@since", "@version", "@deprecated", "@undeprecate", "@docRoot", "@sdkCurrent", "@inheritDoc", "@more", "@samplecode", "@sample", "@include", "@serial", "@com.intel.drl.spec_ref", "@ar.org.fitc.spec_ref"};
    boolean mInitialized;
    int mHidden = -1;
    int mDocOnly = -1;
    int mDeprecated = -1;
    String mText;
    ContainerInfo mBase;
    SourcePositionInfo mPosition;
    List<TagInfo> mInlineTags;
    List<ParamTagInfo> mParamTags;
    List<SeeTagInfo> mSeeTags;
    List<ThrowsTagInfo> mThrowsTags;
    List<TagInfo> mBriefTags;
    List<TagInfo> mReturnTags;
    List<TagInfo> mDeprecatedTags;
    List<TagInfo> mUndeprecateTags;
    List<AttrTagInfo> mAttrTags;
    ArrayList<TagInfo> mInlineTagsList = new ArrayList();
    ArrayList<TagInfo> mTagsList = new ArrayList();
    ArrayList<ParamTagInfo> mParamTagsList = new ArrayList();
    ArrayList<SeeTagInfo> mSeeTagsList = new ArrayList();
    ArrayList<ThrowsTagInfo> mThrowsTagsList = new ArrayList();
    ArrayList<TagInfo> mBriefTagsList = new ArrayList();
    ArrayList<ParsedTagInfo> mReturnTagsList = new ArrayList();
    ArrayList<ParsedTagInfo> mDeprecatedTagsList = new ArrayList();
    ArrayList<TagInfo> mUndeprecateTagsList = new ArrayList();
    ArrayList<AttrTagInfo> mAttrTagsList = new ArrayList();

    public Comment(String text, ContainerInfo base, SourcePositionInfo sp) {
        this.mText = text;
        this.mBase = base;
        this.mPosition = SourcePositionInfo.findBeginning(sp, text);
    }

    private void parseRegex(String text) {
        int end;
        Matcher m = LEADING_WHITESPACE.matcher(text);
        m.matches();
        text = m.group(1);
        m = TAG_BEGIN.matcher(text);
        int start = 0;
        while (m.find()) {
            end = m.start();
            this.tag(text, start, end);
            start = m.end() - 1;
        }
        end = text.length();
        this.tag(text, start, end);
    }

    private void tag(String text, int start, int end) {
        SourcePositionInfo pos = SourcePositionInfo.add(this.mPosition, this.mText, start);
        if (start >= 0 && end > 0 && end - start > 0) {
            Matcher m = TAG.matcher(text = text.substring(start, end));
            if (m.matches()) {
                this.tag(m.group(1), m.group(2), false, pos);
            } else {
                m = INLINE_TAG.matcher(text);
                start = 0;
                while (m.find()) {
                    String tagname = m.group(2);
                    String tagvalue = m.group(3);
                    this.tag(null, m.group(1), true, pos);
                    this.tag(tagname, tagvalue, true, pos);
                    start = m.end();
                }
                int len = text.length();
                if (start != len) {
                    this.tag(null, text.substring(start), true, pos);
                }
            }
        }
    }

    private void tag(String name, String text, boolean isInline, SourcePositionInfo pos) {
        if (name == null) {
            this.mInlineTagsList.add(new TextTagInfo("Text", "Text", text, pos));
        } else if (name.equals("@param")) {
            this.mParamTagsList.add(new ParamTagInfo("@param", "@param", text, this.mBase, pos));
        } else if (name.equals("@see")) {
            this.mSeeTagsList.add(new SeeTagInfo("@see", "@see", text, this.mBase, pos));
        } else if (name.equals("@link") || name.equals("@linkplain")) {
            this.mInlineTagsList.add(new SeeTagInfo(name, "@see", text, this.mBase, pos));
        } else if (name.equals("@throws") || name.equals("@exception")) {
            this.mThrowsTagsList.add(new ThrowsTagInfo("@throws", "@throws", text, this.mBase, pos));
        } else if (name.equals("@return")) {
            this.mReturnTagsList.add(new ParsedTagInfo("@return", "@return", text, this.mBase, pos));
        } else if (name.equals("@deprecated")) {
            if (text.length() == 0) {
                Errors.error(Errors.MISSING_COMMENT, pos, "@deprecated tag with no explanatory comment");
                text = "No replacement.";
            }
            this.mDeprecatedTagsList.add(new ParsedTagInfo("@deprecated", "@deprecated", text, this.mBase, pos));
        } else if (name.equals("@literal")) {
            this.mInlineTagsList.add(new LiteralTagInfo(text, pos));
        } else if (name.equals("@code")) {
            this.mInlineTagsList.add(new CodeTagInfo(text, pos));
        } else if (!(name.equals("@hide") || name.equals("@pending") || name.equals("@doconly"))) {
            if (name.equals("@attr")) {
                AttrTagInfo tag = new AttrTagInfo("@attr", "@attr", text, this.mBase, pos);
                this.mAttrTagsList.add(tag);
                Comment c = tag.description();
                if (c != null) {
                    for (TagInfo t : c.tags()) {
                        this.mInlineTagsList.add(t);
                    }
                }
            } else if (name.equals("@undeprecate")) {
                this.mUndeprecateTagsList.add(new TextTagInfo("@undeprecate", "@undeprecate", text, pos));
            } else if (name.equals("@include") || name.equals("@sample")) {
                this.mInlineTagsList.add(new SampleTagInfo(name, "@include", text, this.mBase, pos));
            } else {
                boolean known = false;
                for (String s : KNOWN_TAGS) {
                    if (!s.equals(name)) continue;
                    known = true;
                    break;
                }
                if (!known) {
                    Errors.error(Errors.UNKNOWN_TAG, pos == null ? null : new SourcePositionInfo(pos), "Unknown tag: " + name);
                }
                TextTagInfo t = new TextTagInfo(name, name, text, pos);
                if (isInline) {
                    this.mInlineTagsList.add(t);
                } else {
                    this.mTagsList.add(t);
                }
            }
        }
    }

    private void parseBriefTags() {
        int i;
        int N = this.mInlineTagsList.size();
        int more = -1;
        for (i = 0; i < N; ++i) {
            if (!this.mInlineTagsList.get(i).name().equals("@more")) continue;
            more = i;
        }
        if (more >= 0) {
            for (i = 0; i < more; ++i) {
                this.mBriefTagsList.add(this.mInlineTagsList.get(i));
            }
        } else {
            for (i = 0; i < N; ++i) {
                Matcher m;
                TagInfo t = this.mInlineTagsList.get(i);
                if (t.name().equals("Text") && (m = FIRST_SENTENCE.matcher(t.text())).matches()) {
                    String text = m.group(1);
                    TagInfo firstSentenceTag = new TagInfo(t.name(), t.kind(), text, t.position());
                    this.mBriefTagsList.add(firstSentenceTag);
                    break;
                }
                this.mBriefTagsList.add(t);
            }
        }
    }

    public List<TagInfo> tags() {
        this.checkInitVisibleCalled();
        return this.mInlineTags;
    }

    public TagInfo[] tags(String name) {
        this.checkInitVisibleCalled();
        ArrayList<TagInfo> results = new ArrayList<TagInfo>();
        int N = this.mInlineTagsList.size();
        for (int i = 0; i < N; ++i) {
            TagInfo t = this.mInlineTagsList.get(i);
            if (!t.name().equals(name)) continue;
            results.add(t);
        }
        return results.toArray(new TagInfo[results.size()]);
    }

    public List<ParamTagInfo> paramTags() {
        this.checkInitVisibleCalled();
        return this.mParamTags;
    }

    public List<SeeTagInfo> seeTags() {
        this.checkInitVisibleCalled();
        return this.mSeeTags;
    }

    public List<ThrowsTagInfo> throwsTags() {
        this.checkInitVisibleCalled();
        return this.mThrowsTags;
    }

    public List<TagInfo> returnTags() {
        this.checkInitVisibleCalled();
        return this.mReturnTags;
    }

    public List<TagInfo> deprecatedTags() {
        this.checkInitVisibleCalled();
        return this.mDeprecatedTags;
    }

    public List<TagInfo> undeprecateTags() {
        this.checkInitVisibleCalled();
        return this.mUndeprecateTags;
    }

    public List<AttrTagInfo> attrTags() {
        this.checkInitVisibleCalled();
        return this.mAttrTags;
    }

    public List<TagInfo> briefTags() {
        this.checkInitVisibleCalled();
        return this.mBriefTags;
    }

    public boolean isHidden() {
        if (this.mHidden != -1) {
            return this.mHidden != 0;
        }
        if (Doclava.checkLevel(31)) {
            this.mHidden = 0;
            return false;
        }
        boolean b = this.mText.indexOf("@hide") >= 0 || this.mText.indexOf("@pending") >= 0;
        this.mHidden = b ? 1 : 0;
        return b;
    }

    public boolean isDocOnly() {
        if (this.mDocOnly != -1) {
            return this.mDocOnly != 0;
        }
        boolean b = this.mText != null && this.mText.indexOf("@doconly") >= 0;
        this.mDocOnly = b ? 1 : 0;
        return b;
    }

    public boolean isDeprecated() {
        if (this.mDeprecated != -1) {
            return this.mDeprecated != 0;
        }
        boolean b = this.mText != null && this.mText.indexOf("@deprecated") >= 0;
        this.mDeprecated = b ? 1 : 0;
        return b;
    }

    private void checkInitVisibleCalled() {
        if (!this.mInitialized) {
            throw new IllegalStateException("Expected initVisible() to have already been called");
        }
    }

    public void initVisible(Project project) {
        this.isHidden();
        this.isDocOnly();
        this.isDeprecated();
        if (Doclava.parseComments()) {
            this.parseRegex(this.mText);
            this.parseBriefTags();
        } else {
            this.mInlineTagsList.add(new TextTagInfo("Text", "Text", this.mText, SourcePositionInfo.add(this.mPosition, this.mText, 0)));
        }
        this.mText = null;
        this.mInitialized = true;
        for (TagInfo tagInfo : Iterables.concat(this.mSeeTagsList, this.mInlineTagsList, this.mReturnTagsList, this.mParamTagsList, this.mThrowsTagsList, this.mDeprecatedTagsList, this.mUndeprecateTagsList, this.mAttrTagsList, this.mBriefTagsList, this.mTagsList)) {
            tagInfo.initVisible(project);
        }
        this.mInlineTags = this.mInlineTagsList;
        this.mParamTags = this.mParamTagsList;
        this.mSeeTags = this.mSeeTagsList;
        this.mThrowsTags = this.mThrowsTagsList;
        this.mReturnTags = ParsedTagInfo.joinTags((ParsedTagInfo[])this.mReturnTagsList.toArray(new ParsedTagInfo[this.mReturnTagsList.size()]));
        this.mDeprecatedTags = ParsedTagInfo.joinTags((ParsedTagInfo[])this.mDeprecatedTagsList.toArray(new ParsedTagInfo[this.mDeprecatedTagsList.size()]));
        this.mUndeprecateTags = this.mUndeprecateTagsList;
        this.mAttrTags = this.mAttrTagsList;
        this.mBriefTags = this.mBriefTagsList;
        this.mParamTagsList = null;
        this.mSeeTagsList = null;
        this.mThrowsTagsList = null;
        this.mReturnTagsList = null;
        this.mDeprecatedTagsList = null;
        this.mUndeprecateTagsList = null;
        this.mAttrTagsList = null;
        this.mBriefTagsList = null;
    }
}

