/*
 * Decompiled with CFR 0.152.
 */
package com.google.doclava;

import com.google.clearsilver.jsilver.JSilver;
import com.google.clearsilver.jsilver.data.Data;
import com.google.clearsilver.jsilver.resourceloader.ClassResourceLoader;
import com.google.clearsilver.jsilver.resourceloader.CompositeResourceLoader;
import com.google.clearsilver.jsilver.resourceloader.FileSystemResourceLoader;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.doclava.AnnotationInstanceInfo;
import com.google.doclava.AnnotationValueInfo;
import com.google.doclava.ClassInfo;
import com.google.doclava.ClearPage;
import com.google.doclava.DocFile;
import com.google.doclava.DocInfo;
import com.google.doclava.Errors;
import com.google.doclava.FederationTagger;
import com.google.doclava.FieldInfo;
import com.google.doclava.Hierarchy;
import com.google.doclava.JarUtils;
import com.google.doclava.NavTree;
import com.google.doclava.PackageInfo;
import com.google.doclava.Project;
import com.google.doclava.ProjectBuilder;
import com.google.doclava.Proofread;
import com.google.doclava.SampleCode;
import com.google.doclava.SinceTagger;
import com.google.doclava.Sorter;
import com.google.doclava.Stubs;
import com.google.doclava.TagInfo;
import com.google.doclava.TodoFile;
import com.google.doclava.Visibility;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Type;
import com.sun.tools.javadoc.Main;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doclava {
    private static final String SDK_CONSTANT_ANNOTATION = "android.annotation.SdkConstant";
    private static final String SDK_CONSTANT_TYPE_ACTIVITY_ACTION = "android.annotation.SdkConstant.SdkConstantType.ACTIVITY_INTENT_ACTION";
    private static final String SDK_CONSTANT_TYPE_BROADCAST_ACTION = "android.annotation.SdkConstant.SdkConstantType.BROADCAST_INTENT_ACTION";
    private static final String SDK_CONSTANT_TYPE_SERVICE_ACTION = "android.annotation.SdkConstant.SdkConstantType.SERVICE_INTENT_ACTION";
    private static final String SDK_CONSTANT_TYPE_CATEGORY = "android.annotation.SdkConstant.SdkConstantType.INTENT_CATEGORY";
    private static final String SDK_CONSTANT_TYPE_FEATURE = "android.annotation.SdkConstant.SdkConstantType.FEATURE";
    private static final String SDK_WIDGET_ANNOTATION = "android.annotation.Widget";
    private static final String SDK_LAYOUT_ANNOTATION = "android.annotation.Layout";
    private static final int TYPE_NONE = 0;
    private static final int TYPE_WIDGET = 1;
    private static final int TYPE_LAYOUT = 2;
    private static final int TYPE_LAYOUT_PARAM = 3;
    public static final int SHOW_PUBLIC = 1;
    public static final int SHOW_PROTECTED = 3;
    public static final int SHOW_PACKAGE = 7;
    public static final int SHOW_PRIVATE = 15;
    public static final int SHOW_HIDDEN = 31;
    public static int showLevel = 3;
    public static final String javadocDir = "reference/";
    public static String assetsOutputDir = "assets";
    public static String htmlExtension;
    public static RootDoc root;
    public static ArrayList<String[]> mHDFData;
    public static Map<Character, String> escapeChars;
    public static String title;
    public static SinceTagger sinceTagger;
    public static FederationTagger federationTagger;
    private static boolean generateDocs;
    private static boolean parseComments;
    public static String apiVersion;
    public static JSilver jSilver;
    public static Project project;
    private static List<PackageInfo> sVisiblePackages;

    public static boolean checkLevel(int level) {
        return (showLevel & level) == level;
    }

    public static boolean parseComments() {
        return generateDocs || parseComments;
    }

    public static boolean checkLevel(boolean pub, boolean prot, boolean pkgp, boolean priv, boolean hidden) {
        if (hidden && !Doclava.checkLevel(31)) {
            return false;
        }
        if (pub && Doclava.checkLevel(1)) {
            return true;
        }
        if (prot && Doclava.checkLevel(3)) {
            return true;
        }
        if (pkgp && Doclava.checkLevel(7)) {
            return true;
        }
        return priv && Doclava.checkLevel(15);
    }

    public static void main(String[] args) {
        Main.execute((String[])args);
    }

    public static boolean start(RootDoc r) {
        String[][] options;
        String keepListFile = null;
        String proofreadFile = null;
        String todoFile = null;
        String sdkValuePath = null;
        ArrayList<SampleCode> sampleCodes = new ArrayList<SampleCode>();
        String stubsDir = null;
        boolean offlineMode = false;
        String apiFile = null;
        String debugStubsFile = "";
        HashSet<String> stubPackages = null;
        root = r;
        for (String[] a : options = r.options()) {
            if (a[0].equals("-d")) {
                ClearPage.outputDir = a[1];
                continue;
            }
            if (a[0].equals("-templatedir")) {
                ClearPage.addTemplateDir(a[1]);
                continue;
            }
            if (a[0].equals("-hdf")) {
                mHDFData.add(new String[]{a[1], a[2]});
                continue;
            }
            if (a[0].equals("-toroot")) {
                ClearPage.toroot = a[1];
                continue;
            }
            if (a[0].equals("-samplecode")) {
                sampleCodes.add(new SampleCode(a[1], a[2], a[3]));
                continue;
            }
            if (a[0].equals("-htmldir")) {
                ClearPage.htmlDir = a[1];
                continue;
            }
            if (a[0].equals("-title")) {
                title = a[1];
                continue;
            }
            if (a[0].equals("-werror")) {
                Errors.setWarningsAreErrors(true);
                continue;
            }
            if (a[0].equals("-error") || a[0].equals("-warning") || a[0].equals("-hide")) {
                try {
                    int level = -1;
                    if (a[0].equals("-error")) {
                        level = Errors.ERROR;
                    } else if (a[0].equals("-warning")) {
                        level = Errors.WARNING;
                    } else if (a[0].equals("-hide")) {
                        level = Errors.HIDDEN;
                    }
                    Errors.setErrorLevel(Integer.parseInt(a[1]), level);
                    continue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (a[0].equals("-keeplist")) {
                keepListFile = a[1];
                continue;
            }
            if (a[0].equals("-proofread")) {
                proofreadFile = a[1];
                continue;
            }
            if (a[0].equals("-todo")) {
                todoFile = a[1];
                continue;
            }
            if (a[0].equals("-public")) {
                showLevel = 1;
                continue;
            }
            if (a[0].equals("-protected")) {
                showLevel = 3;
                continue;
            }
            if (a[0].equals("-package")) {
                showLevel = 7;
                continue;
            }
            if (a[0].equals("-private")) {
                showLevel = 15;
                continue;
            }
            if (a[0].equals("-hidden")) {
                showLevel = 31;
                continue;
            }
            if (a[0].equals("-stubs")) {
                stubsDir = a[1];
                continue;
            }
            if (a[0].equals("-stubpackages")) {
                stubPackages = new HashSet<String>();
                for (String pkg : a[1].split(":")) {
                    stubPackages.add(pkg);
                }
                continue;
            }
            if (a[0].equals("-sdkvalues")) {
                sdkValuePath = a[1];
                continue;
            }
            if (a[0].equals("-apixml")) {
                apiFile = a[1];
                continue;
            }
            if (a[0].equals("-nodocs")) {
                generateDocs = false;
                continue;
            }
            if (a[0].equals("-parsecomments")) {
                parseComments = true;
                continue;
            }
            if (a[0].equals("-since")) {
                sinceTagger.addVersion(a[1], a[2]);
                continue;
            }
            if (a[0].equals("-offlinemode")) {
                offlineMode = true;
                continue;
            }
            if (a[0].equals("-federate")) {
                try {
                    String name = a[1];
                    URL federationURL = new URL(a[2]);
                    federationTagger.addSiteUrl(name, federationURL);
                    continue;
                }
                catch (MalformedURLException e) {
                    System.err.println("Could not parse URL for federation: " + a[1]);
                    return false;
                }
            }
            if (a[0].equals("-federationxml")) {
                String name = a[1];
                String file = a[2];
                federationTagger.addSiteXml(name, file);
                continue;
            }
            if (a[0].equals("-apiversion")) {
                apiVersion = a[1];
                continue;
            }
            if (!a[0].equals("-assetsdir")) continue;
            assetsOutputDir = a[1];
        }
        project = new ProjectBuilder().build(r);
        Stubs stubs = new Stubs();
        stubs.initVisible(stubPackages, project.allClasses());
        Doclava.initVisiblePackages();
        Doclava.initVisibleClasses(stubs.getNotStrippable());
        File currentApiFile = !generateDocs && apiFile != null ? new File(apiFile) : (generateDocs ? new File(Doclava.ensureSlash(ClearPage.outputDir) + javadocDir + "/current.xml") : null);
        stubs.writeStubsAndXml(stubsDir, currentApiFile);
        if (generateDocs && apiFile != null) {
            ClearPage.copyFile(currentApiFile, new File(apiFile));
        }
        if (generateDocs) {
            ClearPage.addBundledTemplateDir("assets/templates");
            ArrayList<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>();
            List<String> templates = ClearPage.getTemplateDirs();
            for (String tmpl : templates) {
                resourceLoaders.add(new FileSystemResourceLoader(tmpl));
            }
            templates = ClearPage.getBundledTemplateDirs();
            for (String tmpl : templates) {
                resourceLoaders.add(new ClassResourceLoader(Doclava.class, '/' + tmpl));
            }
            CompositeResourceLoader compositeResourceLoader = new CompositeResourceLoader(resourceLoaders);
            jSilver = new JSilver(compositeResourceLoader);
            if (!Doclava.readTemplateSettings()) {
                return false;
            }
            long startTime = System.nanoTime();
            if (apiVersion != null && sinceTagger.hasVersions()) {
                sinceTagger.addVersion(currentApiFile.getAbsolutePath(), apiVersion);
            }
            sinceTagger.tagAll(project.rootClasses());
            federationTagger.tagAll(project.rootClasses());
            if (proofreadFile != null) {
                Proofread.initProofread(proofreadFile);
            }
            if (todoFile != null) {
                TodoFile.writeTodoFile(todoFile, project);
            }
            if (ClearPage.htmlDir != null) {
                File f = new File(ClearPage.htmlDir);
                if (!f.isDirectory()) {
                    System.err.println("htmlDir not a directory: " + ClearPage.htmlDir);
                    return false;
                }
                Doclava.writeHTMLPages(f);
            } else {
                JarFile thisJar = JarUtils.jarForClass(Doclava.class, null);
                if (thisJar != null) {
                    try {
                        JarUtils.copyResourcesToDirectory(thisJar, "assets/html", ClearPage.outputDir);
                    }
                    catch (IOException e) {
                        System.err.println("Failed to copy html resources.");
                    }
                }
            }
            Doclava.writeAssets();
            NavTree.writeNavTree(assetsOutputDir);
            Doclava.writePackages("reference/packages" + htmlExtension);
            Doclava.writeClassLists();
            Doclava.writeClasses();
            Doclava.writeHierarchy();
            Doclava.writeLists();
            if (keepListFile != null) {
                Doclava.writeKeepList(keepListFile);
            }
            for (SampleCode sc : sampleCodes) {
                sc.write(offlineMode);
            }
            Doclava.writeIndex();
            Proofread.finishProofread();
            if (sdkValuePath != null) {
                Doclava.writeSdkValues(sdkValuePath);
            }
            long time = System.nanoTime() - startTime;
            System.out.println("DroidDoc took " + time / 1000000000L + " sec. to write docs to " + ClearPage.outputDir);
        }
        Errors.printErrors();
        return !Errors.hadError;
    }

    private static void initVisibleClasses(Set<ClassInfo> notStrippable) {
        HashSet<ClassInfo> allTypes = new HashSet<ClassInfo>();
        for (ClassInfo classInfo : Iterables.concat(project.rootClasses(), notStrippable)) {
            classInfo.addAllTypes(allTypes);
        }
        for (DocInfo docInfo : Iterables.concat(project.getAllMethods(), project.getAllFields(), allTypes)) {
            docInfo.comment().initVisible(project);
        }
        for (DocInfo docInfo : Iterables.concat(project.getAllMethods(), project.getAllFields(), allTypes)) {
            docInfo.initVisible(project);
        }
    }

    private static void initVisiblePackages() {
        TreeMap<String, PackageInfo> sorted = new TreeMap<String, PackageInfo>();
        for (ClassInfo cl : project.rootClasses()) {
            PackageInfo pkg = cl.containingPackage();
            String name = pkg == null ? "" : pkg.name();
            sorted.put(name, pkg);
        }
        ImmutableList.Builder result = ImmutableList.builder();
        for (PackageInfo pkg : sorted.values()) {
            pkg.comment().initVisible(project);
        }
        for (PackageInfo pkg : sorted.values()) {
            if (pkg.isHidden()) continue;
            pkg.initVisible(project);
            if (pkg.getAnnotations().isEmpty() && pkg.getInterfaces().isEmpty() && pkg.ordinaryClasses().isEmpty() && pkg.enums().isEmpty() && pkg.exceptions().isEmpty() && pkg.errors().isEmpty() && pkg.inlineTags().isEmpty()) continue;
            result.add(pkg);
        }
        sVisiblePackages = result.build();
    }

    private static void writeIndex() {
        Data data = Doclava.makeHDF();
        ClearPage.write(data, "index.cs", "reference/index" + htmlExtension);
    }

    private static boolean readTemplateSettings() {
        Data data = Doclava.makeHDF();
        htmlExtension = ".html";
        int i = 0;
        while (true) {
            String k = data.getValue("template.escape." + i + ".key", "");
            String v = data.getValue("template.escape." + i + ".value", "");
            if ("".equals(k)) break;
            if (k.length() != 1) {
                System.err.println("template.escape." + i + ".key must have a length of 1: " + k);
                return false;
            }
            escapeChars.put(Character.valueOf(k.charAt(0)), v);
            ++i;
        }
        return true;
    }

    public static String escape(String s) {
        if (escapeChars.size() == 0) {
            return s;
        }
        StringBuffer b = null;
        int begin = 0;
        int N = s.length();
        for (int i = 0; i < N; ++i) {
            char c = s.charAt(i);
            String mapped = escapeChars.get(Character.valueOf(c));
            if (mapped == null) continue;
            if (b == null) {
                b = new StringBuffer(s.length() + mapped.length());
            }
            if (begin != i) {
                b.append(s.substring(begin, i));
            }
            b.append(mapped);
            begin = i + 1;
        }
        if (b != null) {
            if (begin != N) {
                b.append(s.substring(begin, N));
            }
            return b.toString();
        }
        return s;
    }

    public static void setPageTitle(Data data, String title) {
        String s = title;
        if (Doclava.title.length() > 0) {
            s = s + " - " + Doclava.title;
        }
        data.setValue("page.title", s);
    }

    public static LanguageVersion languageVersion() {
        return LanguageVersion.JAVA_1_5;
    }

    public static int optionLength(String option) {
        if (option.equals("-d")) {
            return 2;
        }
        if (option.equals("-templatedir")) {
            return 2;
        }
        if (option.equals("-hdf")) {
            return 3;
        }
        if (option.equals("-toroot")) {
            return 2;
        }
        if (option.equals("-samplecode")) {
            return 4;
        }
        if (option.equals("-htmldir")) {
            return 2;
        }
        if (option.equals("-title")) {
            return 2;
        }
        if (option.equals("-werror")) {
            return 1;
        }
        if (option.equals("-hide")) {
            return 2;
        }
        if (option.equals("-warning")) {
            return 2;
        }
        if (option.equals("-error")) {
            return 2;
        }
        if (option.equals("-keeplist")) {
            return 2;
        }
        if (option.equals("-proofread")) {
            return 2;
        }
        if (option.equals("-todo")) {
            return 2;
        }
        if (option.equals("-public")) {
            return 1;
        }
        if (option.equals("-protected")) {
            return 1;
        }
        if (option.equals("-package")) {
            return 1;
        }
        if (option.equals("-private")) {
            return 1;
        }
        if (option.equals("-hidden")) {
            return 1;
        }
        if (option.equals("-stubs")) {
            return 2;
        }
        if (option.equals("-stubpackages")) {
            return 2;
        }
        if (option.equals("-sdkvalues")) {
            return 2;
        }
        if (option.equals("-apixml")) {
            return 2;
        }
        if (option.equals("-nodocs")) {
            return 1;
        }
        if (option.equals("-parsecomments")) {
            return 1;
        }
        if (option.equals("-since")) {
            return 3;
        }
        if (option.equals("-offlinemode")) {
            return 1;
        }
        if (option.equals("-federate")) {
            return 3;
        }
        if (option.equals("-federationxml")) {
            return 3;
        }
        if (option.equals("-apiversion")) {
            return 2;
        }
        if (option.equals("-assetsdir")) {
            return 2;
        }
        return 0;
    }

    public static boolean validOptions(String[][] options, DocErrorReporter r) {
        for (String[] a : options) {
            if (!a[0].equals("-error") && !a[0].equals("-warning") && !a[0].equals("-hide")) continue;
            try {
                Integer.parseInt(a[1]);
            }
            catch (NumberFormatException e) {
                r.printError("bad -" + a[0] + " value must be a number: " + a[1]);
                return false;
            }
        }
        return true;
    }

    public static Data makeHDF() {
        Data data = jSilver.createData();
        for (String[] p : mHDFData) {
            data.setValue(p[0], p[1]);
        }
        return data;
    }

    public static Data makePackageHDF() {
        Data data = Doclava.makeHDF();
        TreeMap<String, PackageInfo> sorted = new TreeMap<String, PackageInfo>();
        for (ClassInfo cl : project.rootClasses()) {
            PackageInfo pkg = cl.containingPackage();
            String name = pkg == null ? "" : pkg.name();
            sorted.put(name, pkg);
        }
        int i = 0;
        for (String s : sorted.keySet()) {
            PackageInfo pkg = (PackageInfo)sorted.get(s);
            if (pkg.isHidden()) continue;
            Boolean allHidden = true;
            List<ClassInfo> classesToCheck = null;
            for (int pass = 0; pass < 5; ++pass) {
                switch (pass) {
                    case 0: {
                        classesToCheck = pkg.ordinaryClasses();
                        break;
                    }
                    case 1: {
                        classesToCheck = pkg.enums();
                        break;
                    }
                    case 2: {
                        classesToCheck = pkg.errors();
                        break;
                    }
                    case 3: {
                        classesToCheck = pkg.exceptions();
                        break;
                    }
                    case 4: {
                        classesToCheck = pkg.getInterfaces();
                        break;
                    }
                    default: {
                        System.err.println("Error reading package: " + pkg.name());
                    }
                }
                for (ClassInfo cl : classesToCheck) {
                    if (cl.isHidden()) continue;
                    allHidden = false;
                    break;
                }
                if (!allHidden.booleanValue()) break;
            }
            if (allHidden.booleanValue()) continue;
            data.setValue("reference", "1");
            data.setValue("reference.apilevels", sinceTagger.hasVersions() ? "1" : "0");
            data.setValue("docs.packages." + i + ".name", s);
            data.setValue("docs.packages." + i + ".link", pkg.htmlPage());
            data.setValue("docs.packages." + i + ".since.key", SinceTagger.keyForName(pkg.getSince()));
            data.setValue("docs.packages." + i + ".since.name", pkg.getSince());
            TagInfo.makeHDF(data, "docs.packages." + i + ".shortDescr", pkg.firstSentenceTags());
            ++i;
        }
        sinceTagger.writeVersionNames(data);
        return data;
    }

    private static void writeDirectory(File dir, String relative, JSilver js) {
        for (File f : dir.listFiles()) {
            if (f.isFile()) {
                String templ = Doclava.ensureSlash(relative) + f.getName();
                int len = templ.length();
                if (len > 3 && ".cs".equals(templ.substring(len - 3))) {
                    Data data = Doclava.makeHDF();
                    String filename = templ.substring(0, len - 3) + htmlExtension;
                    ClearPage.write(data, templ, filename, js);
                    continue;
                }
                if (len > 3 && ".jd".equals(templ.substring(len - 3))) {
                    String filename = templ.substring(0, len - 3) + htmlExtension;
                    DocFile.writePage(f.getAbsolutePath(), filename);
                    continue;
                }
                ClearPage.copyFile(f, new File(Doclava.ensureSlash(ClearPage.outputDir) + templ));
                continue;
            }
            if (!f.isDirectory()) continue;
            Doclava.writeDirectory(f, Doclava.ensureSlash(relative) + f.getName() + "/", js);
        }
    }

    public static void writeHTMLPages(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + dir);
        }
        FileSystemResourceLoader loader = new FileSystemResourceLoader(dir);
        JSilver js = new JSilver(loader);
        Doclava.writeDirectory(dir, "", js);
    }

    public static void writeAssets() {
        List<String> templateDirs;
        JarFile thisJar = JarUtils.jarForClass(Doclava.class, null);
        if (thisJar != null) {
            try {
                templateDirs = ClearPage.getBundledTemplateDirs();
                for (String templateDir : templateDirs) {
                    String assetsDir = Doclava.ensureSlash(templateDir) + "assets";
                    JarUtils.copyResourcesToDirectory(thisJar, assetsDir, Doclava.ensureSlash(ClearPage.outputDir) + assetsOutputDir);
                }
            }
            catch (IOException e) {
                System.err.println("Error copying assets directory.");
                e.printStackTrace();
                return;
            }
        }
        templateDirs = ClearPage.getTemplateDirs();
        for (String templateDir : templateDirs) {
            File assets = new File(Doclava.ensureSlash(templateDir) + "assets");
            if (!assets.isDirectory()) continue;
            Doclava.writeDirectory(assets, assetsOutputDir, null);
        }
    }

    public static void writeLists() {
        Data data = Doclava.makeHDF();
        List<ClassInfo> classes = project.rootClasses();
        TreeMap<String, DocInfo> sorted = new TreeMap<String, DocInfo>();
        for (ClassInfo cl : classes) {
            if (cl.isHidden()) continue;
            sorted.put(cl.qualifiedName(), cl);
            PackageInfo pkg = cl.containingPackage();
            String name = pkg == null ? "" : pkg.name();
            sorted.put(name, pkg);
        }
        int i = 0;
        for (String s : sorted.keySet()) {
            data.setValue("docs.pages." + i + ".id", "" + i);
            data.setValue("docs.pages." + i + ".label", s);
            Object o = sorted.get(s);
            if (o instanceof PackageInfo) {
                PackageInfo pkg = (PackageInfo)o;
                data.setValue("docs.pages." + i + ".link", pkg.htmlPage());
                data.setValue("docs.pages." + i + ".type", "package");
            } else if (o instanceof ClassInfo) {
                ClassInfo cl = (ClassInfo)o;
                data.setValue("docs.pages." + i + ".link", cl.htmlPage());
                data.setValue("docs.pages." + i + ".type", "class");
            }
            ++i;
        }
        ClearPage.write(data, "lists.cs", "reference/lists.js");
    }

    public static void cantStripThis(ClassInfo cl, HashSet<ClassInfo> notStrippable) {
        if (!notStrippable.add(cl)) {
            return;
        }
        ClassInfo supr = cl.superclass();
        if (supr != null) {
            Doclava.cantStripThis(supr, notStrippable);
        }
        for (ClassInfo iface : cl.getInterfaces()) {
            Doclava.cantStripThis(iface, notStrippable);
        }
    }

    private static String getPrintableName(ClassInfo cl) {
        ClassInfo containingClass = cl.containingClass();
        if (containingClass != null) {
            String baseName = cl.name();
            baseName = baseName.substring(baseName.lastIndexOf(46) + 1);
            return Doclava.getPrintableName(containingClass) + '$' + baseName;
        }
        return cl.qualifiedName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeKeepList(String filename) {
        HashSet<ClassInfo> notStrippable = new HashSet<ClassInfo>();
        List<ClassInfo> all = project.allClasses();
        Collections.sort(all);
        for (ClassInfo cl : all) {
            if (!cl.isPublic() || cl.isHidden()) continue;
            Doclava.cantStripThis(cl, notStrippable);
        }
        PrintStream stream = null;
        try {
            stream = new PrintStream(filename);
            for (ClassInfo cl : notStrippable) {
                stream.println(Doclava.getPrintableName(cl));
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("error writing file: " + filename);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static List<PackageInfo> getVisiblePackages() {
        if (sVisiblePackages == null) {
            throw new IllegalStateException("display packages not yet initialized!");
        }
        return sVisiblePackages;
    }

    public static void writePackages(String filename) {
        Data data = Doclava.makePackageHDF();
        int i = 0;
        for (PackageInfo pkg : Doclava.getVisiblePackages()) {
            Doclava.writePackage(pkg);
            data.setValue("docs.packages." + i + ".name", pkg.name());
            data.setValue("docs.packages." + i + ".link", pkg.htmlPage());
            TagInfo.makeHDF(data, "docs.packages." + i + ".shortDescr", pkg.firstSentenceTags());
            ++i;
        }
        Doclava.setPageTitle(data, "Package Index");
        TagInfo.makeHDF(data, "root.descr", project.getRootTags());
        ClearPage.write(data, "packages.cs", filename);
        ClearPage.write(data, "package-list.cs", "reference/package-list");
        Proofread.writePackages(filename, project.getRootTags());
    }

    public static void writePackage(PackageInfo pkg) {
        Data data = Doclava.makePackageHDF();
        String name = pkg.name();
        data.setValue("package.name", name);
        data.setValue("package.since.key", SinceTagger.keyForName(pkg.getSince()));
        data.setValue("package.since.name", pkg.getSince());
        data.setValue("package.descr", "...description...");
        pkg.setFederatedReferences(data, "package");
        Doclava.makeClassListHDF(data, "package.annotations", pkg.getAnnotations());
        Doclava.makeClassListHDF(data, "package.interfaces", pkg.getInterfaces());
        Doclava.makeClassListHDF(data, "package.classes", pkg.ordinaryClasses());
        Doclava.makeClassListHDF(data, "package.enums", pkg.enums());
        Doclava.makeClassListHDF(data, "package.exceptions", pkg.exceptions());
        Doclava.makeClassListHDF(data, "package.errors", pkg.errors());
        List<TagInfo> shortDescrTags = pkg.firstSentenceTags();
        List<TagInfo> longDescrTags = pkg.inlineTags();
        TagInfo.makeHDF(data, "package.shortDescr", shortDescrTags);
        TagInfo.makeHDF(data, "package.descr", longDescrTags);
        data.setValue("package.hasLongDescr", TagInfo.tagsEqual(shortDescrTags, longDescrTags) ? "0" : "1");
        String filename = javadocDir + pkg.relativePath();
        Doclava.setPageTitle(data, name);
        ClearPage.write(data, "package.cs", filename);
        filename = javadocDir + pkg.fullDescriptionFile();
        Doclava.setPageTitle(data, name + " Details");
        ClearPage.write(data, "package-descr.cs", filename);
        Proofread.writePackage(filename, pkg.inlineTags());
    }

    public static void writeClassLists() {
        String s;
        int i;
        Data data = Doclava.makePackageHDF();
        List<ClassInfo> classes = Visibility.filterHidden(project.rootClasses());
        if (classes.isEmpty()) {
            return;
        }
        Object[] sorted = new Sorter[classes.size()];
        for (i = 0; i < sorted.length; ++i) {
            ClassInfo cl = classes.get(i);
            String name = cl.name();
            sorted[i] = new Sorter(name, cl);
        }
        Arrays.sort(sorted);
        int firstMatch = 0;
        String lastName = ((Sorter)sorted[0]).label;
        for (i = 1; i < sorted.length; ++i) {
            s = ((Sorter)sorted[i]).label;
            if (lastName.equals(s)) continue;
            if (firstMatch != i - 1) {
                for (int j = firstMatch; j < i; ++j) {
                    PackageInfo pkg = ((ClassInfo)((Sorter)sorted[j]).data).containingPackage();
                    if (pkg == null) continue;
                    ((Sorter)sorted[j]).label = ((Sorter)sorted[j]).label + " (" + pkg.name() + ")";
                }
            }
            firstMatch = i;
            lastName = s;
        }
        Arrays.sort(sorted);
        for (i = 0; i < sorted.length; ++i) {
            s = ((Sorter)sorted[i]).label;
            ClassInfo cl = (ClassInfo)((Sorter)sorted[i]).data;
            char first = Character.toUpperCase(s.charAt(0));
            cl.makeShortDescrHDF(data, "docs.classes." + first + '.' + i);
        }
        Doclava.setPageTitle(data, "Class Index");
        ClearPage.write(data, "classes.cs", "reference/classes" + htmlExtension);
    }

    public static void writeHierarchy() {
        ArrayList<ClassInfo> info = new ArrayList<ClassInfo>();
        for (ClassInfo cl : project.rootClasses()) {
            if (cl.isHidden()) continue;
            info.add(cl);
        }
        Data data = Doclava.makePackageHDF();
        Hierarchy.makeHierarchy(data, info.toArray(new ClassInfo[info.size()]), project);
        Doclava.setPageTitle(data, "Class Hierarchy");
        ClearPage.write(data, "hierarchy.cs", "reference/hierarchy" + htmlExtension);
    }

    public static void writeClasses() {
        for (ClassInfo cl : project.rootClasses()) {
            Data data = Doclava.makePackageHDF();
            if (cl.isHidden()) continue;
            Doclava.writeClass(cl, data);
        }
    }

    public static void writeClass(ClassInfo cl, Data data) {
        cl.makeHDF(data, project.rootClasses());
        Doclava.setPageTitle(data, cl.name());
        ClearPage.write(data, "class.cs", javadocDir + cl.relativePath());
        Proofread.writeClass(cl.htmlPage(), cl);
    }

    public static void makeClassListHDF(Data data, String base, List<ClassInfo> classes) {
        int i = 0;
        for (ClassInfo cl : classes) {
            if (!cl.isHidden()) {
                cl.makeShortDescrHDF(data, base + "." + i);
            }
            ++i;
        }
    }

    private static boolean hasHideAnnotation(Doc doc) {
        String comment = doc.getRawCommentText();
        return comment.indexOf("@hide") != -1 || comment.indexOf("@pending") != -1;
    }

    private static boolean isHidden(Doc doc) {
        if (doc instanceof MemberDoc) {
            return Doclava.hasHideAnnotation(doc);
        }
        if (doc instanceof ClassDoc) {
            ClassDoc classDoc = (ClassDoc)doc;
            if (Doclava.hasHideAnnotation((Doc)classDoc.containingPackage())) {
                return true;
            }
            ClassDoc current = classDoc;
            do {
                if (!Doclava.hasHideAnnotation((Doc)current)) continue;
                return true;
            } while ((current = current.containingClass()) != null);
        }
        return false;
    }

    private static Object filterHidden(Object o, Class<?> expected) {
        if (o == null) {
            return null;
        }
        Class<?> type = o.getClass();
        if (type.getName().startsWith("com.sun.")) {
            return Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), (InvocationHandler)new HideHandler(o));
        }
        if (o instanceof Object[]) {
            Class<?> componentType = expected.getComponentType();
            Object[] array = (Object[])o;
            ArrayList<Object> list = new ArrayList<Object>(array.length);
            for (Object entry : array) {
                if (entry instanceof Doc && Doclava.isHidden((Doc)entry)) continue;
                list.add(Doclava.filterHidden(entry, componentType));
            }
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        return o;
    }

    private static void writeSdkValues(String output) {
        ArrayList<String> activityActions = new ArrayList<String>();
        ArrayList<String> broadcastActions = new ArrayList<String>();
        ArrayList<String> serviceActions = new ArrayList<String>();
        ArrayList<String> categories = new ArrayList<String>();
        ArrayList<String> features = new ArrayList<String>();
        ArrayList<ClassInfo> layouts = new ArrayList<ClassInfo>();
        ArrayList<ClassInfo> widgets = new ArrayList<ClassInfo>();
        ArrayList<ClassInfo> layoutParams = new ArrayList<ClassInfo>();
        for (ClassInfo clazz : project.allClasses()) {
            PackageInfo pckg;
            String packageName;
            block6: for (FieldInfo field : clazz.allSelfFields()) {
                AnnotationInstanceInfo[] annotations;
                Object cValue = field.constantValue();
                if (cValue == null || (annotations = field.annotations()).length <= 0) continue;
                for (AnnotationInstanceInfo annotation : annotations) {
                    if (!SDK_CONSTANT_ANNOTATION.equals(annotation.type().qualifiedName())) continue;
                    AnnotationValueInfo[] values = annotation.elementValues();
                    if (values.length <= 0) continue block6;
                    String type = values[0].valueString();
                    if (SDK_CONSTANT_TYPE_ACTIVITY_ACTION.equals(type)) {
                        activityActions.add(cValue.toString());
                        continue block6;
                    }
                    if (SDK_CONSTANT_TYPE_BROADCAST_ACTION.equals(type)) {
                        broadcastActions.add(cValue.toString());
                        continue block6;
                    }
                    if (SDK_CONSTANT_TYPE_SERVICE_ACTION.equals(type)) {
                        serviceActions.add(cValue.toString());
                        continue block6;
                    }
                    if (SDK_CONSTANT_TYPE_CATEGORY.equals(type)) {
                        categories.add(cValue.toString());
                        continue block6;
                    }
                    if (!SDK_CONSTANT_TYPE_FEATURE.equals(type)) continue block6;
                    features.add(cValue.toString());
                    continue block6;
                }
            }
            if (clazz.isHidden() || !clazz.isPublic() || clazz.isAbstract()) continue;
            boolean annotated = false;
            AnnotationInstanceInfo[] annotations = clazz.annotations();
            if (annotations.length > 0) {
                for (AnnotationInstanceInfo annotation : annotations) {
                    if (SDK_WIDGET_ANNOTATION.equals(annotation.type().qualifiedName())) {
                        widgets.add(clazz);
                        annotated = true;
                        break;
                    }
                    if (!SDK_LAYOUT_ANNOTATION.equals(annotation.type().qualifiedName())) continue;
                    layouts.add(clazz);
                    annotated = true;
                    break;
                }
            }
            if (annotated || !"android.widget".equals(packageName = (pckg = clazz.containingPackage()).name()) && !"android.view".equals(packageName)) continue;
            int type = Doclava.checkInheritance(clazz);
            switch (type) {
                case 1: {
                    widgets.add(clazz);
                    break;
                }
                case 2: {
                    layouts.add(clazz);
                    break;
                }
                case 3: {
                    layoutParams.add(clazz);
                }
            }
        }
        Collections.sort(activityActions);
        Doclava.writeValues(output + "/activity_actions.txt", activityActions);
        Collections.sort(broadcastActions);
        Doclava.writeValues(output + "/broadcast_actions.txt", broadcastActions);
        Collections.sort(serviceActions);
        Doclava.writeValues(output + "/service_actions.txt", serviceActions);
        Collections.sort(categories);
        Doclava.writeValues(output + "/categories.txt", categories);
        Collections.sort(features);
        Doclava.writeValues(output + "/features.txt", features);
        int i = 0;
        while (i < layoutParams.size()) {
            ClassInfo layoutParamClass = (ClassInfo)layoutParams.get(i);
            ClassInfo containingClass = layoutParamClass.containingClass();
            if (containingClass == null || layouts.indexOf(containingClass) == -1) {
                layoutParams.remove(i);
                continue;
            }
            ++i;
        }
        Doclava.writeClasses(output + "/widgets.txt", widgets, layouts, layoutParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeValues(String pathname, ArrayList<String> values) {
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(pathname, false);
            bw = new BufferedWriter(fw);
            for (String value : values) {
                bw.append(value).append('\n');
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {}
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeClasses(String pathname, ArrayList<ClassInfo> widgets, ArrayList<ClassInfo> layouts, ArrayList<ClassInfo> layoutParams) {
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(pathname, false);
            bw = new BufferedWriter(fw);
            for (ClassInfo clazz : widgets) {
                Doclava.writeClass(bw, clazz, 'W');
            }
            for (ClassInfo clazz : layoutParams) {
                Doclava.writeClass(bw, clazz, 'P');
            }
            for (ClassInfo clazz : layouts) {
                Doclava.writeClass(bw, clazz, 'L');
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {}
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static void writeClass(BufferedWriter writer, ClassInfo clazz, char prefix) throws IOException {
        writer.append(prefix).append(clazz.qualifiedName());
        ClassInfo superClass = clazz;
        while ((superClass = superClass.superclass()) != null) {
            writer.append(' ').append(superClass.qualifiedName());
        }
        writer.append('\n');
    }

    private static int checkInheritance(ClassInfo clazz) {
        if ("android.view.ViewGroup".equals(clazz.qualifiedName())) {
            return 2;
        }
        if ("android.view.View".equals(clazz.qualifiedName())) {
            return 1;
        }
        if ("android.view.ViewGroup.LayoutParams".equals(clazz.qualifiedName())) {
            return 3;
        }
        ClassInfo parent = clazz.superclass();
        if (parent != null) {
            return Doclava.checkInheritance(parent);
        }
        return 0;
    }

    static String ensureSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    static {
        mHDFData = new ArrayList();
        escapeChars = new HashMap<Character, String>();
        title = "";
        sinceTagger = new SinceTagger();
        federationTagger = new FederationTagger();
        generateDocs = true;
        parseComments = false;
        apiVersion = null;
        jSilver = null;
        sVisiblePackages = null;
    }

    private static class HideHandler
    implements InvocationHandler {
        private final Object target;

        public HideHandler(Object target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (args != null && (methodName.equals("compareTo") || methodName.equals("equals") || methodName.equals("overrides") || methodName.equals("subclassOf"))) {
                args[0] = HideHandler.unwrap(args[0]);
            }
            if (methodName.equals("getRawCommentText")) {
                return this.filterComment((String)method.invoke(this.target, args));
            }
            if (proxy instanceof Type && methodName.equals("toString")) {
                return ((String)method.invoke(this.target, args)).replace("&", "&amp;");
            }
            try {
                return Doclava.filterHidden(method.invoke(this.target, args), method.getReturnType());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        private String filterComment(String s) {
            if (s == null) {
                return null;
            }
            s = s.trim();
            while (s.length() >= 5 && s.charAt(s.length() - 5) == '{') {
                s = s + "&nbsp;";
            }
            return s;
        }

        private static Object unwrap(Object proxy) {
            if (proxy instanceof Proxy) {
                return ((HideHandler)Proxy.getInvocationHandler((Object)proxy)).target;
            }
            return proxy;
        }
    }
}

