package ${package};



import com.cisco.framework.FrameworkServiceLocator;
import ${package}.services.IGreetMeService;
import ${package}.services.config.model.GreetMeRequestType;
import ${package}.services.config.model.GreetMeResponseType;
import ${package}.services.config.model.ObjectFactory;
import ${package}.services.config.model.impl.NameTypeImpl;

public class SDFClient {

	//static Logger log = Logger.getLogger(SDFClient.class);
	
	public static void main(String[] args) {

		try {
			// 1. Get Locator
			FrameworkServiceLocator locator = FrameworkServiceLocator.getInstance();

			// 2. Get Service handle using locator
			IGreetMeService service = (IGreetMeService) locator.getService("GreetMeService");

			// 3. Create Input
			ObjectFactory obj = new ObjectFactory();
			GreetMeRequestType greetMeRequest = (GreetMeRequestType) obj.createGreetMeRequestType();

			NameTypeImpl nm = new NameTypeImpl();
			greetMeRequest.setSalutation("Mr.");
			nm.setFirst("Services");
			nm.setSecond("User");
			greetMeRequest.setName(nm);
			

			// 4. Invoke Service
			GreetMeResponseType greetMeResponse = service.greetMe(greetMeRequest); 
			
			
			System.out.println("Greeting : " + greetMeResponse.getGreeting());
			System.out.println("Current time is : " + greetMeResponse.getTime().getTime());

		} catch (Exception e) {
			System.out.println(e.toString());
		}
	}
}
