/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.testng.IMethodSelector;
import org.testng.ITestNGMethod;
import org.testng.internal.DefaultMethodSelectorContext;
import org.testng.internal.MethodSelectorDescriptor;
import org.testng.internal.Utils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunInfo
implements Serializable {
    private transient List<MethodSelectorDescriptor> m_methodSelectors = new ArrayList<MethodSelectorDescriptor>();

    public void addMethodSelector(IMethodSelector selector, int priority) {
        Utils.log("RunInfo", 3, new StringBuffer().append("Adding method selector: ").append(selector).append(" priority: ").append(priority).toString());
        MethodSelectorDescriptor md = new MethodSelectorDescriptor(selector, priority);
        this.m_methodSelectors.add(md);
    }

    public boolean includeMethod(ITestNGMethod tm, boolean isTestMethod) {
        Collections.sort(this.m_methodSelectors);
        boolean foundNegative = false;
        DefaultMethodSelectorContext context = new DefaultMethodSelectorContext();
        boolean result = false;
        for (MethodSelectorDescriptor mds : this.m_methodSelectors) {
            if (!foundNegative) {
                boolean bl = foundNegative = mds.getPriority() < 0;
            }
            if (foundNegative && mds.getPriority() >= 0) break;
            IMethodSelector md = mds.getMethodSelector();
            result = md.includeMethod(context, tm, isTestMethod);
            if (!context.isStopped()) continue;
            return result;
        }
        return result;
    }

    public static void ppp(String s) {
        System.out.println(new StringBuffer().append("[RunInfo] ").append(s).toString());
    }

    public void setTestMethods(List<ITestNGMethod> testMethods) {
        for (MethodSelectorDescriptor mds : this.m_methodSelectors) {
            mds.setTestMethods(testMethods);
        }
    }
}

