/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.testng.TestNGException;
import org.testng.internal.ClassHelper;
import org.testng.reporters.XMLStringBuffer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlClass
implements Serializable,
Cloneable {
    private List<String> m_includedMethods = new ArrayList<String>();
    private List<String> m_excludedMethods = new ArrayList<String>();
    private String m_name = null;
    private Class m_class = null;

    public XmlClass(String name) {
        this.init(name, null);
    }

    public XmlClass(Class className) {
        this.init(className.getName(), className);
    }

    private void init(String name, Class className) {
        this.m_name = name;
        this.m_class = className;
    }

    public Class getSupportClass() {
        if (null == this.m_class) {
            this.m_class = ClassHelper.forName(this.m_name);
            if (null == this.m_class) {
                throw new TestNGException(new StringBuffer().append("Cannot find class in classpath: ").append(this.m_name).toString());
            }
        }
        return this.m_class;
    }

    public void setClass(Class className) {
        this.m_class = className;
    }

    public List<String> getExcludedMethods() {
        return this.m_excludedMethods;
    }

    public void setExcludedMethods(List<String> excludedMethods) {
        this.m_excludedMethods = excludedMethods;
    }

    public List<String> getIncludedMethods() {
        return this.m_includedMethods;
    }

    public void setIncludedMethods(List<String> includedMethods) {
        this.m_includedMethods = includedMethods;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String toString() {
        return new StringBuffer().append("[Class: ").append(this.m_name).append("]").toString();
    }

    public String toXml(String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        Properties pro = new Properties();
        pro.setProperty("name", this.getName());
        if (!this.m_includedMethods.isEmpty() || !this.m_excludedMethods.isEmpty()) {
            Properties p;
            xsb.push("class", pro);
            xsb.push("methods");
            for (String m : this.getIncludedMethods()) {
                p = new Properties();
                p.setProperty("name", m);
                xsb.addEmptyElement("include", p);
            }
            for (String m : this.getExcludedMethods()) {
                p = new Properties();
                p.setProperty("name", m);
                xsb.addEmptyElement("exclude", p);
            }
            xsb.pop("methods");
            xsb.pop("class");
        } else {
            xsb.addEmptyElement("class", pro);
        }
        return xsb.toXML();
    }

    public Object clone() {
        XmlClass result = new XmlClass(this.getName());
        result.setExcludedMethods(this.getExcludedMethods());
        result.setIncludedMethods(this.getIncludedMethods());
        return result;
    }
}

